/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.config;

import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.Maske;
import de.superx.common.NotYetImplementedException;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.rest.config.HisDynamicFieldConfigurator;
import de.superx.rest.config.ValueFormatTool;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.HisDynamicFieldConfig;
import de.superx.rest.model.Item;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class HisDynamicMultiSelectConfigurator
extends HisDynamicFieldConfigurator {
    private ValueFormatTool valueFormatTool = null;

    public HisDynamicMultiSelectConfigurator(Maske maske, Field field, SxUser user) throws NotYetImplementedException {
        this.maske = maske;
        this.field = field;
        this.user = user;
        this.valueFormatTool = HisDynamicMultiSelectConfigurator.createValueFormatTool(field);
    }

    @Override
    public HisDynamicFieldConfig createConfig(String currentSelection) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
        FieldContainer maskenFelder = this.maske.getIndividualFields();
        if (!this.valueFormatTool.confirmFormat(currentSelection)) {
            throw new UngueltigeEingabeException("Multiselectauswahl muss im Listenformat sein");
        }
        this.field.setInited(false);
        Hashtable formular = this.maske.getFormularCopy();
        HashMap map = new HashMap();
        map.put("UserIsAdmin", this.user.getBasicMap().get("UserIsAdmin"));
        this.field.updateDefaultValue(formular, map, maskenFelder, null, false, this.user);
        this.config = HisDynamicMultiSelectConfigurator.createMultiSelectUpdate(this.field, currentSelection);
        return this.config;
    }

    @Override
    public String escapeForFormular(String inputValue) throws UngueltigeEingabeException {
        return this.valueFormatTool.escapeForFormular(inputValue);
    }

    @Override
    public String getUpdatedFormularValue() {
        String newSelectionValue = "";
        if (this.config.defaultValue != null) {
            if (!(this.config.defaultValue instanceof String[])) {
                throw new RuntimeException("Unexpected Type Error");
            }
            CharSequence[] newSelections = (String[])this.config.defaultValue;
            newSelectionValue = String.join((CharSequence)",", newSelections);
            newSelectionValue = this.tryEscapeForFormular(newSelectionValue);
        }
        return newSelectionValue;
    }

    private String tryEscapeForFormular(String inputValue) {
        String resultValue = inputValue;
        try {
            resultValue = this.escapeForFormular(resultValue);
        }
        catch (UngueltigeEingabeException ungueltigeEingabeException) {
            // empty catch block
        }
        return resultValue;
    }

    private static HisDynamicFieldConfig createMultiSelectUpdate(Field field, String param) {
        String[] defaultValue;
        HisDynamicFieldConfig formField = new HisDynamicFieldConfig(field, FieldType.MultiSelect);
        List<Item> items = HisDynamicMultiSelectConfigurator.createSelectableItems(field);
        formField.setItems(items);
        String[] selectedValues = HisDynamicMultiSelectConfigurator.toStringArray(param);
        formField.defaultValue = defaultValue = HisDynamicMultiSelectConfigurator.filterValidValues(items, selectedValues);
        if (defaultValue.length == 0) {
            formField.defaultValue = null;
        }
        return formField;
    }
}

