/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import de.superx.spring.batch.job.JobUtils;
import de.superx.util.PathAndFileUtils;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;

public class JobExecutionInfo {
    public Long jobExecutionId;
    public String component;
    public String jobName;
    public Date startTime;
    public Date endTime;
    public Long duration;
    public ExitStatus exitStatus;
    private static final Logger logger = Logger.getLogger(JobExecutionInfo.class);

    public JobExecutionInfo(Long id) {
        this.jobExecutionId = id;
    }

    public JobExecutionInfo() {
    }

    public JobExecutionInfo(JobExecution jobExecution) {
        this.jobExecutionId = jobExecution.getId();
        this.jobName = jobExecution.getJobInstance().getJobName();
        this.exitStatus = new ExitStatus(jobExecution.getExitStatus().getExitCode());
        this.endTime = JobUtils.convertLocalDateToDate(jobExecution.getEndTime());
        this.startTime = JobUtils.convertLocalDateToDate(jobExecution.getStartTime());
        String abbreviation = this.jobName.split(" ")[0].toLowerCase();
        if (abbreviation.equals("install")) {
            abbreviation = "kern";
        }
        try {
            this.component = abbreviation.equals("-") ? abbreviation : PathAndFileUtils.getComponentName(abbreviation);
        }
        catch (IOException iox) {
            logger.error((Object)("Unknown component abbreviation: " + abbreviation));
            this.component = "!UNKNOWN!";
        }
    }
}

