/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.superx.jdbc.entity.Konstante;
import de.superx.jdbc.repository.KonstanteRepository;
import de.superx.job.ActionNode;
import de.superx.job.ContainerNode;
import de.superx.rest.JobExecutionInfo;
import de.superx.rest.JobLog;
import de.superx.rest.JobParamKonstanten;
import de.superx.rest.RestControllerBase;
import de.superx.rest.model.job.Component;
import de.superx.rest.model.job.Connector;
import de.superx.rest.model.job.ExitStatusMixIn;
import de.superx.rest.model.job.JobExecutionStatus;
import de.superx.rest.model.job.StepExecutionStatus;
import de.superx.rest.util.ComponentComparator;
import de.superx.spring.batch.His1DataSources;
import de.superx.spring.batch.job.BiJobLoggingListener;
import de.superx.spring.batch.job.JobUtils;
import de.superx.spring.batch.tasklet.TaskletContext;
import de.superx.spring.batch.util.StepCounter;
import de.superx.spring.service.BatchJobDescriptionAdapter;
import de.superx.spring.service.DbJobDescriptionAdapter;
import de.superx.spring.service.EntityJobDescriptionSource;
import de.superx.spring.service.JobDescriptionSource;
import de.superx.spring.service.JsonJobDescriptionAdapter;
import de.superx.spring.service.UserService;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.support.TaskExecutorJobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/etl"})
public class EtlJobApi
extends RestControllerBase {
    static Logger logger = Logger.getLogger(EtlJobApi.class);
    @Autowired
    JobLauncher jobLauncher;
    private static boolean RUN_SYNC = false;
    @Autowired
    JobRepository jobRepository;
    @Autowired
    JobExplorer jobExplorer;
    @Autowired
    JobOperator jobOperator;
    @Autowired
    JobRegistry jobRegistry;
    @Autowired
    DataSource dataSource;
    @Autowired
    His1DataSources dataSources;
    @Autowired
    UserService userService;
    @Autowired
    KonstanteRepository konstanteRepository;
    @Autowired
    @Qualifier(value="jobAdapter")
    JobDescriptionSource jobDescriptionSource;
    @Autowired
    DbJobDescriptionAdapter dbJobDescriptionAdapter;
    @Autowired
    EntityJobDescriptionSource entityJobDescriptionSource;
    @Autowired
    JsonJobDescriptionAdapter jsonJobDescriptionAdapter;
    @Autowired
    BatchJobDescriptionAdapter batchJobDescriptionAdapter;
    private BiJobLoggingListener jobLoggingListener;
    private TaskletContext taskletContext;
    private static final ObjectMapper EXIT_STATUS_MAPPER = EtlJobApi.exit_status_mapper();

    private static ObjectMapper exit_status_mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.addMixIn(ExitStatus.class, ExitStatusMixIn.class);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    @RequestMapping(path={"/list"}, method={RequestMethod.GET})
    public List<Component> getEtlJobs() {
        return this.userService.filterComponents(this.getAllComponentAndConnectorDetails());
    }

    @RequestMapping(path={"/installables/list"}, method={RequestMethod.GET})
    public List<Component> getInstallJobs() {
        this.userService.checkAdminRights();
        List<Component> installabels = this.getInstallables();
        logger.debug((Object)("Returning " + installabels.size() + " components"));
        return installabels;
    }

    @RequestMapping(path={"/job/stopAll"}, method={RequestMethod.GET})
    public boolean stopAllJobs() {
        this.userService.checkAdminRights();
        JobUtils.terminateAllJobExecutions(this.jobExplorer, this.jobOperator);
        return true;
    }

    @RequestMapping(path={"/job/list"}, method={RequestMethod.GET})
    public List<ContainerNode> getAllJobs() {
        this.userService.checkAdminRights();
        return this.jobDescriptionSource.readJobs();
    }

    @RequestMapping(path={"/job/list/{abbreviation}"}, method={RequestMethod.GET})
    public List<ContainerNode> getAllJobForComponent(@PathVariable(value="abbreviation") String abbreviation) {
        this.userService.checkAdminRights();
        return this.jobDescriptionSource.getJobsForComponent(abbreviation);
    }

    @RequestMapping(path={"/job/writeJobsToDb"}, method={RequestMethod.GET})
    public boolean writeJobsToDb() {
        try {
            List<ContainerNode> jobs = this.entityJobDescriptionSource.readJobs();
            for (ContainerNode containerNode : jobs) {
                try {
                    this.dbJobDescriptionAdapter.writeToDb(containerNode);
                }
                catch (Exception e) {
                    logger.error((Object)("Error writing job " + containerNode.name), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error writing jobs to DB", (Throwable)e);
            throw e;
        }
        return true;
    }

    @RequestMapping(path={"/job/{id}"}, method={RequestMethod.GET})
    public ContainerNode getJob(@PathVariable(value="id") String id) {
        this.userService.checkEtlJobRights();
        ContainerNode root = this.jobDescriptionSource.getJobById(id);
        return root;
    }

    @RequestMapping(path={"/job/save"}, method={RequestMethod.POST})
    public Long saveJob(@RequestBody Map<String, Object> jobJson) throws Exception {
        ContainerNode container = (ContainerNode)this.jsonJobDescriptionAdapter.convert(jobJson);
        container.setCustom(1);
        return this.dbJobDescriptionAdapter.writeToDb(container);
    }

    @RequestMapping(path={"/job/execute/{sourceDatabase}"}, method={RequestMethod.POST})
    public Long executeJob(@PathVariable(value="sourceDatabase") String sourceDatabase, @RequestBody Map<String, Object> jobJson) throws Exception {
        this.userService.checkAdminRights();
        ContainerNode container = (ContainerNode)this.jsonJobDescriptionAdapter.convert(jobJson);
        ContainerNode root = this.jobDescriptionSource.getJobById(container.id);
        EtlJobApi.applySettings(root, container);
        return this.executeJob(sourceDatabase, container);
    }

    @RequestMapping(path={"/job/execute/{sourceDatabase}/{id}"}, method={RequestMethod.GET})
    public Long executeJob(@PathVariable(value="sourceDatabase") String sourceDatabase, @PathVariable(value="id") String id) throws DuplicateJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        int compEndIndex = id.indexOf(95);
        String component = id.substring(0, compEndIndex).toLowerCase();
        String sourcedb = this.getDataSource(component);
        ContainerNode root = Optional.ofNullable(this.jobDescriptionSource.getJobById(id)).orElseThrow(() -> new IllegalArgumentException("Job with ID '" + id + "' not found"));
        if (root.getJobType().equals((Object)ContainerNode.JobType.special)) {
            List<String> sourceSystems = PathAndFileUtils.findSourceSystems(component);
            for (String s : sourceSystems) {
                if (!id.substring(1).contains(s)) continue;
                sourcedb = s;
                break;
            }
        }
        if (sourceDatabase != null) {
            sourcedb = sourceDatabase;
        }
        if (root.getJobType().equals((Object)ContainerNode.JobType.install_upgrade)) {
            JobParametersBuilder parameterBuilder = new JobParametersBuilder();
            try {
                parameterBuilder.addJobParameters(this.createVersionParameter(component));
                parameterBuilder.addJobParameters(this.createChecksumParameter(component));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.executeJob(sourcedb, root, parameterBuilder.toJobParameters());
        }
        return this.executeJob(sourcedb, root);
    }

    private static void applySettings(ActionNode actions, ActionNode settings) throws Exception {
        if (!actions.getClass().equals(settings.getClass()) || !actions.name.equals(settings.name)) {
            throw new Exception("each corresponding 'action' and 'settings' node must have common type and name");
        }
        actions.active = settings.active;
        if (actions instanceof ContainerNode) {
            List<ActionNode> aChildren = ((ContainerNode)actions).getActions();
            List<ActionNode> sChildren = ((ContainerNode)settings).getActions();
            if (aChildren.size() != sChildren.size()) {
                throw new Exception("'actions' and 'settings' node must have corresponding data structure");
            }
            for (int i = 0; i < aChildren.size(); ++i) {
                EtlJobApi.applySettings(aChildren.get(i), sChildren.get(i));
            }
        }
    }

    public Long executeJob(String sourceDatabase, ContainerNode root) throws DuplicateJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        return this.executeJob(sourceDatabase, root, null);
    }

    public void executeJobSync(String sourceDatabase, ContainerNode root) throws DuplicateJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        try {
            this.setSyncExecution();
            this.executeJob(sourceDatabase, root);
        }
        finally {
            this.unsetSyncExecution();
        }
    }

    public Long executeJob(String sourceDatabase, ContainerNode root, JobParameters additionalParameters) throws DuplicateJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        Job job = this.createBatchJob(root, sourceDatabase, stepCounter);
        return this.startJob(job, stepCounter.getCount(), additionalParameters);
    }

    @RequestMapping(path={"/job/install/{component}"}, method={RequestMethod.GET})
    public Long executeInstall(@PathVariable(value="component") String component) throws Exception {
        this.userService.checkAdminRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = this.jobDescriptionSource.getInstallUpgradeJob(component);
        root.getActions().forEach(n -> {
            if (n.id.equals(component.toLowerCase() + "_preupgrade_containernode")) {
                n.active = false;
            }
        });
        Job job = this.createBatchJob(root, null, stepCounter);
        JobParametersBuilder parameterBuilder = new JobParametersBuilder();
        parameterBuilder.addJobParameters(this.createVersionParameter(component));
        parameterBuilder.addJobParameters(this.createChecksumParameter(component));
        return this.startJob(job, stepCounter.getCount(), parameterBuilder.toJobParameters());
    }

    public Long executeInstallForQAMuster(String component) throws Exception {
        this.userService.checkAdminRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = this.jobDescriptionSource.getInstallUpgradeJob(component);
        ActionNode mondrianAction = ContainerNode.getActionById(root, "load_mondrian_schema");
        mondrianAction.active = false;
        root.getActions().forEach(n -> {
            if (n.id.equals(component.toLowerCase() + "_preupgrade_containernode")) {
                n.active = false;
            }
        });
        Job job = this.createBatchJob(root, null, stepCounter);
        JobParametersBuilder parameterBuilder = new JobParametersBuilder();
        parameterBuilder.addJobParameters(this.createVersionParameter(component));
        parameterBuilder.addJobParameters(this.createChecksumParameter(component));
        return this.startJob(job, stepCounter.getCount(), parameterBuilder.toJobParameters());
    }

    public Long executeUpgradeForQAMuster(String component) throws Exception {
        this.userService.checkAdminRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = this.jobDescriptionSource.getInstallUpgradeJob(component);
        ActionNode mondrianAction = ContainerNode.getActionById(root, "load_mondrian_schema");
        mondrianAction.active = false;
        Job job = this.createBatchJob(root, null, stepCounter);
        String versionHash = PathAndFileUtils.getModuleHash(component);
        String version = PathAndFileUtils.getModuleVersion(component);
        JobParametersBuilder parameterBuilder = new JobParametersBuilder();
        parameterBuilder.addJobParameters(this.createVersionParameter(component));
        parameterBuilder.addJobParameters(this.createChecksumParameter(component));
        return this.startJob(job, stepCounter.getCount(), parameterBuilder.toJobParameters());
    }

    @RequestMapping(path={"/job/upgrade/{component}"}, method={RequestMethod.GET})
    public Long executeUpgrade(@PathVariable(value="component") String component) throws Exception {
        this.userService.checkAdminRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        if (!this.isComponentInstalled(component)) {
            logger.warn((Object)("Component " + component + " is not installed! Skipping upgrade."));
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = this.jobDescriptionSource.getInstallUpgradeJob(component);
        Job job = this.createBatchJob(root, null, stepCounter);
        JobParametersBuilder parameterBuilder = new JobParametersBuilder();
        parameterBuilder.addJobParameters(this.createVersionParameter(component));
        parameterBuilder.addJobParameters(this.createChecksumParameter(component));
        return this.startJob(job, stepCounter.getCount(), parameterBuilder.toJobParameters());
    }

    @RequestMapping(path={"/job/upgrade_all"}, method={RequestMethod.GET})
    public Long executeUpgradeAll() throws Exception {
        this.userService.checkAdminRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = new ContainerNode("- Alle Komponenten upgraden", "upgrade_all", -1);
        List<Component> components = this.getAllComponentAndConnectorDetails();
        for (Component component : components) {
            if (!component.isInstalled()) continue;
            String versionHash = PathAndFileUtils.getModuleHash(component.getAbbreviation());
            String version = PathAndFileUtils.getModuleVersion(component.getAbbreviation());
            ContainerNode componentUpgrade = this.jobDescriptionSource.getInstallUpgradeJob(component.getAbbreviation());
            componentUpgrade.addParameter("version_hash", versionHash);
            componentUpgrade.addParameter("version", version);
            componentUpgrade.addParameter("time", Long.valueOf(System.currentTimeMillis()).toString());
            componentUpgrade.setIgnoreErrorsAllChildren(true);
            root.add(componentUpgrade);
        }
        Job job = this.createBatchJob(root, null, stepCounter);
        return this.startJob(job, stepCounter.getCount(), null);
    }

    @RequestMapping(path={"/job/uninstall/{component}"}, method={RequestMethod.GET})
    public Long executeUninstall(@PathVariable(value="component") String component) throws Exception {
        this.userService.checkAdminRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = this.jobDescriptionSource.getUninstallJob(component);
        Job job = this.createBatchJob(root, null, stepCounter);
        return this.startJob(job, stepCounter.getCount(), null);
    }

    @RequestMapping(path={"/unload/{component}"}, method={RequestMethod.GET})
    public Long unload(@PathVariable(value="component") String component) throws Exception {
        this.userService.checkEtlJobRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = this.jobDescriptionSource.getUnloadJob(component);
        String sourceDatabase = this.getDataSource(component);
        Job job = this.createBatchJob(root, sourceDatabase, stepCounter);
        return this.startJob(job, stepCounter.getCount(), null);
    }

    @RequestMapping(path={"/transform/{component}"}, method={RequestMethod.GET})
    public Long load(@PathVariable(value="component") String component) throws Exception {
        this.userService.checkEtlJobRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = this.jobDescriptionSource.getLoadAndTransformJob(component);
        String sourceDatabase = this.getDataSource(component);
        Job job = this.createBatchJob(root, sourceDatabase, stepCounter);
        return this.startJob(job, stepCounter.getCount(), null);
    }

    @RequestMapping(path={"/complete/{component}"}, method={RequestMethod.GET})
    public Long complete(@PathVariable(value="component") String component) throws Exception {
        this.userService.checkEtlJobRights();
        if (this.isAnyJobInstanceRunning()) {
            return -1L;
        }
        StepCounter stepCounter = new StepCounter();
        ContainerNode root = this.jobDescriptionSource.getCompleteJob(component);
        String sourceDatabase = this.getDataSource(component);
        Job job = this.createBatchJob(root, sourceDatabase, stepCounter);
        return this.startJob(job, stepCounter.getCount(), null);
    }

    public Job createBatchJob(ContainerNode root, String sourceDatabase, StepCounter stepCounter) {
        this.jobLoggingListener = new BiJobLoggingListener(root.name, root.getJobSource());
        this.taskletContext = new TaskletContext();
        return this.batchJobDescriptionAdapter.transformToBatchJob(root, sourceDatabase, stepCounter, this.jobLoggingListener, this.taskletContext);
    }

    @RequestMapping(path={"/jobExecutionStatus/{jobExecutionId}"}, method={RequestMethod.GET})
    public JobExecutionStatus getStatus(@PathVariable(value="jobExecutionId") Long jobExecutionId) throws Exception {
        this.userService.checkEtlJobRights();
        JobExecution jobExecution = this.jobExplorer.getJobExecution(jobExecutionId);
        JobExecutionStatus jobExecutionStatus = JobUtils.getJobExecutionStatus(jobExecution, this.jobExplorer);
        int internalStepsExecuted = this.taskletContext.getInternalProgress();
        jobExecutionStatus.incrementExecutedStepsCount(internalStepsExecuted);
        if (this.jobLoggingListener != null) {
            jobExecutionStatus.log = this.jobLoggingListener.getNextLogSection();
            if (jobExecutionStatus.exitStatus.getExitCode().equals("FAILED")) {
                try (FileOutputStream logFile = new FileOutputStream(this.jobLoggingListener.getLogFile(), true);
                     PrintStream out = new PrintStream(logFile, true);){
                    EtlJobApi.outputErrorSummary(jobExecutionStatus, out);
                }
            }
        }
        return jobExecutionStatus;
    }

    @RequestMapping(path={"/jobExecutionInfos"}, method={RequestMethod.GET})
    public List<JobExecutionInfo> getJobExecutionInfos() throws Exception {
        this.userService.checkAdminRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        String jobSql = "SELECT job_instance_id FROM job_log ORDER BY 1 DESC";
        List jobInstanceIds = jt.queryForList(jobSql, Integer.class);
        ArrayList<JobExecutionInfo> jobExecutionInfos = new ArrayList<JobExecutionInfo>();
        for (Integer jobInstanceId : jobInstanceIds) {
            JobInstance jobInstance = this.jobExplorer.getJobInstance(Long.valueOf(jobInstanceId.intValue()));
            List jobExecutions = this.jobExplorer.getJobExecutions(jobInstance);
            for (JobExecution jobExecution : jobExecutions) {
                jobExecutionInfos.add(new JobExecutionInfo(jobExecution));
            }
        }
        JobExecutionInfo running = this.getRunningJob();
        if (running.jobExecutionId != -1L) {
            jobExecutionInfos.add(running);
        }
        return jobExecutionInfos;
    }

    @RequestMapping(path={"/jobExcecutionStatus/{jobExecutionId}"}, method={RequestMethod.GET})
    public JobExecutionStatus getJobExcecutionStatus(@PathVariable(value="jobExecutionId") Long jobExecutionId) throws Exception {
        this.userService.checkAdminRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        Long jobInstanceId = this.jobExplorer.getJobExecution(jobExecutionId).getJobInstance().getId();
        String statusSql = "SELECT status FROM job_log WHERE job_instance_id = ?";
        String statusJson = (String)jt.queryForObject(statusSql, String.class, new Object[]{jobInstanceId});
        JobExecutionStatus jobExcecutionStatus = (JobExecutionStatus)EXIT_STATUS_MAPPER.readValue(statusJson, JobExecutionStatus.class);
        String logSql = "SELECT log FROM job_log WHERE job_instance_id = ?";
        jobExcecutionStatus.log = (String)jt.queryForObject(logSql, String.class, new Object[]{jobInstanceId});
        return jobExcecutionStatus;
    }

    @RequestMapping(path={"/jobLog/{jobExecutionId}"}, method={RequestMethod.GET})
    public JobLog getJobLog(@PathVariable(value="jobExecutionId") Long jobExecutionId) throws Exception {
        this.userService.checkAdminRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        Long jobInstanceId = this.jobExplorer.getJobExecution(jobExecutionId).getJobInstance().getId();
        String logSql = "SELECT log FROM job_log WHERE job_instance_id = ?";
        String log = (String)jt.queryForObject(logSql, String.class, new Object[]{jobInstanceId});
        String abbreviation = this.jobExplorer.getJobInstance(jobExecutionId).getJobName().split(" ")[0].toLowerCase();
        JobLog jobLog = new JobLog(log, abbreviation);
        return jobLog;
    }

    @RequestMapping(path={"/running"}, method={RequestMethod.GET})
    public JobExecutionInfo getRunningJob() {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        String sql = "SELECT je.job_execution_id FROM BATCH_JOB_EXECUTION je JOIN BATCH_JOB_INSTANCE ji   ON je.JOB_INSTANCE_ID = ji.JOB_INSTANCE_ID LEFT JOIN BATCH_STEP_EXECUTION se ON se.STEP_NAME = ji.JOB_NAME WHERE je.STATUS IN ('STARTING', 'STARTED', 'STOPPING') AND se.STEP_NAME IS NULL ORDER BY je.START_TIME ASC LIMIT 1";
        Long jobExecutionId = -1L;
        try {
            jobExecutionId = (Long)jt.queryForObject(sql, Long.class);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
        }
        catch (DataAccessException e) {
            logger.error((Object)e);
        }
        if (jobExecutionId.equals(-1L)) {
            return new JobExecutionInfo(jobExecutionId);
        }
        return new JobExecutionInfo(this.jobExplorer.getJobExecution(jobExecutionId));
    }

    public static void outputErrorSummary(JobExecutionStatus jobExecutionStatus, PrintStream osw) {
        osw.append("******************************************************************************\n");
        osw.append("* Beim Ausf\u00fchren des Jobs sind Fehler aufgetreten!                           *\n");
        osw.append("* Bitte pr\u00fcfen Sie die Logausgaben in dieser Datei f\u00fcr n\u00e4here Informationen. *\n");
        osw.append("******************************************************************************\n");
        List<StepExecutionStatus> failedStepExecutionStatus = JobExecutionStatus.getFailedStepExecutionStatus(jobExecutionStatus.getStepExecutions());
        for (StepExecutionStatus status : failedStepExecutionStatus) {
            String[] errors;
            osw.append("** Fehlgeschlagen: ").append(status.getName()).append("\n");
            String description = status.getExitStatus().getExitDescription();
            if (description.isEmpty()) continue;
            for (String error : errors = description.split(";")) {
                error = error.trim();
                osw.append("** Fehler: ").append(error).append("\n");
            }
        }
    }

    @RequestMapping(path={"/stop/{id}"}, method={RequestMethod.GET})
    public boolean stop(@PathVariable(value="id") Long id) throws Exception {
        this.userService.checkEtlJobRights();
        return JobUtils.terminateJobExecution(this.jobExplorer, this.jobOperator, id);
    }

    @RequestMapping(path={"/start/{id}"}, method={RequestMethod.GET})
    public Long start(@PathVariable(value="id") Long id) throws Exception {
        this.userService.checkEtlJobRights();
        Long started = this.jobOperator.restart(id.longValue());
        return started;
    }

    @RequestMapping(path={"/installFunctions/{component}"}, method={RequestMethod.GET})
    public boolean installModuleFunctions(@PathVariable(value="component") String component) {
        File moduleFile = PathAndFileUtils.getXmlFile(component);
        SAXReader sr = new SAXReader();
        try (Connection con = this.dataSource.getConnection();){
            Document module = sr.read(moduleFile);
            List functions = module.selectNodes("//module/database/functions/function");
            for (Node function : functions) {
                String name = function.selectSingleNode("name").getText();
                List srcs = function.selectNodes("src");
                for (Node src : srcs) {
                    Node dbsystem = src.selectSingleNode("dbsystem");
                    if (!"postgres".equalsIgnoreCase(dbsystem.getText().toLowerCase())) continue;
                    Node file = src.selectSingleNode("file");
                    ByteArrayResource res = null;
                    if (file != null) {
                        String path = PathAndFileUtils.substituteParamStrings(file.getText());
                        res = new FileSystemResource(new File(path));
                        logger.info((Object)("Install function " + name + " from file " + path));
                    } else {
                        Node body = src.selectSingleNode("body");
                        res = new ByteArrayResource(body.getText().getBytes());
                        logger.info((Object)("Install function " + name + " from inline data"));
                    }
                    ScriptUtils.executeSqlScript((Connection)con, (EncodedResource)new EncodedResource((Resource)res, Charset.defaultCharset()), (boolean)true, (boolean)false, (String)"--", (String)";", (String)"/*", (String)"*/");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Problem installing db function", (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized Long startJob(Job job, Long countTotalSteps, JobParameters additionalParameters) throws DuplicateJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder().addLong("time", Long.valueOf(System.currentTimeMillis())).addLong("countTotalSteps", countTotalSteps);
        if (additionalParameters != null) {
            jobParametersBuilder.addJobParameters(additionalParameters);
        }
        this.addKonstanten(jobParametersBuilder);
        JobParameters jobParameters = jobParametersBuilder.toJobParameters();
        try {
            this.jobRegistry.getJob(job.getName());
            this.jobRegistry.unregister(job.getName());
        }
        catch (NoSuchJobException nsje) {
            logger.info((Object)("Job not registered yet: " + job.getName()));
        }
        this.jobRegistry.register((JobFactory)new ReferenceJobFactory(job));
        JobExecution jobExecution = null;
        JobLauncher executor = this.jobLauncher;
        if (RUN_SYNC) {
            TaskExecutorJobLauncher sycJobLauncher = new TaskExecutorJobLauncher();
            sycJobLauncher.setJobRepository(this.jobRepository);
            try {
                sycJobLauncher.afterPropertiesSet();
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't call afterPropertiesSet()", (Throwable)e);
            }
            executor = sycJobLauncher;
        }
        jobExecution = executor.run(job, jobParameters);
        return jobExecution.getId();
    }

    public Long startJob(Job job, Long countTotalSteps, JobParameters additionalParameters, JobLauncher aJobLauncher) throws DuplicateJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder().addLong("time", Long.valueOf(System.currentTimeMillis())).addLong("countTotalSteps", countTotalSteps);
        if (additionalParameters != null) {
            jobParametersBuilder.addJobParameters(additionalParameters);
        }
        this.addKonstanten(jobParametersBuilder);
        JobParameters jobParameters = jobParametersBuilder.toJobParameters();
        try {
            this.jobRegistry.getJob(job.getName());
            this.jobRegistry.unregister(job.getName());
        }
        catch (NoSuchJobException nsje) {
            logger.info((Object)("Job not registered yet: " + job.getName()));
        }
        this.jobRegistry.register((JobFactory)new ReferenceJobFactory(job));
        JobExecution jobExecution = null;
        jobExecution = aJobLauncher.run(job, jobParameters);
        return jobExecution.getId();
    }

    private void addKonstanten(JobParametersBuilder jobParametersBuilder) {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        Integer konstanteTableExists = (Integer)jt.queryForObject("SELECT COUNT(*) FROM information_schema.tables WHERE table_name = 'konstanten'", Integer.class);
        if (konstanteTableExists == 0) {
            logger.warn((Object)"Table konstanten doesn't exist (yet)");
            return;
        }
        for (JobParamKonstanten param : JobParamKonstanten.values()) {
            Optional<Konstante> konstante = this.konstanteRepository.findByBeschreibung(param.name());
            Long value = konstante.isPresent() ? Long.valueOf(konstante.get().apnr.intValue()) : Long.valueOf(-1L);
            param.addToJobParams(jobParametersBuilder, value);
        }
    }

    private boolean isAnyJobInstanceRunning() {
        ArrayList runningJobs = new ArrayList();
        List jobNames = this.jobExplorer.getJobNames();
        for (String jobName : jobNames) {
            Set jobExecutions = this.jobExplorer.findRunningJobExecutions(jobName);
            runningJobs.addAll(jobExecutions);
        }
        return !runningJobs.isEmpty();
    }

    private boolean isComponentInstalled(String componentName) {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        Integer count = (Integer)jt.queryForObject("select count(*) from db_version where his_system = '" + componentName + "'", Integer.class);
        return count == 1;
    }

    public Component getComponentAndConnectorDetails(final String abbreviation) {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        Component component = (Component)jt.query("SELECT systeminfo.tid AS systeminfo_id,       trim(systeminfo.name) AS name,       trim(db_version.his_system) AS abbreviation,       unload_params.param_val AS db,       systeminfo.datum AS last_update  FROM systeminfo  JOIN db_version    ON db_version.systeminfo_id = systeminfo.tid  LEFT JOIN unload_params    ON unload_params.param_id='SOURCESYSTEM'   AND unload_params.systeminfo_id = systeminfo.tid WHERE trim(db_version.his_system)=?", new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, abbreviation);
            }
        }, (ResultSetExtractor)new ResultSetExtractor<Component>(){

            public Component extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    String dbName = rs.getString("db");
                    boolean databaseConnected = false;
                    if (dbName != null) {
                        databaseConnected = EtlJobApi.this.dataSources.containsKey(dbName);
                    }
                    return new Component(rs.getString("name"), rs.getString("abbreviation"), rs.getInt("systeminfo_id"), dbName, rs.getTimestamp("last_update"), databaseConnected, true);
                }
                return null;
            }
        });
        return component;
    }

    public List<Component> getAllComponentAndConnectorDetails() {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        List components = jt.query("SELECT systeminfo.tid AS systeminfo_id,       trim(systeminfo.name) AS name,       trim(db_version.his_system) AS abbreviation,       unload_params.param_val AS db,       systeminfo.datum AS last_update  FROM systeminfo  JOIN db_version    ON db_version.systeminfo_id = systeminfo.tid  LEFT JOIN unload_params    ON unload_params.param_id='SOURCESYSTEM'   AND unload_params.systeminfo_id = systeminfo.tid ORDER BY name", (rs, rowNum) -> {
            String dbName = rs.getString("db");
            boolean databaseConnected = false;
            if (dbName != null) {
                databaseConnected = this.dataSources.containsKey(dbName);
            }
            return new Component(rs.getString("name"), rs.getString("abbreviation"), rs.getInt("systeminfo_id"), dbName, rs.getTimestamp("last_update"), databaseConnected, true);
        });
        for (Component component : components) {
            Component loadAndUnloadComponent = this.jobDescriptionSource.getComponentWithLoadAndUnloadDetails(component.getAbbreviation());
            boolean load = loadAndUnloadComponent.isLoad();
            boolean unload = loadAndUnloadComponent.isUnload();
            if ("administration".equalsIgnoreCase(component.getName()) && !component.isDatabaseConnected() && "manuell".equalsIgnoreCase(component.getDatabase())) {
                load = false;
                unload = false;
            }
            component.setLoad(load);
            component.setUnload(unload);
        }
        components.sort(new ComponentComparator());
        for (Component component : components) {
            List<ContainerNode> specialJobs = this.jobDescriptionSource.getSpecialJobsOverview(component.getAbbreviation());
            List<String> sourceSystems = PathAndFileUtils.findSourceSystems(component.getAbbreviation());
            if (specialJobs.size() <= 0) continue;
            for (ContainerNode job : specialJobs) {
                String sourceSystem = component.getDatabase();
                for (String s : sourceSystems) {
                    if (!job.id.substring(1).contains(s)) continue;
                    sourceSystem = s;
                    break;
                }
                Connector connector = new Connector(job.name, sourceSystem, job.getJobType(), job.tid == null ? null : Long.valueOf(job.tid.longValue()), job.id);
                component.addChild(connector);
            }
        }
        return components;
    }

    public String getDataSource(String component) {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        String result = null;
        try {
            result = (String)jt.queryForObject("select unload_params.param_val as db from systeminfo join db_version on db_version.systeminfo_id = systeminfo.tid left join unload_params on unload_params.param_id='SOURCESYSTEM' and unload_params.systeminfo_id = systeminfo.tid WHERE db_version.his_system = '" + component + "'", String.class);
        }
        catch (EmptyResultDataAccessException e) {
            logger.warn((Object)("No data source found for component: " + component));
            result = "hisinone";
        }
        return result;
    }

    private void checkForNeedsUpgrade(List<Component> components) {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        for (Component component : components) {
            if (!component.isInstalled()) continue;
            logger.debug((Object)("Check version hash for " + component.getAbbreviation()));
            String db_hash = (String)jt.queryForObject("select version_hash from db_version where systeminfo_id=" + component.getSysteminfoId() + " or his_system='" + component.getAbbreviation() + "'", String.class);
            String file_hash = "";
            try {
                file_hash = PathAndFileUtils.getModuleHash(component.getAbbreviation());
            }
            catch (IOException e) {
                logger.error((Object)"Couldn't read version hash: ", (Throwable)e);
            }
            component.setNeedsUpgrade(!file_hash.equals(db_hash));
        }
    }

    private List<Component> getInstallables() {
        ArrayList<Component> components = new ArrayList<Component>();
        try {
            List<String> componentAbbreviations = this.getAllComponentAndConnectorDetails().stream().map(c -> c.getAbbreviation()).collect(Collectors.toList());
            List<ContainerNode> nodes = this.jobDescriptionSource.readInstallJobs(componentAbbreviations);
            JdbcTemplate jt = new JdbcTemplate(this.dataSource);
            int i = 0;
            for (ContainerNode n : nodes) {
                ++i;
                if (n == null) {
                    logger.error((Object)("Skipping Node " + i + " of " + nodes.size()));
                    logger.error((Object)" => ContainerNode was null!");
                    continue;
                }
                String abbr = n.id.split("_install_upgrade")[0];
                String name = null;
                String installed = "";
                try {
                    name = PathAndFileUtils.getComponentName(abbr);
                    logger.debug((Object)("Check install/upgrade for " + name));
                    installed = (String)jt.queryForObject("select trim(his_system) from db_version where his_system = '" + abbr + "';", String.class);
                }
                catch (IOException e) {
                    logger.error((Object)("Couldn't read info on " + abbr), (Throwable)e);
                }
                catch (EmptyResultDataAccessException e) {
                    logger.info((Object)("No Result found in db_version for " + abbr + " - Presumably not installed"));
                    installed = "";
                }
                components.add(new Component(name, abbr, n.systemInfoId, null, null, false, false, false, !installed.isBlank()));
            }
            this.checkForNeedsUpgrade(components);
            components.sort(new ComponentComparator());
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        return components;
    }

    private JobParameters createVersionParameter(String component) throws IOException {
        String version = PathAndFileUtils.getModuleVersion(component);
        return new JobParametersBuilder().addString("version", version).toJobParameters();
    }

    private JobParameters createChecksumParameter(String component) throws IOException {
        String versionHash = PathAndFileUtils.getModuleHash(component);
        return new JobParametersBuilder().addString("version_hash", versionHash).toJobParameters();
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public JobDescriptionSource getJobDescriptionSource() {
        return this.jobDescriptionSource;
    }

    public void setJobDescriptionSource(JobDescriptionSource jobDescriptionSource) {
        this.jobDescriptionSource = jobDescriptionSource;
    }

    public void setSyncExecution() {
        RUN_SYNC = true;
    }

    public void unsetSyncExecution() {
        RUN_SYNC = false;
    }
}

