/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import de.superx.bianalysis.service.BiAnalysisRightService;
import de.superx.jdbc.entity.Entity;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.RepositoryMetadata;
import de.superx.jdbc.repository.BiaAdminCrudRepository;
import de.superx.rest.RestControllerBase;
import de.superx.rest.model.Column;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.HisDynamicFieldConfig;
import de.superx.rest.model.Item;
import de.superx.rest.model.RestMessageWrapperException;
import de.superx.rest.model.Result;
import de.superx.spring.service.BiaRepositoryService;
import de.superx.spring.service.UserService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admindialog"})
public class AdminDialog
extends RestControllerBase {
    @Autowired
    BiaRepositoryService biaRepositoryService;
    @Autowired
    UserService userService;
    @Autowired
    BiAnalysisRightService biAnalysisRightService;
    static Logger logger = Logger.getLogger(AdminDialog.class);

    @RequestMapping(method={RequestMethod.GET}, path={"/{table}/{id}"})
    public HisDynamicFieldConfig getAdminDialogConfig(@PathVariable(value="table") String table, @PathVariable(value="id") String id) throws IllegalArgumentException, IllegalAccessException, InstantiationException, SQLException, InvocationTargetException, NoSuchMethodException, SecurityException, RestMessageWrapperException {
        this.checkAdminRights();
        return this.biaRepositoryService.getAdminDialogConfig(table, id);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/filterRelation/{table}"})
    public HisDynamicFieldConfig getAdminFilterConfig(@PathVariable(value="table") String table) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.checkAdminRights();
        return this.biaRepositoryService.getAdminFilterConfig(table);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/{table}"})
    public Entity save(@PathVariable(value="table") String table, @RequestBody Map<String, String> params) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.checkAdminRights();
        if (table.startsWith("metadata.")) {
            params.put("defaultRelease", "custom");
        }
        return this.biaRepositoryService.saveEntity(table, params);
    }

    @RequestMapping(method={RequestMethod.DELETE}, path={"{table}/{id}"})
    public void delete(@PathVariable(value="table") String table, @PathVariable(value="id") String id) throws RestMessageWrapperException {
        this.checkAdminRights();
        this.biaRepositoryService.deleteEntity(table, id);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/editableRelations"})
    public Result getEditableRelations() throws IllegalArgumentException {
        this.checkAdminRights();
        Result result = new Result();
        result.rows = this.biaRepositoryService.getAllEditableTables();
        result.columns.add(new Column("caption", "cs.bia.admin.editRelations.caption", ColumnType.StringColumn));
        result.columns.add(new Column("description", "cs.bia.admin.editRelations.description", ColumnType.StringColumn));
        result.columns.add(new Column("bi_component", "cs.bia.common.component", ColumnType.StringColumn));
        result.columns.add(new Column("table_name", "cs.bia.admin.editRelations.table_name", ColumnType.StringColumn));
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/relation/{relation}"})
    public Result getRelation(@PathVariable(value="relation") String relation) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.checkExtendedRights(relation);
        Result result = new Result();
        BiaAdminCrudRepository<Entity> repo = this.biaRepositoryService.findBiaAdminCrudRepositoryFor(relation);
        result.addColumns(this.createColumns(repo));
        repo.findAll().forEach(entity -> {
            try {
                Map<String, Object> cells = this.createRowCells((Entity)entity);
                boolean readOnly = entity.isReadOnly();
                result.addRow(cells, readOnly);
            }
            catch (Exception e) {
                logger.error((Object)("Couldn't read table rows for " + relation), (Throwable)e);
            }
        });
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/tableInfo/{relation}"})
    public RepositoryMetadata getRepositoryMetadata(@PathVariable(value="relation") String relation) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.checkAdminRights();
        RepositoryMetadata repositoryMetadata = this.biaRepositoryService.getRepositoryMetadata(relation);
        return repositoryMetadata;
    }

    private void checkAdminRights() {
        this.userService.checkAdminRights();
    }

    private void checkExtendedRights(String relation) {
        if (relation.equals("colorscheme")) {
            this.biAnalysisRightService.checkCreateOrViewRights();
        } else {
            this.userService.checkAdminRights();
        }
    }

    private List<Column> createColumns(BiaAdminCrudRepository<Entity> repo) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Field[] fields;
        ArrayList<Column> result = new ArrayList<Column>();
        Class<Entity> entityClass = repo.getEntityClass(this.biaRepositoryService);
        for (Field field : fields = entityClass.getDeclaredFields()) {
            Column column = this.createColumn(field, repo);
            result.add(column);
        }
        return result;
    }

    private Column createColumn(Field field, BiaAdminCrudRepository<Entity> repo) throws IllegalArgumentException, IllegalAccessException {
        Column column = new Column(field.getName(), field.getName(), ColumnType.StringColumn);
        if (field.isAnnotationPresent(DynamicFieldType.class)) {
            DynamicFieldType annotation = field.getAnnotation(DynamicFieldType.class);
            if (!annotation.label().isEmpty()) {
                column.header = annotation.label();
            }
            column.type = annotation.columnType();
            column.visibleInSimplifiedTable = annotation.visibleInSimplifiedForm();
        }
        List<Item> items = repo.getItems(field, this.biaRepositoryService);
        column.setItems(items);
        return column;
    }

    private Map<String, Object> createRowCells(Entity entity) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        Field[] fields;
        HashMap<String, Object> cells = new HashMap<String, Object>();
        for (Field field : fields = entity.getClass().getDeclaredFields()) {
            String name = field.getName();
            Object value = field.get(entity);
            cells.put(name, value);
        }
        return cells;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

