/*
 * Decompiled with CFR 0.152.
 */
package de.superx.jdbc.entity;

import de.superx.jdbc.entity.Entity;
import de.superx.jdbc.entity.EntityBase;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.EntityDescriptor;
import de.superx.jdbc.model.TableRef;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.Item;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.jdbc.core.JdbcTemplate;

@Table(value="konstanten")
public class Konstante
extends EntityBase {
    @Id
    @DynamicFieldType(label="ID", visibleInSimplifiedForm=false, readOnly=true)
    public Integer tid;
    @EntityDescriptor
    @DynamicFieldType(label="Parametername", readOnly=true)
    public String beschreibung;
    @DynamicFieldType(label="Parametergruppe", readOnly=true)
    public String gruppe;
    @DynamicFieldType(label="Aktueller Wert")
    public Integer apnr;
    @DynamicFieldType(label="Defaultwert", readOnly=true)
    public Integer defaultvalue;
    @DynamicFieldType(label="Wertebereich", visibleInSimplifiedForm=false, readOnly=true)
    public String wertebereich;
    @DynamicFieldType(label="Beschreibung", editControlType=FieldType.TextArea, readOnly=true)
    public String description;
    @DynamicFieldType(label="Ab Version", readOnly=true)
    public String abVersion;
    @DynamicFieldType(label="Doku", readOnly=true, filterControlType=FieldType.None, columnType=ColumnType.DocumentationColumn)
    public String dokuLink;
    @DynamicFieldType(label="Schreibgesch\u00fctzt", editControlType=FieldType.Select, readOnly=true, columnType=ColumnType.BooleanColumn)
    public Integer readOnly;
    @DynamicFieldType(label="BI-Komponente", editControlType=FieldType.Select, readOnly=true)
    @TableRef(table="systeminfo", keyField="tid", labelField="name")
    public Integer systeminfoId;
    @DynamicFieldType(label="Sachgebiet", editControlType=FieldType.Select, visibleInSimplifiedForm=false, readOnly=true)
    @TableRef(table="sachgebiete", keyField="tid", labelField="name")
    public Integer sachgebieteId;
    @DynamicFieldType(label="Priorit\u00e4t", editControlType=FieldType.Select, readOnly=true)
    @TableRef(table="k_prio_param", keyField="id", labelField="name")
    public Integer priority;
    @DynamicFieldType(label="Quellsystem", editControlType=FieldType.Select, readOnly=true)
    @TableRef(table="k_source", keyField="id", labelField="name")
    public Integer sourcesystem;

    @Override
    public boolean isReadOnly() {
        return this.readOnly == 1 && this.tid != null;
    }

    @Override
    public Entity makeEditable() {
        this.readOnly = 0;
        return null;
    }

    @Override
    public List<Item> getCellSpecificItems(String fieldName, DataSource ds) {
        List<Item> items = new ArrayList<Item>();
        if (fieldName.equals("apnr") && this.wertebereich != null && !this.wertebereich.trim().isEmpty()) {
            items = this.wertebereich.trim().startsWith("<<SQL>>") ? this.getItemsFromQuery(this.wertebereich.split("<<SQL>>")[1], ds) : this.getItemsFromString();
        }
        return items;
    }

    private List<Item> getItemsFromString() {
        String[] splitString;
        ArrayList<Item> items = new ArrayList<Item>();
        for (String item : splitString = this.wertebereich.split("\\r?\\n")) {
            String[] split = item.replaceFirst("^,", "").split("[=,-]", 2);
            items.add(new Item(split[1].trim(), split[0].trim()));
        }
        return items;
    }

    private List<Item> getItemsFromQuery(String query, DataSource ds) {
        JdbcTemplate jt = new JdbcTemplate(ds);
        List items = jt.query(query, (rs, rowNum) -> new Item(rs.getString(2), Integer.valueOf(rs.getInt(1)).toString()));
        return items;
    }

    @Override
    public boolean canBeCreatedByUser() {
        return false;
    }

    @Override
    public boolean canBeDeletedByUser() {
        return false;
    }
}

