/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl.bin;

import de.memtext.util.GetOpts;
import de.superx.etl.TableUploader;
import java.util.Date;

public class UploadRecords {
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin.UploadRecords \n-dbproperties:<Pfad zu db.properties> \n-table:<Tabellenname> \n-unl:<Dateipfad Quelldatei>(optional, default ist Tabellenname.unl) \n-delim:<delimiter>(optional, default ist ^) \n-header:<true|false>(optional, mit Feld\u00fcberschriften, default ist false)\n-mode:<stop|exclude-row>(optional, default is stop) #Bei Fehlerhaften Daten kann das Hochladen gestoppt werden, oder der Datensatz wird \u00fcbersprungen\n-inserts:<false|simple|batch>(optional, default is false) #Bei -inserts:simple und batch werden Die Rohdaten in Insert-sql-Statements \u00fcbersetzt (nur f\u00fcr Debugging-Zwecke, sehr langsam. Der Modus exclude-field ist dar\u00fcberhinaus nicht anwendbar)\n-encoding:<utf8,ISO-8859-1, default ist System.file.encoding>\n---------------------------------------------------";

    public static void main(String[] args) {
        try {
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_dbprops, GetOpts.Options.opt_table, GetOpts.Options.opt_unl});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.err.println(usage);
                System.exit(1);
            }
            TableUploader myUploader = new TableUploader();
            if (GetOpts.isPresent(GetOpts.Options.opt_dbprops)) {
                myUploader.setDbpropfile(GetOpts.getValue(GetOpts.Options.opt_dbprops));
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_inFormat)) {
                myUploader.setInFormat(GetOpts.getValue(GetOpts.Options.opt_inFormat));
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_table)) {
                myUploader.setTargetTable(GetOpts.getValue(GetOpts.Options.opt_table));
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_unl)) {
                myUploader.setSrcFile(GetOpts.getValue(GetOpts.Options.opt_unl));
            } else {
                myUploader.setSrcFile(myUploader.getTargetTable() + ".unl");
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_header)) {
                myUploader.setHeader(GetOpts.getValue(GetOpts.Options.opt_header).equalsIgnoreCase("true"));
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_delim)) {
                myUploader.setDelim(GetOpts.getValue(GetOpts.Options.opt_delim));
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_encoding)) {
                String encodingParam = GetOpts.getValue(GetOpts.Options.opt_encoding);
                if (encodingParam != null && !encodingParam.equals("")) {
                    myUploader.setEncoding(encodingParam);
                }
            } else {
                myUploader.setEncoding(System.getProperty("file.encoding"));
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_mode)) {
                myUploader.setMode(GetOpts.getValue(GetOpts.Options.opt_mode).toLowerCase());
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_inserts)) {
                myUploader.setInserts(GetOpts.getValue(GetOpts.Options.opt_inserts));
            }
            long jetzt = new Date().getTime();
            long numberOfRows = 0L;
            myUploader.setUploadConnection(myUploader.getConnection(null, myUploader.getDbpropfile()));
            numberOfRows = myUploader.uploadFile();
            long erstrecht = new Date().getTime();
            System.out.println(numberOfRows + " lines loaded");
            System.out.println("File " + myUploader.getSrcFile() + " uploaded, returnCode=" + myUploader.getReturnCode());
            Object var2_3 = null;
        }
        catch (Exception ex) {
            System.err.println("Upload fehlgeschlagen: " + String.valueOf(ex));
            System.exit(1);
        }
    }
}

