/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbt;

import de.superx.dbt.DbtManager;
import de.superx.dbt.UnsupportedPythonVersionException;
import de.superx.servlet.SuperXManager;
import de.superx.util.PathAndFileUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;

public class DbtUtils {
    private static final boolean isLinux = SystemUtils.IS_OS_LINUX;

    public static String getPythonVersion() {
        return DbtUtils.getPythonVersionForExecutable(DbtUtils.getPython3ExecutableName());
    }

    public static String getPython3ExecutableName() {
        String[] executables;
        for (String executable : executables = new String[]{"python", "python3", "python.bat"}) {
            try {
                String version = DbtUtils.getPythonVersionForExecutable(executable);
                if (!version.startsWith("3")) continue;
                return executable;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("No Python 3 installation found in PATH!");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getPythonVersionForExecutable(String executable) {
        try {
            ProcessBuilder p = new ProcessBuilder(executable, "--version");
            p.redirectErrorStream(true);
            Process process = p.start();
            try (InputStreamReader input = new InputStreamReader(process.getInputStream());){
                String string;
                try (BufferedReader br = new BufferedReader(input);){
                    String output = br.lines().collect(Collectors.joining("\n"));
                    string = output.substring(output.indexOf(32) + 1);
                }
                return string;
            }
        }
        catch (Exception iox) {
            throw new RuntimeException("Couldn't execute " + executable + ". Is Python 3 installed and in PATH?", iox);
        }
    }

    private static Path getDbtFolder() {
        return Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt");
    }

    private static Path getDbtInstallLib() {
        return Path.of(DbtUtils.getDbtFolder().toString(), "dbt_linux", "lib");
    }

    public static Path getDbtProjectDirectory() {
        return Path.of(DbtUtils.getDbtFolder().toString(), "projects", "hisinone", "transform");
    }

    public static Path getBiAnalysisMetadataFolder() {
        return Path.of(DbtUtils.getDbtFolder().toString(), "projects", "hisinone", "bianalysis_metadata");
    }

    public static Path getVirtualEnvPath() {
        if (isLinux) {
            return Path.of(DbtUtils.getDbtFolder().toString(), "dbt_env_linux");
        }
        return Path.of(DbtUtils.getDbtFolder().toString(), "dbt_env_windows");
    }

    public static Path getDbtInstallDir() {
        if (DbtUtils.isVirtualEnvInstalled()) {
            return DbtUtils.getVirtualEnvPath();
        }
        String folder = "dbt_windows";
        if (isLinux) {
            folder = "dbt_linux";
        }
        return Path.of(DbtUtils.getDbtFolder().toString(), folder);
    }

    public static boolean isVirtualEnvInstalled() {
        return DbtUtils.getVirtualEnvPath().toFile().isDirectory();
    }

    public static Path getDbtBinaryFolder() {
        if (isLinux) {
            return Path.of(DbtUtils.getDbtInstallDir().toString(), "bin");
        }
        if (DbtUtils.isVirtualEnvInstalled()) {
            return Path.of(DbtUtils.getDbtInstallDir().toString(), "Scripts");
        }
        String pythonVersion = DbtUtils.getPythonVersion();
        String[] parts = pythonVersion.split("\\.");
        String pythonFolderName = "Python" + parts[0] + parts[1];
        return Path.of(DbtUtils.getDbtInstallDir().toString(), pythonFolderName, "Scripts");
    }

    public static Path getDbtBinaryInBinaryFolder(String binary) {
        Object bin = binary;
        if (!isLinux) {
            bin = (String)bin + ".exe";
        }
        return Path.of(DbtUtils.getDbtBinaryFolder().toString(), new String[]{bin});
    }

    public static Path getDbtBinaryPath() {
        if (isLinux) {
            return Path.of(DbtUtils.getDbtBinaryFolder().toString(), "dbt");
        }
        return Path.of(DbtUtils.getDbtBinaryFolder().toString(), "dbt.exe");
    }

    public static void checkPythonCompatability() throws UnsupportedPythonVersionException {
        try {
            String pythonVersion = DbtUtils.getPythonVersion();
            Path dbtInstallLib = DbtUtils.getDbtInstallLib();
            List files = Files.list(dbtInstallLib).collect(Collectors.toList());
            ArrayList<String> supportedVersions = new ArrayList<String>();
            for (Path path : files) {
                String version = path.toString().split("python")[1];
                supportedVersions.add(version);
            }
            String[] splitVersion = pythonVersion.split("\\.");
            String userVersion = splitVersion[0] + "." + splitVersion[1];
            if (!supportedVersions.contains(userVersion)) {
                String errorMessage = "Unsupported version of Python: " + userVersion + ".Supported Versions: ";
                StringJoiner joiner = new StringJoiner(", ");
                for (String version : supportedVersions) {
                    joiner.add(version);
                }
                errorMessage = errorMessage + joiner.toString();
                throw new UnsupportedPythonVersionException(errorMessage);
            }
        }
        catch (UnsupportedPythonVersionException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SuperXManager.setWEB_INFPfad(PathAndFileUtils.getWebinfPath());
        DbtManager.getStagingTables("+fact_application");
        System.out.println(DbtUtils.getPythonVersion());
        System.out.println(DbtUtils.getPython3ExecutableName());
        System.out.println(DbtUtils.getDbtFolder());
        System.out.println(DbtUtils.getDbtProjectDirectory());
        System.out.println(DbtUtils.getDbtBinaryFolder());
        System.out.println(DbtUtils.getDbtBinaryPath());
    }
}

