/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zaxxer.hikari.HikariDataSource;
import de.superx.dbt.DbtUtils;
import de.superx.rest.EtlJobApi;
import de.superx.rest.model.job.Component;
import de.superx.servlet.SuperXManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.SystemUtils;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Service;

@Service
public class DbtManager
implements Runnable {
    @Autowired
    EtlJobApi etlJobApi;
    @Autowired
    DataSource dataSource;
    static Logger logger = LoggerFactory.getLogger(DbtManager.class);
    private final boolean isLinux = SystemUtils.IS_OS_LINUX;
    private Path dbtInstallDir;
    private String pythonExecutable = "python";
    private String user = "postgres";
    private String password = "postgres";
    private String host = "localhost";
    private String port = "5432";
    private String db = "eduetl";
    private Process process;
    private int modelCount = 0;
    private String runtimeErrors = "";
    private String select;
    private boolean test;
    private Path projectPath;
    private List<JsonNode> dbtLog = new ArrayList<JsonNode>();
    private JsonNode stats;
    private boolean shouldGenerateDoc = true;

    public void init(Path projectPath, String select) {
        this.init(projectPath, select, true, false);
    }

    public void init(Path projectPath, String select, boolean test) {
        this.init(projectPath, select, true, test);
    }

    public void init(Path projectPath, String select, boolean readDBProperties, boolean test) {
        if (!projectPath.toFile().isDirectory()) {
            throw new RuntimeException(String.valueOf(projectPath.toAbsolutePath()) + " is no directory!");
        }
        File projectFile = Path.of(projectPath.toString(), "dbt_project.yml").toFile();
        if (!projectFile.exists()) {
            throw new RuntimeException(String.valueOf(projectPath) + " is no dbt project directory (no dbt_project.yml found)!");
        }
        File profilesFile = Path.of(projectPath.toString(), "profiles.yml").toFile();
        if (!profilesFile.exists()) {
            throw new RuntimeException(String.valueOf(projectPath) + " is no dbt project directory (no profiles.yml found)!");
        }
        this.projectPath = projectPath.toAbsolutePath().normalize();
        this.dbtInstallDir = DbtUtils.getDbtInstallDir();
        this.pythonExecutable = DbtUtils.getPython3ExecutableName();
        this.select = select;
        this.test = test;
        this.process = null;
        this.dbtLog = new ArrayList<JsonNode>();
        this.runtimeErrors = "";
        this.modelCount = 0;
        this.stats = null;
        if (this.test) {
            this.shouldGenerateDoc = false;
        }
        if (readDBProperties) {
            try {
                HikariDataSource eduetl = (HikariDataSource)this.dataSource;
                String jdbcUrl = eduetl.getJdbcUrl();
                String cleanUrl = jdbcUrl.substring(5);
                URI uri = URI.create(cleanUrl);
                String eduetlHost = uri.getHost();
                int eduetlPort = uri.getPort();
                String eduetlFinalPort = String.valueOf(eduetlPort != -1 ? Integer.valueOf(this.port) : "5432");
                String eduetlUsername = "";
                String eduetlDbName = "";
                try (Connection con = this.dataSource.getConnection();){
                    eduetlUsername = con.getMetaData().getUserName();
                    eduetlDbName = con.getCatalog();
                }
                this.user = eduetlUsername;
                this.password = eduetl.getPassword();
                this.host = eduetlHost;
                this.port = eduetlFinalPort;
                this.db = eduetlDbName;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't get connection info for eduetl", e);
            }
        }
    }

    private List<String> buildDbtCommand() {
        String dbt = DbtUtils.getDbtBinaryPath().toString();
        logger.info("Project path: " + this.projectPath.toString());
        logger.info("dbt_bin: " + dbt.toString());
        ArrayList<String> baseCommand = new ArrayList<String>(Arrays.asList(this.pythonExecutable, dbt, "--log-format", "json", "--no-use-colors"));
        if (!this.isLinux && DbtUtils.isVirtualEnvInstalled()) {
            baseCommand.remove(0);
        }
        if (this.test) {
            baseCommand.add("test");
        } else {
            baseCommand.addAll(Arrays.asList("build", "--resource-types", "snapshot", "seed", "model"));
        }
        if (this.select != null && !this.select.isBlank()) {
            baseCommand.add("--select");
            baseCommand.add(this.select);
        }
        return baseCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<String> pbCommand = this.buildDbtCommand();
        logger.info(Arrays.toString(pbCommand.toArray()));
        ProcessBuilder p = new ProcessBuilder(pbCommand).directory(this.projectPath.toFile());
        Map<String, String> env = this.getComponentStatus();
        env.putAll(this.getDbtEnvironment());
        env.putAll(this.getUnloadParams());
        p.environment().putAll(env);
        p.redirectErrorStream(false);
        this.dbtLog = new ArrayList<JsonNode>();
        try {
            this.modelCount = 0;
            this.process = p.start();
            logger.info("ProcessBuilder start");
            logger.info("PYTHONUSERBASE: " + p.environment().get("PYTHONUSERBASE"));
            String pathVar = "PATH";
            if (!this.isLinux) {
                pathVar = "Path";
            }
            logger.info("PATH: " + p.environment().get(pathVar));
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            CompletableFuture<String> errFuture = DbtManager.readOutStream(this.process.getErrorStream());
            errFuture.thenAccept(error -> this.checkStdError((String)error));
            String line = "";
            ObjectMapper objectMapper = new ObjectMapper();
            while ((line = reader.readLine()) != null) {
                JsonNode node = objectMapper.readTree(line.getBytes());
                logger.info(node.get("info").get("msg").asText());
                JsonNode data = node.get("data");
                if (data.get("stats") != null) {
                    this.stats = node;
                    continue;
                }
                if (data.has("index")) {
                    this.modelCount = Math.max(this.modelCount, data.get("index").asInt());
                }
                this.dbtLog.add(node);
            }
        }
        catch (Exception e) {
            logger.error("Couldn't start dbt run!", (Throwable)e);
            this.runtimeErrors = "Couldn't start dbt run!\n" + e.getMessage();
        }
        finally {
            if (this.shouldGenerateDoc) {
                this.generateDocs(env);
            }
        }
    }

    private Map<String, String> getComponentStatus() {
        HashMap<String, String> result = new HashMap<String, String>();
        EtlJobApi api = this.etlJobApi == null ? SuperXManager.getBean(null, EtlJobApi.class) : this.etlJobApi;
        List<Component> components = api.getInstallJobs();
        for (Component comp : components) {
            result.put("COMP_" + comp.getAbbreviation().toUpperCase() + "_INSTALLED", comp.isInstalled() ? "TRUE" : "FALSE");
        }
        return result;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public List<String> getErrorMessages() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.runtimeErrors.isEmpty()) {
            result.add(this.runtimeErrors);
        } else {
            for (JsonNode node : this.dbtLog) {
                Optional<JsonNode> level = DbtManager.findFirstOccurence("level", node);
                if (level.isPresent() && "error".equals(level.get().asText())) {
                    Optional<JsonNode> msg = DbtManager.findFirstOccurence("msg", node);
                    if (msg.isPresent()) {
                        result.add(msg.get().asText());
                        continue;
                    }
                    logger.warn("No msg property found in dbt log " + String.valueOf(node));
                    continue;
                }
                logger.warn("No level property found in dbt log " + String.valueOf(node));
            }
        }
        return result;
    }

    public Process getProcess() {
        return this.process;
    }

    public Optional<Boolean> isSuccess() {
        Optional<Boolean> success = Optional.empty();
        if (this.stats != null) {
            success = Optional.of(this.stats.get("data").get("stats").get("error").asInt() == 0);
        }
        return success;
    }

    public void generateDocs(Map<String, String> env) {
        try {
            Path dbt = DbtUtils.getDbtBinaryPath();
            ArrayList<String> pbCommand = new ArrayList<String>(Arrays.asList(this.pythonExecutable, dbt.toString(), "--no-use-colors", "docs", "generate"));
            if (this.select != null && !this.select.isBlank()) {
                pbCommand.add("--select");
                pbCommand.add(this.select);
            }
            ProcessBuilder pb = new ProcessBuilder(pbCommand).directory(this.projectPath.toFile());
            pb.environment().putAll(env);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            InputStream stdoutInputStream = p.getInputStream();
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(stdoutInputStream));
            String line = null;
            while ((line = stdoutReader.readLine()) != null) {
                logger.info(line);
            }
        }
        catch (Exception iox) {
            throw new RuntimeException("Couldn't run dbt generate docs ", iox);
        }
    }

    public int getNodeCount() {
        int lineNr = 0;
        try {
            Path dbt = DbtUtils.getDbtBinaryPath();
            ArrayList<String> pbCommand = new ArrayList<String>(Arrays.asList(this.pythonExecutable, dbt.toString(), "ls", "--resource-types"));
            if (this.test) {
                pbCommand.add("test");
            } else {
                pbCommand.addAll(Arrays.asList("snapshot", "seed", "model"));
            }
            if (this.select != null && !this.select.isBlank()) {
                pbCommand.add("--select");
                pbCommand.add(this.select);
            }
            ProcessBuilder pb = new ProcessBuilder(pbCommand).directory(this.projectPath.toFile());
            Map<String, String> env = this.getComponentStatus();
            env.putAll(this.getDbtEnvironment());
            pb.environment().putAll(env);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            InputStream stdoutInputStream = p.getInputStream();
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(stdoutInputStream));
            String line = "";
            while ((line = stdoutReader.readLine()) != null) {
                if (!line.matches("(\\w+\\.)+\\w+$")) continue;
                ++lineNr;
                logger.info(line);
            }
        }
        catch (Exception iox) {
            throw new RuntimeException("Couldn't run dbt ls ", iox);
        }
        return lineNr;
    }

    public Map<String, String> getDbtEnvironment() {
        Map<String, String> env = Map.ofEntries(Map.entry("PYTHONUSERBASE", this.dbtInstallDir.toString()), Map.entry("DBT_HOST", this.host), Map.entry("DBT_PORT", this.port.toString()), Map.entry("DBT_USER", this.user), Map.entry("DBT_ENV_SECRET_PW", this.password), Map.entry("DBT_DB", this.db));
        return env;
    }

    public List<JsonNode> getDbtLog() {
        return List.copyOf(this.dbtLog);
    }

    private static Optional<JsonNode> findFirstOccurence(String name, JsonNode searchNode) {
        JsonNode parent = searchNode.findParent(name);
        JsonNode result = parent != null ? parent.get(name) : null;
        return Optional.of(result);
    }

    private boolean checkStdError(String errorString) {
        boolean error = false;
        if (errorString.length() > 0) {
            this.runtimeErrors = "Error starting dbt: \n" + errorString;
            logger.error(this.runtimeErrors);
            error = true;
        }
        return error;
    }

    private static CompletableFuture<String> readOutStream(InputStream is) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStreamReader isr = new InputStreamReader(is);){
                String string;
                try (BufferedReader br = new BufferedReader(isr);){
                    String inputLine;
                    StringBuilder res = new StringBuilder();
                    while ((inputLine = br.readLine()) != null) {
                        res.append(inputLine).append(System.lineSeparator());
                    }
                    string = res.toString();
                }
                return string;
            }
            catch (Throwable e) {
                throw new RuntimeException("problem with executing program", e);
            }
        });
    }

    private Map<String, String> getUnloadParams() {
        Map<String, String> result = new HashMap<String, String>();
        if (this.dataSource != null) {
            JdbcTemplate jt = new JdbcTemplate(this.dataSource);
            result = (Map)jt.query("SELECT param_id, param_val FROM unload_params", (ResultSetExtractor)new ResultSetExtractor<Map<String, String>>(){

                public Map<String, String> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    HashMap<String, String> params = new HashMap<String, String>();
                    while (rs.next()) {
                        String key = rs.getString("param_id");
                        String value = rs.getString("param_val");
                        String string = value = value == null ? "" : value;
                        if (key != null) {
                            params.put(key, value);
                            continue;
                        }
                        Log.warn((Object)("Null key " + key + " -> " + value));
                    }
                    return params;
                }
            });
        }
        return result;
    }

    public static List<String> getStagingTables(String select) {
        try {
            Path dbtProjectDir = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", "hisinone", "transform");
            ProcessBuilder builder = new ProcessBuilder(DbtUtils.getPython3ExecutableName(), DbtUtils.getDbtBinaryPath().toString(), "ls", "--select", select, "--output", "name").directory(dbtProjectDir.toFile());
            Map<String, String> env = builder.environment();
            env.put("COMP_RES_INSTALLED", "true");
            env.put("DBT_DB", "eduetl");
            env.put("PYTHONUSERBASE", DbtUtils.getDbtInstallDir().toString());
            Process process = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            CompletableFuture<String> errFuture = DbtManager.readOutStream(process.getErrorStream());
            errFuture.thenAccept(error -> {
                if (error.length() > 0) {
                    logger.warn("WARNING: could not get staging tables for select: " + select);
                    logger.warn(error);
                }
            });
            List results = reader.lines().collect(Collectors.toList());
            ArrayList<String> tables = new ArrayList<String>();
            for (String model : results) {
                if (!model.startsWith("staging.")) continue;
                tables.add(model.split("staging.")[1]);
            }
            return tables;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setShouldGenerateDoc(boolean shouldGenerateDoc) {
        this.shouldGenerateDoc = shouldGenerateDoc;
    }
}

