/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.util.StringUtils;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.util.SqlStringUtils;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class XMLResultCreator {
    private SuperX_el result_el;
    private int maxOffset;
    private int offset;
    private String mandantenID;
    private String desiredRows = "all";

    XMLResultCreator(SuperX_el result_el, int maxOffset, int offset, String mandantenID) {
        this.result_el = result_el;
        this.maxOffset = maxOffset;
        this.offset = offset;
        this.mandantenID = mandantenID;
    }

    public void setDesiredRows(String desiredRows) {
        this.desiredRows = "," + desiredRows;
    }

    private void addSingleColumn(StringBuffer result, SxResultRow row, int trueColumn, int relativeColNo) {
        String f_name = this.result_el.getColumnNames()[trueColumn];
        Object f_wert = "";
        int f_typ = this.result_el.getColumnTypes()[trueColumn];
        try {
            f_wert = SqlStringUtils.getValueAsString(row.get(trueColumn));
        }
        catch (Exception e) {
            Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.ERROR, (Object)(e.toString() + ": " + result.toString()));
            f_wert = "";
        }
        if (f_wert != null) {
            f_wert = "<![CDATA[" + ((String)f_wert).trim() + "]]>";
        }
        result.append("<col id=\"" + relativeColNo + "\" typ=\"" + f_typ + "\">\n<f_name>" + f_name + "</f_name>\n<wert>" + (String)f_wert + "</wert>\n</col>\n");
    }

    public void addXML(StringBuffer buf, String colset, boolean isEbenenWanted, String treetableid, int rowkids) {
        if (treetableid == null) {
            treetableid = "";
        }
        int anzahl = 0;
        int ebenenCol = -1;
        int previousLevel = 999;
        int minEbene = 0;
        int currentLevel = 0;
        int outputRowCount = 0;
        int rowno = 0;
        boolean checkNextRow = false;
        boolean addKidRows = false;
        int requiredKidRowLevel = 0;
        if (isEbenenWanted) {
            ebenenCol = this.result_el.getTrueColumnNumber("ebene");
            minEbene = this.result_el.getMinEbene();
        }
        int currentRowNo = 0;
        for (SxResultRow row : this.result_el.getResultSet()) {
            ++currentRowNo;
            if (isEbenenWanted) {
                Object ebene = row.get(ebenenCol);
                currentLevel = minEbene;
                if (ebene != null) {
                    currentLevel = Integer.parseInt(ebene.toString());
                }
                if (addKidRows && currentLevel < requiredKidRowLevel) {
                    outputRowCount = 0;
                    addKidRows = false;
                }
                if (currentRowNo == rowkids) {
                    requiredKidRowLevel = currentLevel + 1;
                    addKidRows = true;
                }
                if (checkNextRow) {
                    if (previousLevel < currentLevel) {
                        StringUtils.replace(buf, "ISFOLDER", "true");
                    } else {
                        StringUtils.replace(buf, "ISFOLDER", "false");
                    }
                    checkNextRow = false;
                }
            }
            if (!(isEbenenWanted && rowkids == -1 && currentLevel == minEbene || isEbenenWanted && addKidRows && currentLevel == requiredKidRowLevel) && (isEbenenWanted || !this.isCurrentRowWanted(currentRowNo) || currentRowNo <= this.offset || currentRowNo > this.maxOffset + this.offset)) continue;
            buf.append("<row no=\"" + rowno + "\" ");
            ++rowno;
            if (isEbenenWanted) {
                buf.append(" treeindent=\"" + (currentLevel - minEbene) + "\"");
                previousLevel = currentLevel;
                buf.append(" treetableid=\"" + treetableid + "_" + outputRowCount + "\"");
                ++outputRowCount;
                buf.append(" isfolder=\"ISFOLDER\" internalrowno=\"" + currentRowNo + "\"");
                checkNextRow = true;
            }
            buf.append(">\n");
            ++anzahl;
            if (colset != null && !colset.trim().equals("") && !colset.trim().equalsIgnoreCase("restore")) {
                StringTokenizer st = new StringTokenizer(colset, "|");
                int colno = 0;
                while (st.hasMoreTokens()) {
                    int trueColumn = this.result_el.getTrueColumnNumber(st.nextToken());
                    this.addSingleColumn(buf, row, trueColumn, colno);
                    ++colno;
                }
            } else {
                for (int s = 0; s < this.result_el.getColumnCount(); ++s) {
                    this.addSingleColumn(buf, row, s, s);
                }
            }
            buf.append("</row>\n");
        }
        if (isEbenenWanted) {
            StringUtils.replace(buf, "ISFOLDER", "false");
        }
        if (anzahl == 1) {
            buf.append("<msg>Insgesamt 1 Satz gefunden</msg>\n");
        } else {
            buf.append("<msg>Insgesamt " + anzahl + " S\u00e4tze gefunden</msg>\n");
        }
    }

    private boolean isCurrentRowWanted(int currentRowNo) {
        boolean result = false;
        if (this.desiredRows.equals("all") || this.desiredRows.indexOf("," + currentRowNo + ",") > -1) {
            result = true;
        }
        return result;
    }
}

