/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.db.RestrictionCollector;
import de.superx.common.Field;
import de.superx.common.SxKontierungsrecht;
import de.superx.common.SxResultRow;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SxKontierungsrechte
implements TemplateMethodModelEx,
Serializable {
    private static final long serialVersionUID = 1L;
    public static String readingSQL = "";
    public boolean isErweitert = false;
    private boolean hasAllRights = false;
    private List<SxKontierungsrecht> rechteSammlung = new LinkedList<SxKontierungsrecht>();

    public static void initReadingSQL(boolean isErweitert) {
        if (isErweitert) {
            readingSQL = "select finanzstelle,hhprog,fonds,fipos from gxstage_user_rights where status=1 and (befristung is null or befristung>=today()) and userinfo_id=";
            Logger.getLogger((String)"superx_default").info((Object)"ERWEITERTE SX_KONTIERUNG aus gxstage_user_rights inkl. Status gefunden");
            System.out.println("ERWEITERTE SX_KONTIERUNG aus gxstage_user_rights inkl. Status gefunden");
        } else {
            readingSQL = "select finanzstelle,hhprog,fonds,fipos from gxstage_user_rights where userinfo_id=";
            Logger.getLogger((String)"superx_default").info((Object)"Standard Sx_Kontierung aus gxstage_user_rights gefunden - kein Feld Status ausgewertet!");
            System.out.println("Standard Sx_Kontierung aus gxstage_user_rights gefunden - kein Feld Status ausgewertet!");
        }
    }

    public void setHasAllRights(boolean hasAllRights) {
        this.hasAllRights = hasAllRights;
    }

    public Object exec(List l) throws TemplateModelException {
        String method = l.get(0).toString();
        StringBuffer result = new StringBuffer();
        if (method.equals("getSQL")) {
            this.getSQL(l, result);
        }
        if (method.equals("getHHProgAuswahl")) {
            this.getHHProgAuswahl(result);
        }
        if (method.equals("getFondsAuswahl")) {
            this.getFondsAuswahl(result);
        }
        return result.toString();
    }

    private void getHHProgAuswahl(StringBuffer result) throws TemplateModelException {
        if (this.hasAllRights || this.hasAllHHProgRights()) {
            result.append("1=1 --alle HHProg\n");
        } else {
            RestrictionCollector rc = new RestrictionCollector();
            for (SxKontierungsrecht kr : this.rechteSammlung) {
                rc.addOrRestriction(kr.getAuswahl(1, "apnr"));
            }
            result.append("( " + rc.toString() + ")");
        }
    }

    private boolean hasAllHHProgRights() {
        boolean result = false;
        for (SxKontierungsrecht kr : this.rechteSammlung) {
            if (!kr.getHHprog().equals("0")) continue;
            result = true;
        }
        return result;
    }

    private boolean hasAllFondsRights() {
        boolean result = false;
        for (SxKontierungsrecht kr : this.rechteSammlung) {
            if (!kr.getFonds().equals("0")) continue;
            result = true;
        }
        return result;
    }

    private void getFondsAuswahl(StringBuffer result) throws TemplateModelException {
        if (this.hasAllRights || this.hasAllFondsRights()) {
            result.append("1=1 --alle Fonds\n");
        } else {
            RestrictionCollector rc = new RestrictionCollector();
            for (SxKontierungsrecht kr : this.rechteSammlung) {
                rc.addOrRestriction(kr.getAuswahl(2, "ggnr"));
            }
            result.append("( " + rc.toString() + ")");
        }
    }

    private void getSQL(List l, StringBuffer result) throws TemplateModelException {
        if (this.hasAllRights) {
            result.append("1=1 --alle Kontierungen\n");
        } else {
            this.addRechteEinschraenkung(l, result);
        }
    }

    private void addRechteEinschraenkung(List l, StringBuffer result) throws TemplateModelException {
        Field finanzstelleField = null;
        Field hhprogField = null;
        Field fondsField = null;
        Field fiposField = null;
        if (l.get(1) instanceof Field) {
            finanzstelleField = (Field)l.get(1);
        }
        if (l.get(2) instanceof Field) {
            hhprogField = (Field)l.get(2);
        }
        if (l.get(3) instanceof Field) {
            fondsField = (Field)l.get(3);
        }
        if (l.get(4) instanceof Field) {
            fiposField = (Field)l.get(4);
        }
        if (finanzstelleField == null) {
            throw new IllegalStateException("Kein Feld Finanzstelle gefunden - Maske muss Feld enthalten (darf versteckt sein)");
        }
        if (hhprogField == null) {
            throw new IllegalStateException("Kein Feld Haushaltsprogramm gefunden - Maske muss Feld enthalten (darf versteckt sein)");
        }
        if (fondsField == null) {
            throw new IllegalStateException("Kein Feld Fonds gefunden - Maske muss Feld enthalten (darf versteckt sein)");
        }
        if (fiposField == null) {
            throw new IllegalStateException("Kein Feld Finanzposition gefunden - Maske muss Feld enthalten (darf versteckt sein)");
        }
        RestrictionCollector rc = new RestrictionCollector();
        for (SxKontierungsrecht kr : this.rechteSammlung) {
            String r = kr.getSQL(finanzstelleField, hhprogField, fondsField, fiposField);
            if (r.equals("")) continue;
            rc.addOrRestriction(r);
        }
        if (!rc.isSomethingAdded()) {
            throw new IllegalStateException("Keine Berechtigung fuer gewaehlten Stand eines Felds (Finanzstelle/HHProg/Fonds/Finanzposition) gefunden");
        }
        result.append("( " + rc.toString() + ")");
    }

    public void createAndAddEntry(SxResultRow row) {
        SxKontierungsrecht kr = new SxKontierungsrecht(row);
        if (kr.hasAllRights()) {
            this.hasAllRights = true;
        }
        this.rechteSammlung.add(kr);
    }

    public void clearAll() {
        this.hasAllRights = false;
        this.rechteSammlung.clear();
    }
}

