/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.IdObjectI;
import de.memtext.baseobjects.coll.NamedIdObjectList;
import de.memtext.util.DateUtils;
import de.superx.common.RepositoryItem;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.sql.Date;
import java.text.ParseException;
import java.util.List;

public class RepositoryItemCollection
extends NamedIdObjectList
implements IdObjectI,
TemplateHashModel,
TemplateScalarModel,
TemplateMethodModel {
    private Object id;

    public RepositoryItemCollection(Object id) {
        this.setId(id);
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    public String getCaption() {
        if (this.size() == 1) {
            return ((RepositoryItem)this.get(0)).getCaption();
        }
        throw new RuntimeException(this.getFehlermeldung());
    }

    public String getComment() {
        if (this.size() == 1) {
            return ((RepositoryItem)this.get(0)).getComment();
        }
        throw new RuntimeException(this.getFehlermeldung());
    }

    @Override
    public String toString() {
        if (this.size() == 1) {
            return this.get(0).toString();
        }
        throw new RuntimeException(this.getFehlermeldung());
    }

    private String getFehlermeldung() {
        return " mehrere Eintr\u00e4ge f\u00fcr " + String.valueOf(this.getId()) + "  gefunden. " + String.valueOf(this.getId()) + "(\"dd.mm.yyyy\") benutzen";
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key == null) {
            return null;
        }
        SimpleScalar result = null;
        if (key.equalsIgnoreCase("caption")) {
            result = new SimpleScalar(this.getCaption());
        }
        if (key.equalsIgnoreCase("content")) {
            result = new SimpleScalar(this.toString());
        }
        if (key.equalsIgnoreCase("comment")) {
            result = new SimpleScalar(this.getComment());
        }
        return result;
    }

    public String getContent() {
        return this.toString();
    }

    public Object exec(List args) throws TemplateModelException {
        if (args.size() != 1) {
            throw new TemplateModelException("Nur ein Argument (\"dd.mm.yyyy\") erlaubt");
        }
        RepositoryItem result = null;
        try {
            Date datum = DateUtils.parse(args.get(0).toString());
            for (RepositoryItem ri : this) {
                if (!ri.isValidAt(datum)) continue;
                result = ri;
                break;
            }
        }
        catch (ParseException e) {
            throw new TemplateModelException("Ung\u00fcltiges Datumsformat - nur (\"dd.mm.yyyy\") erlaubt");
        }
        return result;
    }

    public String getAsString() throws TemplateModelException {
        return this.toString();
    }
}

