/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebserviceClientKenn
extends AbstractWebserviceClient {
    private Document configDocument;
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    private final String today = DateUtils.getTodayString();
    private String hsnr;
    private String xmlConfig;
    private String datentyp;
    private String url;
    private String soap;
    private String outfilename;
    private File tmpFile;
    private File outFile;
    private String jahr_oder_semester;
    private PrintWriter fw;
    private BufferedWriter bfw;

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientKenn Version 1.2");
        WebserviceClientKenn tc = new WebserviceClientKenn();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            this.initLogging();
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_xmlconfig, GetOpts.Options.opt_hsnr, GetOpts.Options.opt_jahr, GetOpts.Options.opt_out, GetOpts.Options.opt_datentyp});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.perform();
            String msg = "    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            logger.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void perform() throws Exception {
        Node n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "_url");
        this.url = XMLUtils.getTheValue(n);
        this.url = this.adaptURL(this.url);
        logger.fine("URL:" + this.url);
        System.out.println("URL:" + this.url);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "_soap");
        String return_node_name = XMLUtils.getAttribValue(n, "return_node_name");
        this.soap = XMLUtils.getTheValue(n);
        this.soap = this.soap.replace("XXHSNRXX", this.hsnr);
        this.soap = this.soap.replace("XXJAHRXX", this.jahr_oder_semester);
        this.soap = this.soap.replace("XXSEMESTERXX", this.jahr_oder_semester);
        this.initOutFile();
        logger.fine(this.datentyp + "\nSOAP Aufruf:\n" + this.soap);
        this.tmpFile = this.createSoapFile(this.soap, this.url);
        if (this.isReplyOk(this.tmpFile)) {
            String data;
            String columnNames = this.getColumnNames(return_node_name).toString();
            if (!(columnNames = StringUtils.replace(columnNames, return_node_name.toLowerCase() + "_", "")).equals("")) {
                this.bfw.write(columnNames);
            }
            if (!(data = this.getData(return_node_name).toString()).equals("")) {
                this.bfw.write(data);
            }
            this.bfw.flush();
            if (!this.isDeleteTmpXmlFileWanted) {
                System.out.println("Temp Datei: " + this.tmpFile.getAbsolutePath());
                logger.info("Temp Datei: " + this.tmpFile.getAbsolutePath());
            }
            if (this.isDeleteTmpXmlFileWanted) {
                this.tmpFile.delete();
            }
        } else {
            String msg = "Error: Aufruf von Webservice f\u00fcr Kenndaten " + this.datentyp + " (" + this.xmlConfig + ") fehlgeschlagen";
            msg = msg + "\n url:" + this.url + "\nsoap:" + this.soap + "\n";
            System.out.println(msg);
            System.out.println(StringUtils.readFile(this.tmpFile));
            logger.severe(msg);
            LogUtils.close("wc");
            System.exit(-1);
        }
        this.closeFile();
    }

    private void readConfig() throws IOException, SAXException {
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        this.xmlConfig = GetOpts.getValue(GetOpts.Options.opt_xmlconfig);
        this.outfilename = GetOpts.getValue(GetOpts.Options.opt_out);
        this.hsnr = GetOpts.getValue(GetOpts.Options.opt_hsnr);
        this.jahr_oder_semester = GetOpts.getValue(GetOpts.Options.opt_jahr);
        this.datentyp = GetOpts.getValue(GetOpts.Options.opt_datentyp);
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        logger.info("\nHochschulnummer " + this.hsnr);
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        if (Integer.parseInt(this.jahr_oder_semester) < 10000) {
            logger.log(Level.INFO, "Geschaeftsjahr " + this.jahr_oder_semester);
            System.out.println("Geschaeftsjahr " + this.jahr_oder_semester);
        } else {
            logger.log(Level.INFO, "Semester " + this.jahr_oder_semester);
            System.out.println("Semester " + this.jahr_oder_semester);
        }
        logger.log(Level.INFO, "Verarbeite " + this.datentyp + " " + this.xmlConfig);
        System.out.println("Verarbeite " + this.datentyp + " " + this.xmlConfig);
        this.configDocument = XMLUtils.buildDocument(new File(this.xmlConfig));
    }

    private void initOutFile() throws Exception {
        this.outFile = new File(this.outfilename);
        if (this.outFile.exists()) {
            this.outFile.delete();
        }
        this.fw = new PrintWriter(this.outFile);
        this.bfw = new BufferedWriter(this.fw);
    }

    private void closeFile() throws Exception {
        this.bfw.close();
        this.fw.close();
        if (this.isDeleteTmpXmlFileWanted && this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
    }

    private StringBuilder getData(String topnode) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        String datumspattern = "(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)";
        StringBuilder result = new StringBuilder();
        boolean getData = false;
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    String name = parser.getLocalName();
                    if (!name.equals(topnode)) break;
                    getData = true;
                    break;
                }
                case 4: {
                    if (!getData || parser.isWhiteSpace()) break;
                    String data = parser.getText();
                    data = data.matches("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)") ? data.replaceAll("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)", "$3.$2.$1") : WebserviceClientKenn.purge(data, true);
                    if (data.equals("00.00.0000") || data.equals("00.00.00")) {
                        data = this.today;
                    }
                    result.append(data);
                    break;
                }
                case 2: {
                    if (parser.getLocalName().equals(topnode)) {
                        getData = false;
                        break;
                    }
                    if (getData && parser.getLocalName().equals("item")) {
                        result.append("\n");
                        break;
                    }
                    if (!getData) break;
                    result.append("^");
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
        return result;
    }

    private String getColumnNames(String topnode) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        String prefix = topnode.replaceAll("EX_", "");
        StringBuilder result = new StringBuilder();
        boolean getNames = false;
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    String name = parser.getLocalName();
                    if (parser.getLocalName().equals(topnode)) {
                        getNames = true;
                        break;
                    }
                    if (!getNames || name.equals("item")) break;
                    result.append(prefix + "_" + parser.getLocalName() + "^");
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals(topnode) && !parser.getLocalName().equals("item")) break;
                    getNames = false;
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        if (result.length() > 0) {
            result.append("\n");
        }
        return result.toString().toLowerCase();
    }
}

