/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.memtext.util.XMLUtils;
import de.superx.bin.Dosql;
import de.superx.bin.SxExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UnloadSqlFromXml {
    String delim = "^";
    String header = "false";
    String logfile = "../conf/logging.properties";
    String tabelle = "";
    String dbpropfile = "../conf/db.properties";
    String myElement = "table";
    String mySqlAttrib = "script";
    String myOutfileAttrib = "unl";
    String outformat = "txt";
    String outfile = "";
    private static Document document;
    public Logger logger = Logger.getLogger(SxExtractor.class.toString());
    private static String usage;

    public UnloadSqlFromXml(String[] args) throws IOException, SAXException {
        String sql = "";
        String unl = "";
        String _dateiPfad = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_logger, GetOpts.Options.opt_dbprops, GetOpts.Options.opt_xml, GetOpts.Options.opt_element, GetOpts.Options.opt_sqlAttribute, GetOpts.Options.opt_outfileAttribute});
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_logger)) {
            this.logfile = GetOpts.getValue(GetOpts.Options.opt_logger);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_dbprops)) {
            this.dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_xml)) {
            _dateiPfad = GetOpts.getValue(GetOpts.Options.opt_xml);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_element)) {
            this.myElement = GetOpts.getValue(GetOpts.Options.opt_element);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_sqlAttribute)) {
            this.mySqlAttrib = GetOpts.getValue(GetOpts.Options.opt_sqlAttribute);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_outfileAttribute)) {
            this.myOutfileAttrib = GetOpts.getValue(GetOpts.Options.opt_outfileAttribute);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_outFormat)) {
            this.outformat = GetOpts.getValue(GetOpts.Options.opt_outFormat);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_delim)) {
            this.delim = GetOpts.getValue(GetOpts.Options.opt_delim);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_header)) {
            this.header = GetOpts.getValue(GetOpts.Options.opt_header);
        }
        if (args.length > 0) {
            this.logfile = args[0].trim();
        } else {
            System.err.println("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, Pfad zur SQL-Datei) erfoderlich");
            System.exit(1);
        }
        File f = new File(this.logfile);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + this.logfile);
        }
        FileInputStream ins = new FileInputStream(this.logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        this.logfile = MyLogManager.getProperty(".level");
        this.logger.info("Using Loggging-Level " + this.logfile);
        document = XMLUtils.buildDocument(new File(_dateiPfad), false);
        NodeList myNodes = document.getElementsByTagName(this.myElement);
        for (int i = 0; i < myNodes.getLength(); ++i) {
            Node myNode = myNodes.item(i);
            if (myNode.getNodeType() == 3) continue;
            sql = XMLUtils.getAttribValue(myNode, this.mySqlAttrib);
            unl = XMLUtils.getAttribValue(myNode, this.myOutfileAttrib);
            if (sql.equals("") || unl.equals("")) continue;
            String[] myArgs = new String[10];
            myArgs[0] = args[0].trim();
            myArgs[1] = args[1].trim();
            myArgs[2] = sql;
            myArgs[3] = this.outformat;
            myArgs[4] = this.delim;
            myArgs[5] = this.header;
            myArgs[6] = unl;
            try {
                Dosql.execute(myArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(sql);
        }
    }

    public static void main(String[] args) {
        try {
            UnloadSqlFromXml unloadSqlFromXml = new UnloadSqlFromXml(args);
        }
        catch (Exception ex) {
            System.err.println("Fehler: " + String.valueOf(ex));
            ex.printStackTrace();
        }
    }

    static {
        usage = "-------------------------------------\nGebrauch: java de.superx.bin.UnloadTableFromXml -logger=<<Pfad zu logging.properties>> -dbproperties=<<Pfad zu db.properties>> -xml:<xml-Datei> -element:<XML-Element> -attribute:<XML-Attribut mit Tabellenname> -outFormat:<Ausgabeformat (txt | html | xml)>(optional)  -delim:<delimiter> -header:<mit Spalten\u00fcberschriften (true | false)>(optional) -outfile:<Ausgabedatei>(optional) \n---------------------------------------------------";
    }
}

