/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.superx.rest.EtlJobApi;
import de.superx.rest.model.job.Component;
import de.superx.rest.model.job.JobExecutionStatus;
import de.superx.rest.model.job.StepExecutionStatus;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.spring.batch.His1DataSources;
import de.superx.spring.cli.config.CLIConfig;
import de.superx.spring.config.BatchConfig;
import de.superx.spring.config.DataJdbcConfiguration;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;

public class EtlFuzzer {
    private static String HELP = "Use this tool to check for problems with incongruencies, which may occur while running etljobs. Note that Tomcat should not be running, due to resulting interferences. Additionally, the usage of the latest version of the data sample in the source systems is recommendedWARNING: you can only run either all of the mbs modules at once or on of them, before youmust reset your mbs database. It will crash otherwise.";
    private static Logger log = Logger.getLogger((String)EtlFuzzer.class.getName());
    private static int EXTREME_INT = 2100000000;
    private static Random random = new Random();
    private static final String COLNAME_NULLABLE = "is_nullable";
    private static final String COLNAME_COLUMN = "column_name";
    private static final String COLNAME_DATATYPE = "data_type";
    private static final String COLNAME_CHAR_MAX = "character_maximum_length";
    private static final String COLNAME_PRECISION = "numeric_precision";
    private static final String COLNAME_SCALE = "numeric_scale";
    private static final String COLNAME_TABLE = "table_name";
    private static final String COLNAME_RELNAME = "relname";
    private static final String DB_MBS = "mbs";
    private static final String DB_H1 = "hisinone";
    private static int extreme_int_puffer = 10000;
    private static String SQL_GET_ACCESSED_TABLES_H1 = "Select * from pg_stat_all_tables where (seq_scan > 0 or seq_tup_read > 0 or idx_scan > 0) and schemaname = 'hisinone'";
    private static String SQL_GET_ACCESSED_TABLES_MBS = "Select * from pg_stat_all_tables where (seq_scan > 0 or seq_tup_read > 0 or idx_scan > 0) and schemaname = 'mbs'";
    private static String SQL_GET_TABLE_METADATA_BASE = "select column_name, data_type, is_nullable, numeric_precision, numeric_scale, character_maximum_length from information_schema.columns where table_name =";
    private static String SQL_RESET_STATISTICS = "Select pg_stat_reset()";
    private static String[] modulesH1 = new String[]{"kern", "cob", "prom", "sos", "res", "zul"};
    private static String[] modulesMBS = new String[]{"fin", "ivs", "bau"};
    private static final int MODULES_KERN_INDEX = 0;
    private static final int MODULES_COB_INDEX = 1;
    private static final int MODULES_PROM_INDEX = 2;
    private static final int MODULES_SOS_INDEX = 3;
    private static final int MODULES_RES_INDEX = 4;
    private static final int MODULES_ZUL_INDEX = 5;
    private static final int MODULES_FIN_INDEX = 0;
    private static final int MODULES_IVS_INDEX = 1;
    private static final int MODULES_BAU_INDEX = 2;
    private static int next_id = 0;
    private static int next_join_nr = 0;
    private static ArrayList<String> errors = new ArrayList();
    static HashMap<String, String> error_tables_columns = new HashMap();
    private static ArrayList<String> error_keys = new ArrayList();
    private static ApplicationContext applicationContext;
    private static GenericApplicationContext APPLICATION_CONTEXT;

    private static void setNext_join_nr(int next_nr) {
        next_join_nr = next_nr;
    }

    private static void setNext_id(int next_id) {
        EtlFuzzer.next_id = next_id;
    }

    private static String StringGenerator(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("x");
        }
        return sb.toString();
    }

    private static String NumGen(int precision, int scale) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < precision; ++i) {
            sb.append("9");
        }
        String num = sb.toString();
        String firstPart = num.substring(0, precision - scale);
        String secondPart = num.substring(precision - scale);
        return firstPart + "." + secondPart;
    }

    private static ArrayList<String> getAccessedTablesH1(JdbcTemplate jt, final ArrayList<String> tables) throws SQLException {
        ResultSetExtractor<Void> extractor = new ResultSetExtractor<Void>(){

            public Void extractData(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    tables.add(rs.getString(EtlFuzzer.COLNAME_RELNAME));
                }
                return null;
            }
        };
        jt.query(SQL_GET_ACCESSED_TABLES_H1, (ResultSetExtractor)extractor);
        return tables;
    }

    private static ArrayList<String> getAccessedTablesMBS(JdbcTemplate jt, final ArrayList<String> tables) throws SQLException {
        ResultSetExtractor<Void> extractor = new ResultSetExtractor<Void>(){

            public Void extractData(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    tables.add(rs.getString(EtlFuzzer.COLNAME_RELNAME));
                }
                return null;
            }
        };
        jt.query(SQL_GET_ACCESSED_TABLES_MBS, (ResultSetExtractor)extractor);
        return tables;
    }

    private static String sqlTableMetaDataH1(String table) {
        return SQL_GET_TABLE_METADATA_BASE + "'" + table + "'";
    }

    private static String sqlTableMetaDataMBS(String table) {
        return String.format("%s '%s' and table_schema='mbs'", SQL_GET_TABLE_METADATA_BASE, table);
    }

    public static <T> T getBean(String beanName, Class<T> requiredType) {
        if (applicationContext != null) {
            return (T)applicationContext.getBean(beanName, requiredType);
        }
        return null;
    }

    private static void initSxPools() {
        try {
            LinkedList<String> mandantenNamen = new LinkedList<String>();
            mandantenNamen.add(SxSQL_Server.DEFAULT_MANDANTEN_ID);
            SxPools.closeAll();
            SxPools.init(mandantenNamen);
            SxPools.get(SxSQL_Server.DEFAULT_MANDANTEN_ID).init();
            SxPools.get(SxSQL_Server.DEFAULT_MANDANTEN_ID).initLogging(true, Level.DEBUG);
        }
        catch (Exception e) {
            System.out.println("error while initialising the SuperX pools:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static GenericApplicationContext createContext() {
        if (APPLICATION_CONTEXT == null) {
            APPLICATION_CONTEXT = new AnnotationConfigApplicationContext(new Class[]{BatchConfig.class, DataJdbcConfiguration.class, CLIConfig.class});
        }
        return APPLICATION_CONTEXT;
    }

    private static boolean isHauptladeroutine(String comp, EtlJobApi etlJob) {
        List<Component> installJobs = etlJob.getEtlJobs();
        for (Component comp_meta : installJobs) {
            if (comp_meta == null || !comp_meta.getAbbreviation().equals(comp)) continue;
            return true;
        }
        return false;
    }

    private static String timestampMaker(String d) {
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        SimpleDateFormat formatterNow = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat formatterDay = new SimpleDateFormat("yyyy-MM-dd");
        String time = "";
        switch (d) {
            case "day": {
                time = formatterDay.format(ts);
                break;
            }
            case "now": {
                time = formatterNow.format(ts);
            }
        }
        return time;
    }

    private static void etlJob(String job_id, GenericApplicationContext context, String db) {
        System.out.println(job_id);
        try {
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            String database = db;
            Long jobStartStatus = EtlFuzzer.isHauptladeroutine(job_id, componentApi) ? componentApi.complete(job_id) : componentApi.executeJob(database, job_id);
            EtlFuzzer.handleStartResult(jobStartStatus, componentApi);
        }
        catch (BeansException be) {
            EtlFuzzer.handleBeansException(be);
        }
        catch (Exception e) {
            EtlFuzzer.handleJobException(e, job_id);
        }
    }

    private static void unload(String job_id, GenericApplicationContext context, String db) {
        System.out.println(job_id);
        try {
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            String database = db;
            Long jobStartStatus = EtlFuzzer.isHauptladeroutine(job_id, componentApi) ? componentApi.unload(job_id) : componentApi.executeJob(database, job_id);
            EtlFuzzer.handleStartResult(jobStartStatus, componentApi);
        }
        catch (BeansException be) {
            EtlFuzzer.handleBeansException(be);
        }
        catch (Exception e) {
            EtlFuzzer.handleJobException(e, job_id);
        }
    }

    public static String findInt(String input) {
        Pattern pattern = Pattern.compile("\u00bb\\d+\u00ab");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            String match = matcher.group();
            return match.substring(1, match.length() - 1);
        }
        return null;
    }

    private static void collectErrors(StepExecutionStatus ses) {
        for (StepExecutionStatus sec : ses.getChildren()) {
            if (sec.getChildren() == null) continue;
            for (StepExecutionStatus sec2 : sec.getChildren()) {
                if (!sec2.getExitStatus().getExitCode().equals("FAILED")) continue;
                errors.add(sec2.getName());
                String etl_error = sec2.getExitStatus().getExitDescription();
                errors.add(etl_error);
                if (!error_tables_columns.containsKey(EtlFuzzer.findInt(etl_error))) continue;
                error_keys.add(EtlFuzzer.findInt(etl_error));
            }
        }
    }

    private static void handleStartResult(Long jobStartStatus, EtlJobApi componentApi) {
        if (jobStartStatus.intValue() == -1) {
            System.out.println("Aktion konnte nicht gestartet werden: Es l\u00e4uft bereits eine Aktion");
            System.exit(1);
        }
        try {
            JobExecutionStatus es = componentApi.getStatus(jobStartStatus);
            for (StepExecutionStatus ses : es.getStepExecutions()) {
                EtlFuzzer.collectErrors(ses);
            }
            ExitStatus exst = es.exitStatus;
            if (exst.equals((Object)ExitStatus.FAILED)) {
                System.out.println("Beim Ausf\u00fchren der Aktion ist ein Fehler aufgetreten; Bitte pr\u00fcfen Sie die Logdatei.");
            }
        }
        catch (Exception e) {
            System.out.println("Beim Ausf\u00fchren der Aktion ist ein Fehler aufgetreten:");
            e.printStackTrace();
        }
    }

    private static void handleJobException(Exception e, String jobName) {
        System.out.println("error while executing the job '" + jobName + "'");
        e.printStackTrace();
    }

    private static void handleBeansException(BeansException be) {
        System.out.println("configuration error or error with resolving the bean '" + EtlJobApi.class.getCanonicalName() + "'");
        be.printStackTrace();
    }

    private static void printList(ArrayList<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String text = list.get(i);
            log.info((Object)String.format(" %s", text));
        }
    }

    private static void printIntErrors() {
        for (String key : error_keys) {
            String intError = String.format("Der Wert: %s wurde initial in die Tabelle.Spalte: %s eingetragen.", key, error_tables_columns.get(key));
            log.info((Object)intError);
        }
    }

    private static void nextID(JdbcTemplate jt, String table, String column_name, String db) {
        ResultSetExtractor<Void> extractor = new ResultSetExtractor<Void>(){

            public Void extractData(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    EtlFuzzer.setNext_id(rs.getInt(1) + 1);
                }
                return null;
            }
        };
        if (db.equals(DB_H1)) {
            String SQL_highest_id = String.format("Select max(%s) from %s", column_name, table);
            jt.query(SQL_highest_id, (ResultSetExtractor)extractor);
        } else {
            String SQL_highest_id = String.format("Select max(%s) from mbs.%s", column_name, table);
            jt.query(SQL_highest_id, (ResultSetExtractor)extractor);
        }
    }

    private static void next_nr(JdbcTemplate jt, String table, String column_name) {
        ResultSetExtractor<Void> extractor = new ResultSetExtractor<Void>(){

            public Void extractData(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    EtlFuzzer.setNext_join_nr(rs.getInt(1) + 1);
                }
                return null;
            }
        };
        String SQL_highest_nr = String.format("select max(%s) from mbs.%s", column_name, table);
        jt.query(SQL_highest_nr, (ResultSetExtractor)extractor);
    }

    public static String separateWithComma(ArrayList<String> array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            sb.append(array.get(i));
            if (i >= array.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static String createTrap(ArrayList<String> traps, String table, String db) {
        String trap = "";
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < traps.size(); ++i) {
            if (i % 2 == 0) {
                columns.add(traps.get(i));
                continue;
            }
            values.add(traps.get(i));
        }
        if (db.equals(DB_H1)) {
            trap = String.format("Insert into %s (%s) values (%s)", table, EtlFuzzer.separateWithComma(columns), EtlFuzzer.separateWithComma(values));
        } else if (db.equals(DB_MBS)) {
            trap = String.format("Insert into mbs.%s (%s) values (%s)", table, EtlFuzzer.separateWithComma(columns), EtlFuzzer.separateWithComma(values));
        }
        return trap;
    }

    private static void insertTraps(final JdbcTemplate jt, final String table, final String db) {
        ResultSetExtractor<Void> extractor = new ResultSetExtractor<Void>(){

            public Void extractData(ResultSet rs) throws SQLException {
                ArrayList<String> traps = new ArrayList<String>();
                while (rs.next()) {
                    if (rs.getString(EtlFuzzer.COLNAME_NULLABLE).equals("YES")) {
                        traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                        traps.add("null");
                        continue;
                    }
                    if (!rs.getString(EtlFuzzer.COLNAME_NULLABLE).equals("NO")) continue;
                    if (rs.getString(EtlFuzzer.COLNAME_COLUMN).equals("id") || rs.getString(EtlFuzzer.COLNAME_COLUMN).endsWith("_id") || rs.getString(EtlFuzzer.COLNAME_COLUMN).equals("lid") || rs.getString(EtlFuzzer.COLNAME_COLUMN).endsWith("_lid")) {
                        EtlFuzzer.nextID(jt, table, rs.getString(EtlFuzzer.COLNAME_COLUMN), db);
                        traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                        traps.add(String.valueOf(next_id));
                        continue;
                    }
                    if (rs.getString(EtlFuzzer.COLNAME_COLUMN).equals("join_nr")) {
                        EtlFuzzer.next_nr(jt, table, rs.getString(EtlFuzzer.COLNAME_COLUMN));
                        traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                        traps.add(String.valueOf(next_join_nr));
                        continue;
                    }
                    if (rs.getString(EtlFuzzer.COLNAME_DATATYPE).equals("integer")) {
                        int randomNumber = EXTREME_INT + random.nextInt(extreme_int_puffer);
                        String number = Integer.toString(randomNumber);
                        traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                        traps.add(number);
                        error_tables_columns.put(number, String.format("%s.%s", table, rs.getString(EtlFuzzer.COLNAME_COLUMN)));
                        continue;
                    }
                    if (rs.getString(EtlFuzzer.COLNAME_DATATYPE).equals("character varying")) {
                        String longString;
                        int max_length = rs.getInt(EtlFuzzer.COLNAME_CHAR_MAX);
                        String col = rs.getString(EtlFuzzer.COLNAME_COLUMN);
                        if (rs.getObject(EtlFuzzer.COLNAME_CHAR_MAX) != null) {
                            int length = max_length - table.length() - col.length() - 2;
                            if (max_length <= table.length()) {
                                traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                                traps.add(String.format("'%s'", EtlFuzzer.StringGenerator(max_length)));
                                continue;
                            }
                            if (table.length() + col.length() >= max_length) {
                                length = max_length - table.length() - 1;
                                traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                                traps.add(String.format("'%s:%s'", table, EtlFuzzer.StringGenerator(length)));
                                continue;
                            }
                            longString = EtlFuzzer.StringGenerator(length);
                            traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                            traps.add(String.format("'%s.%s%s'", table, col, longString));
                            continue;
                        }
                        int string_length = random.nextInt(501) + 2500;
                        longString = EtlFuzzer.StringGenerator(string_length);
                        traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                        traps.add(String.format("'%s.%s:%s'", table, col, longString));
                        continue;
                    }
                    if (rs.getString(EtlFuzzer.COLNAME_DATATYPE).equals("timestamp without time zone")) {
                        traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                        traps.add("'" + EtlFuzzer.timestampMaker("now") + "'");
                        continue;
                    }
                    if (rs.getString(EtlFuzzer.COLNAME_DATATYPE).equals("numeric")) {
                        int precision = rs.getInt(EtlFuzzer.COLNAME_PRECISION);
                        int scale = rs.getInt(EtlFuzzer.COLNAME_SCALE);
                        traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                        traps.add(String.format("%s", EtlFuzzer.NumGen(precision, scale)));
                        continue;
                    }
                    if (!rs.getString(EtlFuzzer.COLNAME_DATATYPE).equals("date")) continue;
                    traps.add(rs.getString(EtlFuzzer.COLNAME_COLUMN));
                    traps.add("'" + EtlFuzzer.timestampMaker("day") + "'");
                }
                if (db.equals(EtlFuzzer.DB_H1)) {
                    String trap = EtlFuzzer.createTrap(traps, table, db);
                    log.info((Object)trap);
                    String disableTrigger = String.format("alter table %s disable trigger all;", table);
                    String enableTrigger = String.format("alter table %s enable trigger all;", table);
                    jt.update(disableTrigger);
                    jt.update(trap);
                    jt.update(enableTrigger);
                } else if (db.equals(EtlFuzzer.DB_MBS)) {
                    String trap = EtlFuzzer.createTrap(traps, table, db);
                    log.info((Object)trap);
                    String disableTrigger = String.format("alter table mbs.%s disable trigger all;", table);
                    String enableTrigger = String.format("alter table mbs.%s enable trigger all;", table);
                    jt.update(disableTrigger);
                    jt.update(trap);
                    jt.update(enableTrigger);
                }
                return null;
            }
        };
        if (db.equals(DB_H1)) {
            String query = EtlFuzzer.sqlTableMetaDataH1(table);
            try {
                jt.query(query, (ResultSetExtractor)extractor);
            }
            catch (Exception e) {
                log.error((Object)("Fehler bei Statement (Vorbereitung/Setup):\n" + query + "\n" + e.getMessage()));
            }
        } else if (db.equals(DB_MBS)) {
            String query = EtlFuzzer.sqlTableMetaDataMBS(table);
            try {
                jt.query(query, (ResultSetExtractor)extractor);
            }
            catch (Exception e) {
                log.error((Object)("Fehler bei Statement (Vorbereitung/Setup):\n" + query + "\n" + e.getMessage()));
            }
        }
    }

    private static void resetStats(JdbcTemplate jt) {
        log.info((Object)"Zur\u00fccksetzung der Statistiken gestartet...");
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
            }
        };
        jt.query(SQL_RESET_STATISTICS, handler);
        log.info((Object)"Statistiken erfolgreich zur\u00fcckgesetzt");
    }

    private static void removeTraps(JdbcTemplate jt, ArrayList<String> tables) {
        for (int i = 0; i < tables.size(); ++i) {
            String table = tables.get(i);
            if (table.startsWith("tmp")) continue;
            String deleteEntry = String.format("ALTER TABLE %s DISABLE TRIGGER ALL; delete from %s where id in (select max(id) from %s); alter table %s enable trigger all;", table, table, table, table);
            jt.update(deleteEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkH1(String[] checked_modules) {
        ArrayList<String> tables = new ArrayList<String>();
        JdbcTemplate jt = new JdbcTemplate();
        try (GenericApplicationContext context = EtlFuzzer.createContext();){
            EtlFuzzer.initSxPools();
            His1DataSources hds = (His1DataSources)context.getBean(His1DataSources.class);
            DataSource ds = hds.get(DB_H1);
            jt.setDataSource(ds);
            EtlFuzzer.resetStats(jt);
            log.info((Object)"Unloadscript (Analysedurchlauf) gestartet...");
            for (String m : checked_modules) {
                EtlFuzzer.unload(m, context, DB_H1);
            }
            log.info((Object)"Unloadscript (Analysedurchlauf) erfolgreich abgeschlossen.");
            tables = EtlFuzzer.getAccessedTablesH1(jt, tables);
            EtlFuzzer.printList(tables);
            log.info((Object)"zugegriffene Tabellen erfolgreich abgefangen");
            log.info((Object)"Einf\u00fcgen von Extremwerten gestartet...");
            for (int i = 0; i < tables.size(); ++i) {
                EtlFuzzer.insertTraps(jt, tables.get(i), DB_H1);
            }
            log.info((Object)"Extremwerte erfolgreich eingef\u00fcgt");
            log.info((Object)"Hauptladeroutine (Fuzzingtestdurchlauf) gestartet...");
            for (String m : checked_modules) {
                EtlFuzzer.etlJob(m, context, DB_H1);
            }
            log.info((Object)"Hauptladeroutine (Fuzzingtestdurchlauf) erfolgreich.");
            EtlFuzzer.printList(errors);
            EtlFuzzer.printIntErrors();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (DataIntegrityViolationException e) {
            e.printStackTrace();
        }
        catch (BadSqlGrammarException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            errors.clear();
            error_keys.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkMBS(String[] checked_modules) {
        ArrayList<String> tables = new ArrayList<String>();
        JdbcTemplate jt = new JdbcTemplate();
        try (GenericApplicationContext context = EtlFuzzer.createContext();){
            EtlFuzzer.initSxPools();
            His1DataSources hds = (His1DataSources)context.getBean(His1DataSources.class);
            DataSource ds = hds.get(DB_MBS);
            jt.setDataSource(ds);
            EtlFuzzer.resetStats(jt);
            log.info((Object)"Unloadscript (Analysedurchlauf) gestartet...");
            for (String m : checked_modules) {
                EtlFuzzer.unload(m, context, DB_MBS);
            }
            log.info((Object)"Unloadscript (Analysedurchlauf) erfolgreich abgeschlossen.");
            tables = EtlFuzzer.getAccessedTablesMBS(jt, tables);
            EtlFuzzer.printList(tables);
            log.info((Object)"zugegriffene Tabellen erfolgreich abgefangen");
            log.info((Object)"Einf\u00fcgen von Extremwerten gestartet...");
            for (int i = 0; i < tables.size(); ++i) {
                EtlFuzzer.insertTraps(jt, tables.get(i), DB_MBS);
            }
            log.info((Object)"Extremwerte erfolgreich eingef\u00fcgt");
            log.info((Object)"Hauptladeroutine (Fuzzingtestdurchlauf) gestartet...");
            for (String m : checked_modules) {
                EtlFuzzer.etlJob(m, context, DB_MBS);
            }
            log.info((Object)"Hauptladeroutine (Fuzzingtestdurchlauf) erfolgreich.");
            EtlFuzzer.printList(errors);
            EtlFuzzer.printIntErrors();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (DataIntegrityViolationException e) {
            e.printStackTrace();
        }
        catch (BadSqlGrammarException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            errors.clear();
            error_keys.clear();
        }
    }

    private static CommandLine parseArgs(String[] args, Options options) {
        GnuParser parser = new GnuParser();
        try {
            return parser.parse(options, args, false);
        }
        catch (ParseException e) {
            System.out.println("error while reading the command line parameters:");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        Option opt = new Option("h", "help", false, "get help");
        options.addOption(opt);
        opt = new Option("rh1", "run-h1", false, "runs the script for all h1 modules");
        options.addOption(opt);
        opt = new Option("rmbs", "run-mbs", false, "runs the script for all mbs modules");
        options.addOption(opt);
        opt = new Option("rk", "run-kern", false, "runs the script for kern module");
        options.addOption(opt);
        opt = new Option("rc", "run-cob", false, "runs the script for cob module");
        options.addOption(opt);
        opt = new Option("rf", "run-fin", false, "runs the script for fin module");
        options.addOption(opt);
        opt = new Option("ri", "run-ivs", false, "runs the script for ivs module");
        options.addOption(opt);
        opt = new Option("rb", "run-bau", false, "runs the script for bau module");
        options.addOption(opt);
        opt = new Option("rs", "run-sos", false, "runs the script for sos module");
        options.addOption(opt);
        opt = new Option("rp", "run-prom", false, "runs the script for prom module");
        options.addOption(opt);
        opt = new Option("rz", "run-zul", false, "runs the script for zul module");
        options.addOption(opt);
        opt = new Option("rr", "run-res", false, "runs the script for res module");
        options.addOption(opt);
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(HELP, options);
    }

    public static void main(String[] args) {
        System.setProperty("SuperX-HISinOne-VERSION", "non-empty-value");
        Options options = EtlFuzzer.createOptions();
        CommandLine parsedArgs = EtlFuzzer.parseArgs(args, options);
        if (parsedArgs.hasOption("h")) {
            EtlFuzzer.printHelp(options);
        } else if (parsedArgs.hasOption("rh1")) {
            EtlFuzzer.checkH1(modulesH1);
        } else if (parsedArgs.hasOption("rmbs")) {
            EtlFuzzer.checkMBS(modulesMBS);
        } else if (parsedArgs.hasOption("rk")) {
            String[] module = new String[]{modulesH1[0]};
            EtlFuzzer.checkH1(module);
        } else if (parsedArgs.hasOption("rc")) {
            String[] module = new String[]{modulesH1[1]};
            EtlFuzzer.checkH1(module);
        } else if (parsedArgs.hasOption("rf")) {
            String[] module = new String[]{modulesMBS[0]};
            EtlFuzzer.checkMBS(module);
        } else if (parsedArgs.hasOption("ri")) {
            String[] module = new String[]{modulesMBS[1]};
            EtlFuzzer.checkMBS(module);
        } else if (parsedArgs.hasOption("rb")) {
            String[] module = new String[]{modulesMBS[2]};
            EtlFuzzer.checkMBS(module);
        } else if (parsedArgs.hasOption("rs")) {
            String[] module = new String[]{modulesH1[3]};
            EtlFuzzer.checkH1(module);
        } else if (parsedArgs.hasOption("rp")) {
            String[] module = new String[]{modulesH1[2]};
            EtlFuzzer.checkH1(module);
        } else if (parsedArgs.hasOption("rz")) {
            String[] module = new String[]{modulesH1[5]};
            EtlFuzzer.checkH1(module);
        } else if (parsedArgs.hasOption("rr")) {
            String[] module = new String[]{modulesH1[4]};
            EtlFuzzer.checkH1(module);
        } else {
            EtlFuzzer.printHelp(options);
        }
    }

    static {
        APPLICATION_CONTEXT = null;
    }
}

