/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.util.SqlStringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class AbstractWebserviceClient {
    int pause = 0;
    boolean isDeleteTmpXmlFileWanted = true;
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    protected String auth = null;
    protected static final String DATUMSPATTERN = "(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)";
    protected static final Logger logger = Logger.getLogger("wc");
    private static final Pattern INVALID_XML_PATTERN = Pattern.compile("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFF]+");
    private static final String XSLT_REMOVE_NAMESPACE = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n    <xsl:output method=\"xml\" />\n    <xsl:template match=\"*\">\n        <xsl:element name=\"{local-name()}\">\n            <xsl:apply-templates select=\"@*|node()\"/>\n        </xsl:element>\n    </xsl:template>\n    <xsl:template match=\"@*\">\n        <xsl:attribute name=\"{local-name()}\"><xsl:value-of select=\".\"/></xsl:attribute>\n    </xsl:template>\n</xsl:stylesheet>";
    private Transformer transformerRemoveNamespace;

    public AbstractWebserviceClient() {
        String a = System.getProperty("SOAP-AUTH");
        if (a != null && !a.equals("")) {
            this.auth = a;
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String prot = this.getRequestingProtocol().toLowerCase();
                    String host = System.getProperty(prot + ".proxyHost", "");
                    String port = System.getProperty(prot + ".proxyPort", "");
                    String user = System.getProperty(prot + ".proxyUser", "");
                    String password = System.getProperty(prot + ".proxyPassword", "");
                    if (this.getRequestingHost().toLowerCase().equals(host.toLowerCase()) && Integer.parseInt(port) == this.getRequestingPort()) {
                        return new PasswordAuthentication(user, password.toCharArray());
                    }
                }
                return null;
            }
        });
    }

    protected static String adaptDatePattern(String input) {
        input = input.replaceAll("0000-00-00", "");
        return input.replaceAll(DATUMSPATTERN, "$3.$2.$1");
    }

    protected String format(String input) {
        return input.replaceAll("<Envelope", "\n<Envelope");
    }

    protected StringBuffer readSOAP(String soapxml, String url) throws Exception {
        int attempt = 1;
        boolean allDone = false;
        Exception exception = null;
        StringBuffer result = new StringBuffer();
        while (!allDone && attempt < 4) {
            try {
                if (this.pause > 0) {
                    Thread.sleep(this.pause * 1000);
                }
                SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
                SOAPConnection soapConnection = soapConnectionFactory.createConnection();
                SOAPMessage sr = this.getSoapMessageFromString(soapxml);
                sr.getMimeHeaders().addHeader("SOAPAction", "http://sap.com/xi/WebService/soap1.1");
                this.addAuthentification(sr);
                SOAPMessage soapResponse = soapConnection.call(sr, (Object)url);
                result.append(this.extractString(soapResponse));
                soapConnection.close();
                System.gc();
                if (result.indexOf("<Fault>") > -1) {
                    throw new IllegalStateException("Webservice meldet Fehler - kein Netzwerkproblem:\n" + String.valueOf(result));
                }
                allDone = true;
            }
            catch (Exception e) {
                exception = e;
                System.out.println(DateUtils.getNowString() + " Aufruf fehlgeschlagen (s. WebserviceLog) - versuche erneut");
                StringWriter swException = new StringWriter();
                PrintWriter pw = new PrintWriter(swException);
                e.printStackTrace(pw);
                Logger.getLogger("wc").severe(" Problem bei Aufruf von " + url + "\n" + soapxml + "\n" + swException.toString());
                ++attempt;
            }
        }
        if (!allDone) {
            throw exception;
        }
        return result;
    }

    protected boolean isReplyOk(StringBuffer data) throws SAXException, IOException {
        Node type;
        boolean result = false;
        Document resultDocument = XMLUtils.buildDocumentFromString(data, false);
        if (XMLUtils.hasANodeWithName(resultDocument, "TYPE") && XMLUtils.getTheValue(type = XMLUtils.getFirstNode(resultDocument, "TYPE")).equals("I")) {
            result = true;
        }
        return result;
    }

    private String extractString(SOAPMessage soapResponse) throws SOAPException, IOException, TransformerException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        soapResponse.writeTo((OutputStream)out);
        String strMsg = new String(out.toByteArray());
        strMsg = AbstractWebserviceClient.replaceHighSurrogates(strMsg);
        StringWriter writer = new StringWriter();
        if (this.transformerRemoveNamespace == null) {
            this.initTransformerNamespace();
        }
        this.transformerRemoveNamespace.transform(new StreamSource(new StringReader(strMsg)), new StreamResult(writer));
        strMsg = writer.toString();
        return strMsg;
    }

    private void initTransformerNamespace() throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        this.transformerRemoveNamespace = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(XSLT_REMOVE_NAMESPACE)));
        this.transformerRemoveNamespace.setOutputProperty("indent", "yes");
        this.transformerRemoveNamespace.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
    }

    protected File createSoapFile(String soapxml, String url) throws Exception {
        int attempt = 1;
        boolean allDone = false;
        try {
            Logger.getLogger("com.sun.xml.internal.messaging.saaj.client.p2p", "com.sun.xml.internal.messaging.saaj.client.p2p.LocalStrings").setLevel(Level.OFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Exception exception = null;
        File tmpF = File.createTempFile("soapdata", ".xml");
        while (!allDone && attempt < 5) {
            try {
                if (tmpF.exists()) {
                    tmpF.delete();
                }
                if (this.pause > 0) {
                    Thread.sleep(this.pause * 1000);
                }
                SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
                SOAPConnection soapConnection = soapConnectionFactory.createConnection();
                SOAPMessage sr = this.getSoapMessageFromString(soapxml);
                sr.getMimeHeaders().addHeader("SOAPAction", "http://sap.com/xi/WebService/soap1.1");
                this.addAuthentification(sr);
                SOAPMessage soapResponse = soapConnection.call(sr, (Object)url);
                String strMsg = this.extractString(soapResponse);
                Files.writeString(tmpF.toPath(), (CharSequence)strMsg, StandardOpenOption.CREATE);
                soapConnection.close();
                System.gc();
                allDone = true;
            }
            catch (Exception e) {
                exception = e;
                System.out.println("\n" + DateUtils.getNowString() + " Aufruf fehlgeschlagen (s. WebserviceLog) - versuche erneut");
                StringWriter swException = new StringWriter();
                PrintWriter pw = new PrintWriter(swException);
                e.printStackTrace(pw);
                Logger.getLogger("wc").severe(" Problem bei Webservice Abruf\n" + url + "\n" + soapxml + swException.toString() + (attempt < 4 ? " versuche erneut:\n" : " zu viele Fehlschlaege - gebe frustriert auf"));
                ++attempt;
            }
        }
        if (!allDone) {
            throw exception;
        }
        return tmpF;
    }

    protected SOAPMessage getSoapMessageFromString(String xml) throws SOAPException, IOException {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(xml.getBytes(Charset.forName("UTF-8"))));
        return message;
    }

    protected String removeXmlHeader(String input) {
        return input.replaceAll("<\\?xml.*\\?>", "");
    }

    public static String replaceHighSurrogates(String input) {
        int posSemikolon;
        StringBuffer buf = new StringBuffer(input);
        int codePointStringBegin = 3;
        boolean hex = true;
        int pos = buf.indexOf("&#x");
        String replacer = "?";
        while (pos > -1 && (posSemikolon = buf.indexOf(";", pos)) > -1) {
            String encodedString = buf.substring(pos, posSemikolon + 1);
            String encodedHex = encodedString.substring(3, encodedString.length() - 1);
            try {
                int decimalNumber = Integer.parseInt(encodedHex, 16);
                if (decimalNumber >= 55296) {
                    buf.replace(pos, posSemikolon + 1, replacer);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            pos = buf.indexOf("&#x", pos + 1);
        }
        return buf.toString();
    }

    static String purge(String data, boolean removeJest) {
        data = XMLUtils.removeTroublesomeCharacters(data);
        data = data.replaceAll("\u20ac", "EUR");
        data = data.replaceAll("&#x20ac;", "EUR");
        data = data.replaceAll("&#x20AC;", "EUR");
        data = data.replaceAll("\u2013", "-");
        data = data.replaceAll("&#x2013;", "-");
        data = data.replaceAll("\u2026", "...");
        data = data.replaceAll("&#x2026;", "...");
        data = data.replaceAll("\u1e9e", "\u00df");
        data = data.replaceAll("&#x1e9e;", "\u00df");
        data = data.replace("\u00b4", "'");
        data = data.replaceAll("\t", " ");
        data = data.replaceAll("\r\n", " ");
        data = data.replaceAll("\n", " ");
        data = StringUtils.decodeHexEncodingInString(data);
        data = StringUtils.removeTypographischeZeichen(data);
        if (!SqlStringUtils.getEncoding().contentEquals("UTF-8")) {
            data = StringUtils.removeAllButUmlauts(data);
            data = data.replaceAll("\u00bc", "1/4");
            data = data.replaceAll("\u00bd", "1/2");
            data = data.replaceAll("\u00be", "3/4");
            data = AbstractWebserviceClient.replaceInvalidChars(data);
        }
        data = data.replace('^', ' ');
        data = INVALID_XML_PATTERN.matcher(data).replaceAll("?");
        if (removeJest) {
            data = AbstractWebserviceClient.purge(data, "EX_JEST");
        }
        return data;
    }

    private static String replaceInvalidChars(String input) {
        StringBuilder result = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (AbstractWebserviceClient.isValidISO88591Char(c)) {
                result.append(c);
                continue;
            }
            result.append('?');
        }
        return result.toString();
    }

    private static boolean isValidISO88591Char(char c) {
        return c >= '\u0000' && c <= '\u00ff';
    }

    static String purge(String data, String nodename) {
        data = data.replaceAll("<" + nodename + ">(?s).*</" + nodename + ">", "");
        data = data.replaceAll("<" + nodename + "></" + nodename + ">", "");
        data = data.replaceAll("<" + nodename + "/>", "");
        return data;
    }

    String adaptURL(String url) {
        String result = url;
        if (System.getProperty("WS_HOST") != null) {
            result = url.replaceAll("WS_HOST", System.getProperty("WS_HOST"));
        }
        return result;
    }

    protected void addAuthentification(SOAPMessage sr) {
        if (this.auth != null) {
            sr.getMimeHeaders().addHeader("Authorization", "Basic " + this.auth);
        }
    }

    protected StringBuffer readFile(File f) throws IOException {
        String line;
        FileReader fr = new FileReader(f);
        BufferedReader bfr = new BufferedReader(fr);
        StringBuffer result = new StringBuffer();
        while ((line = bfr.readLine()) != null) {
            result.append(line + "\n");
        }
        bfr.close();
        fr.close();
        return result;
    }

    protected boolean isReplyOk(File f) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(f);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        boolean checkReturn = false;
        String result = "";
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    if (!parser.getLocalName().equals("RETURN")) break;
                    checkReturn = true;
                    break;
                }
                case 4: {
                    if (!checkReturn || parser.isWhiteSpace()) break;
                    result = parser.getText();
                    checkReturn = false;
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
        return result.equals("I");
    }

    protected void initLogging() throws SecurityException, IOException {
        FileHandler handler = new FileHandler("WebserviceClient.log", 102400000, 1, true);
        handler.setFormatter(new SimpleFormatter(){

            @Override
            public String format(LogRecord l) {
                String result = DateUtils.getTodayString() + " " + DateUtils.getNowString() + ":" + l.getMessage() + "\n";
                return result;
            }

            @Override
            public String formatMessage(LogRecord l) {
                return this.format(l);
            }
        });
        Logger.getLogger("wc").addHandler(handler);
        logger.setLevel(Level.FINEST);
    }
}

