/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Dimension;
import de.superx.bianalysis.models.DimensionAttribute;
import java.util.List;
import java.util.StringJoiner;

public class Filter {
    public Identifier dimensionAttributeId;
    public List<String> filterValues;
    public String columnname;
    public String tablename;
    public String joincolumn;
    public String dimensionTableAlias;

    public Filter() {
    }

    public Filter(List<String> values, Identifier dimAttrId) {
        this.filterValues = values;
        this.dimensionAttributeId = dimAttrId;
    }

    public Filter(Filter filter) {
        this.dimensionAttributeId = filter.dimensionAttributeId;
        this.filterValues = filter.filterValues;
        this.columnname = filter.columnname;
        this.tablename = filter.tablename;
        this.joincolumn = filter.joincolumn;
        this.dimensionTableAlias = filter.dimensionTableAlias;
    }

    public void setDimensionAttribute(DimensionAttribute attr) {
        this.columnname = attr.getColumnname();
    }

    public void setDimension(Dimension dim) {
        this.tablename = dim.getTablename();
        this.joincolumn = dim.getJoincolumn();
        this.dimensionTableAlias = dim.getAlias() != null ? dim.getAlias() : this.joincolumn.replaceFirst("_(id|lid)$", "");
    }

    public DimensionAttribute getDimAttribute(ReportMetadata reportMetadata) {
        return reportMetadata.getDimAttrById(this.dimensionAttributeId);
    }

    public String toString() {
        return String.valueOf(this.dimensionAttributeId);
    }

    public static Filter findFilterById(List<Filter> filters, Identifier id) {
        return filters.stream().filter(f -> f.dimensionAttributeId.equals(id)).findFirst().orElse(null);
    }

    @JsonIgnore
    public String getValuesAsString() {
        if (this.filterValues == null || this.filterValues.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)", ", this.filterValues);
    }

    @JsonIgnore
    public String getValues() {
        if (this.filterValues == null || this.filterValues.isEmpty()) {
            return null;
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (String value : this.filterValues) {
            joiner.add("'" + value + "'");
        }
        return joiner.toString();
    }
}

