/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata.models.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.superx.bianalysis.metadata.UpsertStringBuilder;
import de.superx.bianalysis.metadata.models.json.MetaDimensionAttribute;
import de.superx.bianalysis.metadata.models.json.MetaObject;
import java.util.List;

@JsonPropertyOrder(value={"id", "default_release"})
public class MetaMeasureFilter
extends MetaObject {
    private String dimensionRef;
    private String factColumnRef;
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> included;
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> excluded;
    @JsonIgnore
    private MetaDimensionAttribute attribute;

    public MetaMeasureFilter() {
        super("measure_filter");
    }

    @Override
    public UpsertStringBuilder getUpsertBuilder() {
        UpsertStringBuilder builder = super.getUpsert();
        builder.withStringCol("included_values", MetaMeasureFilter.concatValues(this.included));
        builder.withStringCol("excluded_values", MetaMeasureFilter.concatValues(this.excluded));
        if (this.dimensionRef != null) {
            builder.withIdCol("dimension_attribute_id", this.attribute.id);
        } else if (this.factColumnRef != null) {
            builder.withStringCol("fact_column_filter", this.factColumnRef);
        }
        return builder;
    }

    private static String concatValues(List<String> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object result = "";
        int size = values.size();
        for (int i = 0; i < size - 1; ++i) {
            result = (String)result + "''" + values.get(i) + "'', ";
        }
        result = (String)result + "''" + values.get(size - 1) + "''";
        return result;
    }

    public String getDimensionRef() {
        return this.dimensionRef;
    }

    public void setDimensionRef(String dimensionRef) {
        this.dimensionRef = dimensionRef;
    }

    public List<String> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<String> included) {
        this.included = included;
    }

    public List<String> getExcluded() {
        return this.excluded;
    }

    public void setExcluded(List<String> excluded) {
        this.excluded = excluded;
    }

    public MetaDimensionAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(MetaDimensionAttribute attribute) {
        this.attribute = attribute;
    }

    @Override
    @JsonIgnore
    public String getDocIdentifier() {
        return "";
    }

    public String getFactColumnRef() {
        return this.factColumnRef;
    }

    public void setFactColumnRef(String factColumnRef) {
        this.factColumnRef = factColumnRef;
    }
}

