/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import de.superx.bianalysis.FaultyMetadataException;
import de.superx.bianalysis.StoredReport;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.metadata.MetaImport;
import de.superx.bianalysis.metadata.MetaImportConformedDimensions;
import de.superx.bianalysis.metadata.MetaJson;
import de.superx.bianalysis.metadata.UpsertStringBuilder;
import de.superx.bianalysis.metadata.models.json.MetaDimension;
import de.superx.bianalysis.metadata.models.json.MetaFact;
import de.superx.bianalysis.metadata.models.json.MetaObject;
import de.superx.bianalysis.metadata.models.yml.MetaYml;
import de.superx.bianalysis.metadata.models.yml.MetaYmlModel;
import de.superx.bianalysis.metadata.models.yml.MetaYmlModelColumns;
import de.superx.util.PathAndFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;

public final class MetadataImporter {
    private static final String METAIMPORT_FILE_SUFFIX = "_metaimport.json";
    protected static final String CONFORMED_DIMENSIONS_FILE_SUFFIX = "conformed_dimensions_metaimport.json";
    private List<MetaJson> metaImports = new ArrayList<MetaJson>();
    public List<String> errorMessages = new ArrayList<String>();
    public static final String TRUNCATE_METADATA_SQL = "DELETE FROM metadata.facttable WHERE default_release != 'custom' or default_release is null; DELETE FROM metadata.measure WHERE default_release != 'custom' or default_release is null; DELETE FROM metadata.measure_filter WHERE default_release != 'custom' or default_release is null; DELETE FROM metadata.dimension WHERE default_release != 'custom' or default_release is null; DELETE FROM metadata.dimension_attribute WHERE default_release != 'custom' or default_release is null; ";
    private static Logger log = Logger.getLogger(MetadataImporter.class);
    private boolean shouldReadYMLDoc = true;
    private String ymlDir = "";

    public MetadataImporter() {
    }

    public MetadataImporter(String ymlDir) {
        this.ymlDir = ymlDir;
    }

    public void deserializeMetadataFromStrings(String ... values) {
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
        ArrayList<MetaImportConformedDimensions> conformedDimension = new ArrayList<MetaImportConformedDimensions>();
        for (String value : values) {
            MetaJson meta = null;
            try {
                if (value.contains("conformed_dimensions")) {
                    meta = (MetaJson)mapper.readValue(value, MetaImportConformedDimensions.class);
                    conformedDimension.add((MetaImportConformedDimensions)meta);
                } else {
                    meta = (MetaJson)mapper.readValue(value, MetaImport.class);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (meta == null) continue;
            meta.setFile(null);
            this.metaImports.add(meta);
        }
        ArrayList<MetaDimension> confDims = new ArrayList<MetaDimension>();
        for (MetaImportConformedDimensions conf : conformedDimension) {
            confDims.addAll(conf.conformedDimensions);
        }
        for (MetaJson metaJson : this.metaImports) {
            if (conformedDimension.size() > 0 && metaJson instanceof MetaImport) {
                ((MetaImport)metaJson).setConformedDimensions(confDims);
            }
            try {
                metaJson.init();
                metaJson.setNamespaceToMetaObjects();
            }
            catch (Exception e) {
                this.errorMessages.add(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        if (this.shouldReadYMLDoc) {
            this.addDescriptionsFromYMLFiles();
        }
    }

    public void deserializeMetadataFromJsonFiles(String ... paths) {
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
        ArrayList<MetaImportConformedDimensions> conformedDimension = new ArrayList<MetaImportConformedDimensions>();
        for (String path : paths) {
            List<File> metaFiles = MetadataImporter.readMetaImportFiles(path);
            for (File file : metaFiles) {
                MetaJson meta = null;
                try {
                    if (file.getName().endsWith(CONFORMED_DIMENSIONS_FILE_SUFFIX)) {
                        meta = (MetaJson)mapper.readValue(file, MetaImportConformedDimensions.class);
                        conformedDimension.add((MetaImportConformedDimensions)meta);
                    } else {
                        meta = (MetaJson)mapper.readValue(file, MetaImport.class);
                    }
                }
                catch (JsonMappingException e) {
                    String message = "Could not deserialize metadata from file: " + file.getName() + "\n";
                    message = message + e.getMessage();
                    this.errorMessages.add(message);
                }
                catch (Exception e) {
                    this.errorMessages.add(ExceptionUtils.getFullStackTrace((Throwable)e));
                }
                if (meta == null) continue;
                log.info((Object)("Read metadata from file: " + file.getName()));
                meta.setFile(file);
                this.metaImports.add(meta);
            }
        }
        ArrayList<MetaDimension> confDims = new ArrayList<MetaDimension>();
        for (MetaImportConformedDimensions conf : conformedDimension) {
            confDims.addAll(conf.conformedDimensions);
        }
        for (MetaJson metaJson : this.metaImports) {
            if (conformedDimension.size() > 0 && metaJson instanceof MetaImport) {
                ((MetaImport)metaJson).setConformedDimensions(confDims);
            }
            try {
                metaJson.init();
                metaJson.setNamespaceToMetaObjects();
            }
            catch (Exception e) {
                this.errorMessages.add(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        if (this.shouldReadYMLDoc) {
            this.addDescriptionsFromYMLFiles();
        }
    }

    public List<String> readStoredReports() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String dir = PathAndFileUtils.getStoredReportDir("hisinone");
            File[] files = new File(dir).listFiles();
            if (files == null) {
                return result;
            }
            for (File file : files) {
                try {
                    ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
                    StoredReport report = (StoredReport)mapper.readValue(file, StoredReport.class);
                    UpsertStringBuilder builder = new UpsertStringBuilder().forTable("metadata", "rw_report_definitions").withIntCol("id", report.id).withStringCol("name", report.name).withStringCol("definition", report.definition).withIntCol("show_total_column", report.showTotalColumn);
                    result.add(builder.build(true));
                }
                catch (JsonMappingException e) {
                    String message = "Could not deserialize stored report from file: " + file.getName() + "\n";
                    message = message + e.getMessage();
                    this.errorMessages.add(message);
                }
            }
            if (result.size() != 0) {
                result.add("SELECT setval(pg_get_serial_sequence('metadata.rw_report_definitions', 'id'),(SELECT max(id) FROM metadata.rw_report_definitions ));");
            }
        }
        catch (Exception e) {
            this.errorMessages.add("Unable to read stored report:\n");
            this.errorMessages.add(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return result;
    }

    public void addDescriptionsFromYMLFiles() {
        String dir = this.ymlDir;
        if (this.ymlDir == null || this.ymlDir.isBlank()) {
            dir = PathAndFileUtils.getDbtModelsDirectory("hisinone");
        }
        HashMap<String, String> map = this.getMarkdownDefinitions(dir);
        this.addYMLDescriptionsToMetaObjects(dir, map);
    }

    public void addYMLDescriptionsToMetaObjects(String ymlDir, HashMap<String, String> mdDefs) {
        log.info((Object)"Adding descriptions from yml files");
        HashMap<String, String> descriptions = this.createDescriptions(new File(ymlDir), mdDefs);
        List<MetaObject> objs = this.getAllMetaObjectsWithConformed();
        for (MetaObject metaObj : objs) {
            String docIdentifier = null;
            try {
                docIdentifier = metaObj.getDocIdentifier();
            }
            catch (FaultyMetadataException e) {
                this.errorMessages.add(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
            if (docIdentifier == null || docIdentifier.isBlank() || metaObj.getDescription() != null && !metaObj.getDescription().isBlank()) continue;
            String desc = descriptions.get(docIdentifier);
            if (desc == null) {
                log.warn((Object)("Missing yml description for: " + docIdentifier));
                continue;
            }
            metaObj.setDescription(desc);
            if (!desc.isBlank()) continue;
            log.warn((Object)("Empty yml description for MetaObject: " + docIdentifier));
        }
    }

    private HashMap<String, String> createDescriptions(File startDir, HashMap<String, String> mdDefs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (MetaYml yml : this.getDescriptionYMLs(startDir)) {
            for (MetaYmlModel model : yml.getModels()) {
                String modelName = model.getName();
                String modelDesc = model.getDescription();
                result.put(modelName, MetadataImporter.getDescription(modelDesc, mdDefs));
                for (MetaYmlModelColumns column : model.getColumns()) {
                    String colName = column.getName();
                    String colDesc = column.getDescription();
                    result.put(modelName + "." + colName, MetadataImporter.getDescription(colDesc, mdDefs));
                }
            }
        }
        return result;
    }

    private static String getDescription(String desc, HashMap<String, String> mdDefs) {
        if (desc == null) {
            return "";
        }
        if (desc.startsWith("{{")) {
            String[] parts = desc.split("\"");
            String docRef = parts[1];
            return mdDefs.get(docRef);
        }
        return desc;
    }

    private List<MetaYml> getDescriptionYMLs(File startDir) {
        ArrayList<MetaYml> ymls = new ArrayList<MetaYml>();
        List<String> files = MetadataImporter.getFiles(startDir, "", ".yml");
        ObjectMapper mapperYml = new ObjectMapper((JsonFactory)new YAMLFactory());
        for (String f : files) {
            File file = new File(String.valueOf(startDir) + File.separator + f);
            MetaYml doc = null;
            try {
                doc = (MetaYml)mapperYml.readValue(file, MetaYml.class);
            }
            catch (Exception e) {
                String message = "Could not read documentation from file: " + file.getName() + "\n";
                this.errorMessages.add(message);
                this.errorMessages.add(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
            if (doc == null) continue;
            log.info((Object)("Read documentation from file: " + file.getName()));
            ymls.add(doc);
        }
        return ymls;
    }

    private static List<File> readMetaImportFiles(String path) {
        File metaimportPath = new File(PathAndFileUtils.getDbtJsonPath(path));
        final ArrayList<File> metaimportFiles = new ArrayList<File>();
        if (metaimportPath.isDirectory()) {
            metaimportPath.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.endsWith(MetadataImporter.METAIMPORT_FILE_SUFFIX)) {
                        File file = new File(dir.getAbsolutePath() + File.separator + name);
                        metaimportFiles.add(file);
                        return true;
                    }
                    return false;
                }
            });
        } else {
            metaimportFiles.add(metaimportPath);
        }
        return metaimportFiles;
    }

    private static List<String> getFiles(File startDir, String subDir, String extension) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (File file : startDir.listFiles()) {
            String filename;
            String name = file.getName();
            if (file.isDirectory()) {
                filtered.addAll(MetadataImporter.getFiles(file, subDir + File.separator + name, extension));
            }
            if (!(filename = name.strip().toLowerCase()).endsWith(extension)) continue;
            filtered.add(subDir + File.separator + name);
        }
        return filtered;
    }

    public List<String> getAllUpsertStrings(boolean hasOnConflictConstruct) {
        ArrayList<String> upsertStmts = new ArrayList<String>();
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        for (MetaJson meta : this.metaImports) {
            for (MetaObject obj : meta.getMetaObjects()) {
                String message;
                Identifier id = obj.getId();
                if (id == null) {
                    message = String.format("Missing ID for Element '%s' in file: %s.", obj.getCaption(), meta.getFile().getAbsolutePath());
                    this.errorMessages.add(message);
                    continue;
                }
                if (ids.contains(id)) {
                    message = String.format("Duplicate ID '%s'. Ignoring Element '%s'.", obj.getCaption(), obj.getId().composedId);
                    this.errorMessages.add(message);
                    continue;
                }
                ids.add(obj.getId());
                String stmt = obj.getUpsertBuilder().build(hasOnConflictConstruct);
                upsertStmts.add(stmt);
            }
        }
        return upsertStmts;
    }

    public void updateMetadataForH2Database(DataSource dataSource) throws Exception {
        String metaFilesDir = String.join((CharSequence)File.separator, "test", "resources", "db", "fixtures", "reportwizard", "metadata");
        this.deserializeMetadataFromJsonFiles(metaFilesDir);
        JdbcTemplate jt = new JdbcTemplate(dataSource);
        String upserts = String.join((CharSequence)"\n", this.getAllUpsertStrings(false).toString());
        jt.execute(upserts);
    }

    /*
     * Exception decompiling
     */
    public void updateMetadataSchema(String project, DataSource dataSource) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeYmlToFile(MetaYml yml, File file) {
        YAMLFactory yf = new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yf);
        DefaultIndenter indenter = new DefaultIndenter("  ", DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        try {
            mapper.writer((PrettyPrinter)printer).writeValue(file, (Object)yml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String writeYmlToString(MetaYml yml) {
        YAMLFactory yf = new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yf);
        DefaultIndenter indenter = new DefaultIndenter("  ", DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        try {
            return mapper.writer((PrettyPrinter)printer).writeValueAsString((Object)yml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPrintableErrorMessages() {
        Object output = "";
        if (!this.errorMessages.isEmpty()) {
            output = (String)output + "The following errors occured:\n";
            for (String message : this.errorMessages) {
                output = (String)output + message + "\n";
            }
        }
        return output;
    }

    public HashMap<String, String> getMarkdownDefinitions(String ymlDir) {
        List<String> files = MetadataImporter.getFiles(new File(ymlDir), "", ".md");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String file : files) {
            try (BufferedReader br = new BufferedReader(new FileReader(ymlDir + File.separator + file));){
                String line;
                String key = null;
                boolean readHeading = false;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("{% docs ")) {
                        int startIndex = line.indexOf("docs");
                        if (startIndex == -1) {
                            throw new RuntimeException("docs not found");
                        }
                        int endIndex = line.indexOf(37, startIndex += "docs".length());
                        if (endIndex == -1) {
                            throw new RuntimeException("No % found after docs");
                        }
                        key = line.substring(startIndex, endIndex).trim();
                        map.put(key, "");
                        continue;
                    }
                    if (key != null && line.startsWith("# ")) {
                        readHeading = true;
                        continue;
                    }
                    if (!readHeading || line.isBlank()) continue;
                    map.put(key, line);
                    key = null;
                    readHeading = false;
                }
            }
            catch (Exception e) {
                String message = "ERROR getting markdown definitions from file: " + file + "\n";
                this.errorMessages.add(message);
                this.errorMessages.add(ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        return map;
    }

    public Optional<MetaImport> getMetaImport(String fileName) {
        return this.metaImports.stream().filter(json -> json instanceof MetaImport && json.file.getName().equals(fileName)).map(json -> (MetaImport)json).findFirst();
    }

    public Optional<MetaJson> getMetaJson(String fileName) {
        return this.metaImports.stream().filter(json -> json.file.getName().equals(fileName)).findFirst();
    }

    public List<MetaImport> getMetaImports() {
        return this.metaImports.stream().filter(json -> json instanceof MetaImport).map(json -> (MetaImport)json).collect(Collectors.toList());
    }

    public List<MetaImportConformedDimensions> getMetaImportsConformed() {
        return this.metaImports.stream().filter(json -> json instanceof MetaImportConformedDimensions).map(json -> (MetaImportConformedDimensions)json).collect(Collectors.toList());
    }

    public List<MetaJson> getMetaJsons() {
        return this.metaImports.stream().collect(Collectors.toList());
    }

    public List<MetaObject> getAllMetaObjects() {
        return this.metaImports.stream().filter(json -> json instanceof MetaImport).map(meta -> ((MetaImport)meta).getMetaObjects()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<MetaObject> getAllMetaObjectsWithConformed() {
        return this.metaImports.stream().map(meta -> meta.getMetaObjects()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<MetaFact> getAllFactTables() {
        return this.metaImports.stream().filter(json -> json instanceof MetaImport).map(meta -> ((MetaImport)meta).facts).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void setShouldReadYMLDoc(boolean shouldReadYMLDoc) {
        this.shouldReadYMLDoc = shouldReadYMLDoc;
    }
}

