/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis;

import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.Measure;

public class ColumnElement {
    public String caption;
    public String header;
    public String dimensionAttributeFilter;
    public Measure measure;
    public int columnNumber;

    public ColumnElement(String caption, String dimensionAttributeFilter) {
        this.caption = caption;
        this.dimensionAttributeFilter = dimensionAttributeFilter;
    }

    public ColumnElement(String caption, String dimensionAttributeFilter, Measure measure, int col) {
        this.caption = caption;
        this.dimensionAttributeFilter = dimensionAttributeFilter;
        this.measure = measure;
        this.columnNumber = col;
    }

    public ColumnElement(Measure measure, int index) {
        this.caption = "Kennzahl|" + measure.getId().composedId;
        this.header = "Kennzahl|" + measure.getCaption();
        this.measure = measure;
        this.columnNumber = index;
    }

    public ColumnElement(ColumnElement currentColumnElement) {
        this.caption = currentColumnElement.caption;
        this.dimensionAttributeFilter = currentColumnElement.dimensionAttributeFilter;
        this.measure = currentColumnElement.measure;
    }

    public static String buildField(DimensionAttribute attr, String value) {
        String dimId;
        String attrId = attr.getAttrConformedId();
        if (attrId == null) {
            attrId = attr.getStringId();
        }
        if ((dimId = attr.getDimConformedId()) == null) {
            dimId = attr.getDimId();
        }
        return dimId + ": " + attrId + "|" + value;
    }

    public static String buildHeader(DimensionAttribute attr, String value) {
        return attr.getCaption() + ": " + attr.getCaption() + "|" + value;
    }

    public static String buildFilter(DimensionAttribute attr, String value) {
        return attr.getDimensionTableAlias() + "." + attr.getColumnname() + " = '" + value + "'";
    }

    public void setHeader(String finalHeader) {
        this.header = finalHeader;
    }
}

