/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.widgets;

import de.memtext.widgets.TitlePanel;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class MBFrame
extends JFrame {
    private boolean isHardExitWanted = true;
    private TitlePanel titlePanel;

    public MBFrame() throws HeadlessException {
        this.init();
    }

    public MBFrame(GraphicsConfiguration arg0) {
        super(arg0);
        this.init();
    }

    public MBFrame(String arg0) throws HeadlessException {
        super(arg0);
        this.init();
    }

    public MBFrame(String arg0, GraphicsConfiguration arg1) {
        super(arg0, arg1);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                MBFrame.this.exit();
            }
        });
    }

    protected final void exit() {
        if (this.isExitOk()) {
            try {
                this.doBeforeExit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.dispose();
            if (this.isHardExitWanted) {
                System.exit(0);
            }
        }
    }

    protected boolean isExitOk() {
        return true;
    }

    protected void doBeforeExit() throws SQLException {
    }

    public void setCenter(JComponent comp) {
        this.getContentPane().add((Component)comp, "Center");
    }

    public void setNorth(JComponent comp) {
        this.getContentPane().add((Component)comp, "North");
    }

    public void setSouth(JComponent comp) {
        this.getContentPane().add((Component)comp, "South");
    }

    public void setEast(JComponent comp) {
        this.getContentPane().add((Component)comp, "East");
    }

    public void setWest(JComponent comp) {
        this.getContentPane().add((Component)comp, "West");
    }

    protected void setToolBar(JToolBar toolbar) {
        this.getContentPane().add((Component)toolbar, "North");
    }

    public boolean isHardExitWanted() {
        return this.isHardExitWanted;
    }

    public void setSystemExitOnClose(boolean isHardExitWanted) {
        this.isHardExitWanted = isHardExitWanted;
    }

    public void showTitlePanel(String txt) {
        if (this.titlePanel == null) {
            this.titlePanel = new TitlePanel(txt);
            this.setNorth(this.titlePanel);
        } else {
            this.titlePanel.setTitleText(txt);
        }
    }
}

