/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.FilenamesFilter;
import de.memtext.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    private FileUtils() {
    }

    public static int getHowOld(File f) {
        long now = new Date().getTime();
        return (int)((now - f.lastModified()) / 60000L);
    }

    public static String getFileNameWithoutSuffix(String filename) {
        int index = filename.indexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException(filename + " doesn't contain .");
        }
        filename = filename.substring(0, index);
        return filename;
    }

    public static String addToEndOfFileName(String filename, String suffix) {
        int index = ((String)filename).indexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException((String)filename + " doesn't contain .");
        }
        filename = ((String)filename).substring(0, index) + suffix + ((String)filename).substring(index, ((String)filename).length());
        return filename;
    }

    public static File[] getFileList(File dir, String beginning, String endings) {
        FilenamesFilter filt = new FilenamesFilter(null, endings, beginning);
        filt.setAllDirsAccepted(false);
        return dir.listFiles(filt);
    }

    public static void copyFile(String source, String target) throws IOException {
        FileUtils.copyFile(new File(source), new File(target));
    }

    public static void copyFile(File source, File target) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            is = new FileInputStream(source);
            os = new FileOutputStream(target);
            in = new BufferedInputStream(is);
            out = new BufferedOutputStream(os);
            int buffer_size = 32768;
            byte[] buffer = new byte[buffer_size];
            int len = in.read(buffer, 0, buffer_size);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer, 0, buffer_size);
            }
            in.close();
            is.close();
            out.close();
            os.close();
        }
        catch (FileNotFoundException fe) {
            throw new FileNotFoundException("Die Datei " + String.valueOf(source) + " konnte nicht gefunden werden!");
        }
        catch (IOException e) {
            throw new IOException("Couldn't copy file " + e.toString());
        }
    }

    public static void createZipFile(String pathToZipUp, String pathToSaveTo) {
        FileUtils.createZipFile(pathToZipUp, "", pathToSaveTo);
    }

    public static void createZipFile(String pathToZipUp, String relPath, String pathToSaveTo) {
        try {
            FileOutputStream fos = new FileOutputStream(pathToSaveTo);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setMethod(8);
            if (!((String)relPath).equals("") && ((String)pathToZipUp).lastIndexOf("\\") + 1 != ((String)pathToZipUp).length()) {
                pathToZipUp = (String)pathToZipUp + "\\";
            }
            System.out.println((String)pathToZipUp + (String)relPath);
            File f = new File((String)pathToZipUp + (String)relPath);
            String[] files = f.list();
            if (((String)pathToZipUp).lastIndexOf("\\") + 1 != ((String)pathToZipUp).length()) {
                pathToZipUp = (String)pathToZipUp + "\\";
            }
            for (int y = 0; y < files.length; ++y) {
                File aFile;
                Object fullpath = pathToZipUp;
                if (!((String)relPath).equals("")) {
                    fullpath = (String)fullpath + (String)relPath + "\\";
                }
                if ((aFile = new File((String)(fullpath = (String)fullpath + files[y]))).isDirectory()) {
                    relPath = ((String)relPath).equals("") ? files[y] : (String)relPath + "\\" + files[y];
                    FileUtils.createZipFile((String)fullpath, (String)relPath, pathToSaveTo);
                    continue;
                }
                byte[] temp = new byte[files[y].length()];
                try {
                    int n;
                    FileInputStream fis = new FileInputStream(aFile);
                    CRC32 crc32 = new CRC32();
                    while ((n = fis.read(temp)) > -1) {
                        crc32.update(temp, 0, n);
                    }
                    fis.close();
                    String shortName = files[y].substring(((String)fullpath).length());
                    ZipEntry ze = new ZipEntry(shortName);
                    ze.setSize(aFile.length());
                    ze.setTime(aFile.lastModified());
                    ze.setCrc(crc32.getValue());
                    zos.putNextEntry(ze);
                    fis = new FileInputStream(aFile);
                    while ((n = fis.read(temp)) > -1) {
                        zos.write(temp, 0, n);
                    }
                    fis.close();
                    zos.closeEntry();
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            zos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] a) {
        List<File> l = FileUtils.getFileList("/home/superx/git/superx/superx/WEB-INF/conf/edustore/db/conf", "mo*.xsl,g*.xsl");
        Iterator<File> it = l.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    public static void download(URL url, File targetFile) throws IOException {
        URLConnection conn = url.openConnection();
        InputStream inStream = conn.getInputStream();
        FileOutputStream os = new FileOutputStream(targetFile);
        BufferedInputStream bufferedInStream = new BufferedInputStream(inStream);
        BufferedOutputStream bufferedOutStream = new BufferedOutputStream(os);
        int buffer_size = 32768;
        byte[] buffer = new byte[buffer_size];
        int len = inStream.read(buffer, 0, buffer_size);
        while (len != -1) {
            bufferedOutStream.write(buffer, 0, len);
            len = bufferedInStream.read(buffer, 0, buffer_size);
        }
        bufferedInStream.close();
        inStream.close();
        bufferedOutStream.close();
        os.close();
    }

    public static String removeProblemChars(String name) {
        String result = name.replace('\\', '-');
        result = result.replace('/', '-');
        result = StringUtils.replace(result, " - ", "-");
        result = StringUtils.replace(result, " -", "-");
        result = StringUtils.replace(result, "- ", "-");
        result = result.replace(' ', '_');
        result = result.replace('*', '_');
        result = result.replace('?', '_');
        result = result.replace(',', '_');
        return result;
    }

    public static List<File> getFileList(String dir, String regex) {
        LinkedList<File> resultFiles = new LinkedList<File>();
        File fDir = new File(dir);
        File[] files = fDir.listFiles();
        StringTokenizer st = new StringTokenizer(regex, ",");
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            pattern = pattern.replace(".", "\\.");
            pattern = pattern.replace("?", ".?").replace("*", ".*");
            for (File file : files) {
                if (!file.getName().matches(pattern)) continue;
                resultFiles.add(file);
            }
        }
        return resultFiles;
    }

    public static String getFileContentsWithEncoding(String filePath, String encoding) throws FileNotFoundException, IOException {
        File f = new File(filePath);
        String fileContents = "";
        if (encoding == null || encoding.trim().equals("")) {
            encoding = System.getProperty("file.encoding");
        }
        FileInputStream fis = new FileInputStream(f);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, encoding));
        StringWriter out = new StringWriter();
        String text = in.readLine();
        while (text != null) {
            out.write(text);
            out.write(System.getProperty("line.separator"));
            text = in.readLine();
        }
        if (out != null) {
            fileContents = out.toString();
        }
        return fileContents;
    }

    public static String tail(File myFile, int nLines) throws IOException {
        int numberOfLines = 0;
        StringBuilder builder = new StringBuilder();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(myFile, "r");){
            String string;
            try (ByteArrayOutputStream myByteArrayOutputStream = new ByteArrayOutputStream();){
                long fileLength = myFile.length() - 1L;
                randomAccessFile.seek(fileLength);
                for (long myPointer = fileLength; myPointer >= 0L; --myPointer) {
                    randomAccessFile.seek(myPointer);
                    byte b = (byte)randomAccessFile.read();
                    if (b == 10 && ++numberOfLines == nLines + 1) break;
                    myByteArrayOutputStream.write(b);
                    fileLength -= myPointer;
                }
                byte[] a = myByteArrayOutputStream.toByteArray();
                int start = 0;
                int mid = a.length / 2;
                int end = a.length - 1;
                while (start < mid) {
                    byte temp = a[end];
                    a[end] = a[start];
                    a[start] = temp;
                    ++start;
                    --end;
                }
                string = new String(a).trim();
            }
            return string;
        }
    }

    public static String getFileLastModifiedAsString(String filepath) {
        String lmf = "Unbekannt";
        File f = new File(filepath);
        if (f.exists()) {
            lmf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date(f.lastModified()));
        }
        return lmf;
    }
}

