/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.tree.admin.Field;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class EntryNode
extends DefaultMutableTreeNode
implements Transferable,
Serializable,
Cloneable {
    public static final DataFlavor ENTRY_FLAVOR = new DataFlavor(EntryNode.class, "ENTRY");
    static DataFlavor[] flavors = new DataFlavor[]{ENTRY_FLAVOR};
    private boolean debug = false;
    private Field keyfield;
    private Field parentfield;
    private String name;
    private String errorInfo;
    private final Map fields = new HashMap();

    public void setKeyfield(Field keyfield) {
        this.keyfield = keyfield;
    }

    public void setParentfield(Field parentfield) {
        this.parentfield = parentfield;
    }

    public void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public void setValue(String fieldname, Object value) {
        Field field = (Field)this.fields.get(fieldname);
        field.setValue(value);
    }

    public Object getValue(Object fieldname) {
        Field field = (Field)this.fields.get(fieldname);
        return field.getValueString();
    }

    public String getName() {
        String result = null;
        result = this.name == null ? "" : this.name;
        return result;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getKey() {
        return this.keyfield.getValue();
    }

    public void setKey(Object key) {
        this.keyfield.setValue(key);
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            EntryNode anEntryNode = (EntryNode)en.nextElement();
            anEntryNode.setParentKey(key);
        }
    }

    public Object getParentKey() {
        return this.parentfield.getValue();
    }

    public void setParentKey(Object parent) {
        this.parentfield.setValue(parent);
    }

    public void updateParentKey() {
        EntryNode parentNode = (EntryNode)this.getParent();
        this.setParentKey(parentNode.getKey());
    }

    public int getSpecialFieldCount() {
        return this.fields.size();
    }

    public Iterator fieldNameIterator() {
        Set fieldkeys = this.fields.keySet();
        return fieldkeys.iterator();
    }

    public Iterator fieldIterator() {
        Collection c = this.fields.values();
        return c.iterator();
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    @Override
    public String toString() {
        Object result = null;
        if (this.debug) {
            result = "Entry name:" + this.getName() + " key:" + String.valueOf(this.getKey()) + " parent:" + String.valueOf(this.getParentKey()) + " " + this.fields.size() + " fields:";
            Set fieldkeys = this.fields.keySet();
            for (String key : fieldkeys) {
                Field f = (Field)this.fields.get(key);
                result = (String)result + " " + key + " value:" + f.getValueString() + " ";
            }
        } else {
            result = this.getName();
        }
        return result;
    }

    public String getInsertCommand(String tablename) {
        StringBuffer header = new StringBuffer("insert into " + tablename + "(key,parent,name,");
        System.out.println(this.name);
        StringBuffer values = new StringBuffer(" values(");
        values.append(this.keyfield.getInsertCommandValue() + "," + this.parentfield.getInsertCommandValue() + ",'" + this.getName() + "',");
        Iterator it = this.fieldIterator();
        while (it.hasNext()) {
            Field f = (Field)it.next();
            header.append(f.getName() + ",");
            values.append(f.getInsertCommandValue() + ",");
        }
        header.deleteCharAt(header.length() - 1);
        header.append(") ");
        values.deleteCharAt(values.length() - 1);
        values.append(") ");
        return header.toString() + values.toString();
    }

    @Override
    public Object clone() {
        EntryNode result = null;
        try {
            result = new EntryNode();
            result.setKeyfield(new Field(this.keyfield.getName(), this.keyfield.getType()));
            result.setParentfield(new Field(this.parentfield.getName(), this.parentfield.getType()));
            result.setName(this.getName());
            Set fieldkeys = this.fields.keySet();
            for (String key : fieldkeys) {
                Field f = (Field)this.fields.get(key);
                result.addField((Field)f.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
        return result;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        return df.equals(ENTRY_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df.equals(ENTRY_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(df);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }
}

