/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.db.DBAccess;
import de.memtext.tree.admin.EntryNode;
import de.memtext.tree.admin.Field;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class AdminTreeModel
extends DefaultTreeModel {
    private String tablename;
    private StringBuffer protocol;
    private List entryNodes;
    private EntryNode prototypeEntry;
    private EntryNode root;
    private final String noMainKey = "Kein Haupteintrag mit parent=null gefunden!";
    private final String error1Txt = "Element hat f\u00e4lschlicherweise den eigenen Key als parent key";
    private DefaultMutableTreeNode errorNodes = new DefaultMutableTreeNode("Error nodes");
    private IllegalArgumentException noMainKeyEx = new IllegalArgumentException("Kein Haupteintrag mit parent=null gefunden!");
    private boolean isNoMainKeyAcceptable = true;

    public AdminTreeModel(String tablename) throws Exception {
        super(new DefaultMutableTreeNode("dummy"));
        this.setTable(tablename);
    }

    public void setTable(String tablename) throws Exception {
        this.tablename = tablename;
        this.protocol = new StringBuffer();
        this.root = new EntryNode();
        this.errorNodes.removeAllChildren();
        this.initPrototypeEntry();
        this.entryNodes = this.getEntryNodesFromDB();
        this.insertnodes(this.root, null);
        this.markRemainingNodesAsErrors();
        if (this.errorNodes.getChildCount() > 0) {
            this.root.add(this.errorNodes);
        }
        this.setRoot(this.root);
        this.reload();
    }

    private List getEntryNodesFromDB() throws SQLException, CloneNotSupportedException {
        LinkedList<EntryNode> entries = new LinkedList<EntryNode>();
        ResultSet rs = DBAccess.get("RecursiveTableAdmin").executeQuery("select * from " + this.tablename);
        while (rs.next()) {
            EntryNode anEntryNode = (EntryNode)this.prototypeEntry.clone();
            anEntryNode.setName(rs.getString("NAME"));
            Object key = rs.getObject("KEY");
            anEntryNode.setKey(key);
            Object parentKey = rs.getObject("PARENT");
            anEntryNode.setParentKey(parentKey);
            Iterator it = anEntryNode.fieldNameIterator();
            while (it.hasNext()) {
                String fieldname = (String)it.next();
                anEntryNode.setValue(fieldname, rs.getObject(fieldname.toUpperCase()));
            }
            if (key != null && parentKey != null && key.equals(parentKey)) {
                anEntryNode.setErrorInfo("Element hat f\u00e4lschlicherweise den eigenen Key als parent key");
                this.errorNodes.add(anEntryNode);
                this.protocol.append(anEntryNode.getName() + "(" + String.valueOf(anEntryNode.getKey()) + ") - Element hat f\u00e4lschlicherweise den eigenen Key als parent key");
                continue;
            }
            entries.add(anEntryNode);
        }
        rs.close();
        return entries;
    }

    public EntryNode getPrototypeEntry() {
        return this.prototypeEntry;
    }

    private void initPrototypeEntry() throws Exception {
        DatabaseMetaData metadata = DBAccess.get("RecursiveTableAdmin").getConn().getMetaData();
        ResultSet rs = metadata.getColumns(null, null, this.tablename, null);
        boolean containsKey = false;
        boolean containsParent = false;
        boolean containsName = false;
        this.prototypeEntry = new EntryNode();
        while (rs.next()) {
            String aFieldname = rs.getObject(4).toString();
            int aFieldType = rs.getInt(5);
            Field aField = new Field(aFieldname, aFieldType);
            if (aFieldname.equalsIgnoreCase("key")) {
                containsKey = true;
                this.prototypeEntry.setKeyfield(aField);
                continue;
            }
            if (aFieldname.equalsIgnoreCase("name")) {
                containsName = true;
                continue;
            }
            if (aFieldname.equalsIgnoreCase("parent")) {
                containsParent = true;
                this.prototypeEntry.setParentfield(aField);
                continue;
            }
            this.prototypeEntry.addField(aField);
        }
        if (!(containsKey && containsParent && containsName)) {
            throw new IllegalArgumentException("table doesn't contain key, parent or name");
        }
    }

    private List getNodesWithParentKey(Object checkparent) {
        LinkedList<EntryNode> result = new LinkedList<EntryNode>();
        for (EntryNode anEntryNode : this.entryNodes) {
            Object parentKey = anEntryNode.getParentKey();
            if (parentKey == null && checkparent == null) {
                result.add(anEntryNode);
            }
            if (parentKey == null || checkparent == null || !parentKey.equals(checkparent)) continue;
            result.add(anEntryNode);
        }
        return result;
    }

    private void insertnodes(EntryNode presentNode, Object parentKey) throws IllegalArgumentException {
        this.entryNodes.remove(presentNode);
        List childrensList = this.getNodesWithParentKey(parentKey);
        if (parentKey == null && childrensList.size() == 0) {
            if (this.isNoMainKeyAcceptable) {
                this.protocol.append("Kein Haupteintrag mit parent=null gefunden!");
            } else {
                throw this.noMainKeyEx;
            }
        }
        for (EntryNode newNode : childrensList) {
            presentNode.add(newNode);
            Object keyOfNewNode = newNode.getKey();
            if (keyOfNewNode != null && parentKey == null) {
                this.insertnodes(newNode, keyOfNewNode);
            }
            if (keyOfNewNode == null && parentKey == null) {
                newNode.setErrorInfo("Element hat f\u00e4lschlicherweise den eigenen Key als parent key");
                this.errorNodes.add(newNode);
            }
            if (keyOfNewNode == null || parentKey == null) continue;
            if (!parentKey.equals(keyOfNewNode)) {
                this.insertnodes(newNode, keyOfNewNode);
                continue;
            }
            newNode.setErrorInfo("Element hat f\u00e4lschlicherweise den eigenen Key als parent key");
            this.protocol.append(newNode.getName() + "(" + String.valueOf(newNode.getKey()) + ") - Element hat f\u00e4lschlicherweise den eigenen Key als parent key");
            this.errorNodes.add(newNode);
        }
    }

    private void markRemainingNodesAsErrors() {
        String txt = "Dieser Knoten passte nicht in die Struktur";
        EntryNode fehlernode2 = null;
        for (EntryNode fehlernode2 : this.entryNodes) {
            fehlernode2.setErrorInfo(txt);
            this.protocol.append(fehlernode2.getName() + " (key: " + String.valueOf(fehlernode2.getKey()) + ") - " + txt + "\n");
            this.errorNodes.add(fehlernode2);
        }
    }

    public String getTablename() {
        return this.tablename;
    }

    public String getProtocol() {
        this.protocol.append("\n");
        return this.protocol.toString();
    }
}

