/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree;

import de.memtext.tree.CheckBoxNodeDec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckBoxTreeDec
extends JScrollPane {
    private String setMethodName;
    private List acceptableClasses = new LinkedList();

    public CheckBoxTreeDec(JTree tree, String setMethodName) {
        throw new UnsupportedOperationException();
    }

    public CheckBoxTreeDec(JTree tree, String setMethodName, List acceptableClasses) {
        this.setMethodName = setMethodName;
        this.acceptableClasses = acceptableClasses;
    }

    private void addSubNodes(CheckBoxNodeDec aNode) {
        throw new UnsupportedOperationException();
    }

    public CheckBoxTreeDec(String title, CheckBoxNodeDec root) {
        this.init(root);
    }

    private void init(CheckBoxNodeDec root) {
        JTree tree = new JTree(root);
        tree.setCellRenderer(new CheckRenderer());
        tree.getSelectionModel().setSelectionMode(1);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        tree.addMouseListener(new NodeSelectionListener(tree));
        this.setViewportView(new JScrollPane(tree));
    }

    class CheckRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected JCheckBox check;
        protected TreeLabel label;

        public CheckRenderer() {
            this.setLayout(null);
            this.check = new JCheckBox();
            this.add(this.check);
            this.label = new TreeLabel();
            this.add(this.label);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            CheckBoxNodeDec dec = (CheckBoxNodeDec)value;
            this.check.setVisible(dec.isCheckBoxVisible());
            this.check.setSelected(((CheckBoxNodeDec)value).isSelected());
            this.label.setFont(tree.getFont());
            this.label.setText(stringValue);
            this.label.setSelected(isSelected);
            this.label.setFocus(hasFocus);
            if (leaf) {
                this.label.setIcon(UIManager.getIcon("Tree.leafIcon"));
            } else if (expanded) {
                this.label.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                this.label.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
        }

        @Override
        public void doLayout() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            int y_check = 0;
            int y_label = 0;
            if (d_check.height < d_label.height) {
                y_check = (d_label.height - d_check.height) / 2;
            } else {
                y_label = (d_check.height - d_label.height) / 2;
            }
            this.check.setLocation(0, y_check);
            this.check.setBounds(0, y_check, d_check.width, d_check.height);
            this.label.setLocation(d_check.width, y_label);
            this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height);
        }

        @Override
        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        class TreeLabel
        extends JLabel {
            boolean isSelected;
            boolean hasFocus;

            TreeLabel() {
            }

            @Override
            public void setBackground(Color color) {
                if (color instanceof ColorUIResource) {
                    color = null;
                }
                super.setBackground(color);
            }

            @Override
            public void paint(Graphics g) {
                String str = this.getText();
                if (str != null && 0 < str.length()) {
                    if (this.isSelected) {
                        g.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        g.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                    Dimension d = this.getPreferredSize();
                    int imageOffset = 0;
                    Icon currentI = this.getIcon();
                    if (currentI != null) {
                        imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                    }
                    g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                    if (this.hasFocus) {
                        g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                    }
                }
                super.paint(g);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension retDimension = super.getPreferredSize();
                if (retDimension != null) {
                    retDimension = new Dimension(retDimension.width + 3, retDimension.height);
                }
                return retDimension;
            }

            void setSelected(boolean isSelected) {
                this.isSelected = isSelected;
            }

            void setFocus(boolean hasFocus) {
                this.hasFocus = hasFocus;
            }
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = this.tree.getRowForLocation(x, y = e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path != null) {
                CheckBoxNodeDec node = (CheckBoxNodeDec)path.getLastPathComponent();
                boolean isSelected = !node.isSelected();
                node.setSelected(isSelected);
                if (node.getSelectionMode() == 4) {
                    if (isSelected) {
                        this.tree.expandPath(path);
                    } else {
                        this.tree.collapsePath(path);
                    }
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
                if (row == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }
}

