/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.factory;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.step.builder.FaultTolerantStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.factory.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.factory.SimpleStepFactoryBean;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.policy.MapRetryContextCache;
import org.springframework.retry.policy.RetryContextCache;

public class FaultTolerantStepFactoryBean<T, S>
extends SimpleStepFactoryBean<T, S> {
    private Map<Class<? extends Throwable>, Boolean> skippableExceptionClasses = new HashMap<Class<? extends Throwable>, Boolean>();
    private Collection<Class<? extends Throwable>> noRollbackExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses = new HashMap<Class<? extends Throwable>, Boolean>();
    private int cacheCapacity = 0;
    private int retryLimit = 0;
    private int skipLimit = 10;
    private SkipPolicy skipPolicy;
    private BackOffPolicy backOffPolicy;
    private RetryListener[] retryListeners;
    private RetryPolicy retryPolicy;
    private RetryContextCache retryContextCache;
    private KeyGenerator keyGenerator;
    private boolean processorTransactional = true;

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setRetryableExceptionClasses(Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryListeners(RetryListener ... retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkipPolicy(SkipPolicy skipPolicy) {
        this.skipPolicy = skipPolicy;
    }

    public void setSkippableExceptionClasses(Map<Class<? extends Throwable>, Boolean> exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setNoRollbackExceptionClasses(Collection<Class<? extends Throwable>> noRollbackExceptionClasses) {
        this.noRollbackExceptionClasses = noRollbackExceptionClasses;
    }

    public void setProcessorTransactional(boolean processorTransactional) {
        this.processorTransactional = processorTransactional;
    }

    @Override
    protected SimpleStepBuilder<T, S> createBuilder(String name) {
        return new FaultTolerantStepBuilder(new StepBuilder(name, this.jobRepository));
    }

    @Override
    protected void applyConfiguration(SimpleStepBuilder<T, S> builder) {
        FaultTolerantStepBuilder faultTolerantBuilder = (FaultTolerantStepBuilder)builder;
        if (this.retryContextCache == null && this.cacheCapacity > 0) {
            this.retryContextCache = new MapRetryContextCache(this.cacheCapacity);
        }
        faultTolerantBuilder.retryContextCache(this.retryContextCache);
        for (SkipListener skipListener : BatchListenerFactoryHelper.getListeners(this.getListeners(), SkipListener.class)) {
            faultTolerantBuilder.listener(skipListener);
        }
        if (this.retryListeners != null) {
            for (RetryListener listener : this.retryListeners) {
                faultTolerantBuilder.listener(listener);
            }
        }
        faultTolerantBuilder.skipPolicy(this.skipPolicy);
        faultTolerantBuilder.skipLimit(this.skipLimit);
        for (Class clazz : this.skippableExceptionClasses.keySet()) {
            if (this.skippableExceptionClasses.get(clazz).booleanValue()) {
                faultTolerantBuilder.skip(clazz);
                continue;
            }
            faultTolerantBuilder.noSkip(clazz);
        }
        if (!this.processorTransactional) {
            faultTolerantBuilder.processorNonTransactional();
        }
        faultTolerantBuilder.retryContextCache(this.retryContextCache);
        faultTolerantBuilder.keyGenerator(this.keyGenerator);
        faultTolerantBuilder.retryPolicy(this.retryPolicy);
        faultTolerantBuilder.retryLimit(this.retryLimit);
        faultTolerantBuilder.backOffPolicy(this.backOffPolicy);
        for (Class clazz : this.retryableExceptionClasses.keySet()) {
            if (this.retryableExceptionClasses.get(clazz).booleanValue()) {
                faultTolerantBuilder.retry(clazz);
                continue;
            }
            faultTolerantBuilder.noRetry(clazz);
        }
        for (Class clazz : this.noRollbackExceptionClasses) {
            faultTolerantBuilder.noRollback(clazz);
        }
        super.applyConfiguration(builder);
    }
}

