/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class MongoSequenceIncrementer
implements DataFieldMaxValueIncrementer {
    private final MongoOperations mongoTemplate;
    private final String sequenceName;

    public MongoSequenceIncrementer(MongoOperations mongoTemplate, String sequenceName) {
        this.mongoTemplate = mongoTemplate;
        this.sequenceName = sequenceName;
    }

    public long nextLongValue() throws DataAccessException {
        return (Long)this.mongoTemplate.execute("BATCH_SEQUENCES", collection -> ((Document)collection.findOneAndUpdate((Bson)new Document("_id", (Object)this.sequenceName), (Bson)new Document("$inc", (Object)new Document("count", (Object)1)), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER))).getLong((Object)"count"));
    }

    public int nextIntValue() throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    public String nextStringValue() throws DataAccessException {
        throw new UnsupportedOperationException();
    }
}

