/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Map;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.util.Assert;

public class DefaultExecutionContextSerializer
implements ExecutionContextSerializer {
    public void serialize(Map<String, Object> context, OutputStream out) throws IOException {
        Assert.notNull(context, (String)"context is required");
        Assert.notNull((Object)out, (String)"OutputStream is required");
        for (Object value : context.values()) {
            Assert.notNull((Object)value, (String)"A null value was found");
            if (value instanceof Serializable) continue;
            throw new IllegalArgumentException("Value: [" + String.valueOf(value) + "] must be serializable. Object of class: [" + value.getClass().getName() + "] must be an instance of " + String.valueOf(Serializable.class));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        OutputStream encodingStream = Base64.getEncoder().wrap(byteArrayOutputStream);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(encodingStream);){
            objectOutputStream.writeObject(context);
        }
        out.write(byteArrayOutputStream.toByteArray());
    }

    public Map<String, Object> deserialize(InputStream inputStream) throws IOException {
        InputStream decodingStream = Base64.getDecoder().wrap(inputStream);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(decodingStream);
            return (Map)objectInputStream.readObject();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to deserialize object", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to deserialize object type", ex);
        }
    }
}

