/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.observability;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.batch.core.observability.BatchJobContext;
import org.springframework.batch.core.observability.BatchStepContext;
import org.springframework.lang.Nullable;

public final class BatchMetrics {
    public static final String METRICS_PREFIX = "spring.batch.";
    public static final String STATUS_SUCCESS = "SUCCESS";
    public static final String STATUS_FAILURE = "FAILURE";

    private BatchMetrics() {
    }

    public static Timer createTimer(MeterRegistry meterRegistry, String name, String description, Tag ... tags) {
        return Timer.builder((String)(METRICS_PREFIX + name)).description(description).tags(Arrays.asList(tags)).register(meterRegistry);
    }

    public static Counter createCounter(MeterRegistry meterRegistry, String name, String description, Tag ... tags) {
        return Counter.builder((String)(METRICS_PREFIX + name)).description(description).tags(Arrays.asList(tags)).register(meterRegistry);
    }

    public static Observation createObservation(String name, BatchJobContext context, ObservationRegistry observationRegistry) {
        return Observation.createNotStarted((String)name, (Supplier)context, (ObservationRegistry)observationRegistry);
    }

    public static Observation createObservation(String name, BatchStepContext context, ObservationRegistry observationRegistry) {
        return Observation.createNotStarted((String)name, (Supplier)context, (ObservationRegistry)observationRegistry);
    }

    public static Timer.Sample createTimerSample(MeterRegistry meterRegistry) {
        return Timer.start((MeterRegistry)meterRegistry);
    }

    public static LongTaskTimer createLongTaskTimer(MeterRegistry meterRegistry, String name, String description, Tag ... tags) {
        return LongTaskTimer.builder((String)(METRICS_PREFIX + name)).description(description).tags(Arrays.asList(tags)).register(meterRegistry);
    }

    @Nullable
    public static Duration calculateDuration(@Nullable LocalDateTime startTime, @Nullable LocalDateTime endTime) {
        if (startTime == null || endTime == null) {
            return null;
        }
        return Duration.between(startTime, endTime);
    }

    public static String formatDuration(@Nullable Duration duration) {
        if (duration == null || duration.isZero() || duration.isNegative()) {
            return "";
        }
        StringBuilder formattedDuration = new StringBuilder();
        long hours = duration.toHours();
        long minutes = duration.toMinutes();
        long seconds = duration.getSeconds();
        long millis = duration.toMillis();
        if (hours != 0L) {
            formattedDuration.append(hours).append("h");
        }
        if (minutes != 0L) {
            formattedDuration.append(minutes - TimeUnit.HOURS.toMinutes(hours)).append("m");
        }
        if (seconds != 0L) {
            formattedDuration.append(seconds - TimeUnit.MINUTES.toSeconds(minutes)).append("s");
        }
        if (millis != 0L) {
            formattedDuration.append(millis - TimeUnit.SECONDS.toMillis(seconds)).append("ms");
        }
        return formattedDuration.toString();
    }
}

