/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow;

public class FlowExecutionStatus
implements Comparable<FlowExecutionStatus> {
    public static final FlowExecutionStatus COMPLETED = new FlowExecutionStatus(Status.COMPLETED.toString());
    public static final FlowExecutionStatus STOPPED = new FlowExecutionStatus(Status.STOPPED.toString());
    public static final FlowExecutionStatus FAILED = new FlowExecutionStatus(Status.FAILED.toString());
    public static final FlowExecutionStatus UNKNOWN = new FlowExecutionStatus(Status.UNKNOWN.toString());
    private final String name;

    public FlowExecutionStatus(String status) {
        this.name = status;
    }

    public boolean isStop() {
        return this.name.startsWith(STOPPED.getName());
    }

    public boolean isFail() {
        return this.name.startsWith(FAILED.getName());
    }

    public boolean isEnd() {
        return this.isStop() || this.isFail() || this.isComplete();
    }

    private boolean isComplete() {
        return this.name.startsWith(COMPLETED.getName());
    }

    @Override
    public int compareTo(FlowExecutionStatus other) {
        Status two;
        Status one = Status.match(this.name);
        int comparison = one.compareTo(two = Status.match(other.name));
        if (comparison == 0) {
            return this.name.compareTo(other.name);
        }
        return comparison;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FlowExecutionStatus)) {
            return false;
        }
        FlowExecutionStatus other = (FlowExecutionStatus)object;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    private static enum Status {
        COMPLETED,
        STOPPED,
        FAILED,
        UNKNOWN;


        static Status match(String value) {
            for (int i = 0; i < Status.values().length; ++i) {
                Status status = Status.values()[i];
                if (!value.startsWith(status.toString())) continue;
                return status;
            }
            return COMPLETED;
        }
    }
}

