/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.xml;

import de.werum.sis.xml.XmlUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class XmlWriter {
    private static final int DEFAULT_INDENT_WIDTH = 2;
    private static final String LINEBREAK = System.getProperty("line.separator");
    private Writer out;
    private boolean writeIndentation;
    private int indentationWidth;
    private int currentIndentation;
    private Stack<String> tagStack;

    public XmlWriter(Writer out, boolean writeIndentation) {
        this(out, writeIndentation, 2, 0);
    }

    public XmlWriter(Writer out, boolean writeIndentation, int indentationWidth, int indentationOffset) {
        this.out = out;
        this.writeIndentation = writeIndentation;
        this.indentationWidth = indentationWidth;
        this.currentIndentation = indentationOffset;
        this.tagStack = new Stack();
    }

    public void openXml(String encoding) throws IOException {
        this.out.write("<?xml version=\"1.0\" encoding=\"");
        this.out.write(encoding);
        this.out.write("\"?>");
    }

    public void openTag(String tagName) throws IOException {
        this.openTag(tagName, null);
    }

    public void openTag(String tagName, Map<String, String> attributes) throws IOException {
        this.writeIndentation(true);
        this.tagStack.push(tagName);
        ++this.currentIndentation;
        this.out.write("<");
        this.out.write(tagName);
        if (attributes != null && attributes.size() > 0) {
            Set<Map.Entry<String, String>> entries = attributes.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String attName = entry.getKey();
                String attValue = entry.getValue();
                this.writeAttribute(attName, attValue);
            }
        }
        this.out.write(">");
    }

    public void closeTag() throws IOException {
        this.closeTag(true);
    }

    public void closeTagInCurrentLine() throws IOException {
        this.closeTag(false);
    }

    public void closeTag(boolean newLine) throws IOException {
        if (!this.tagStack.isEmpty()) {
            --this.currentIndentation;
            if (newLine) {
                this.writeIndentation(newLine);
            }
            String tag = this.tagStack.pop();
            this.out.write("</");
            this.out.write(tag);
            this.out.write(">");
        }
    }

    public void writeCData(String data) throws IOException {
        this.out.write(this.cvrtXml(data));
    }

    public void writeXml(String xml) throws IOException {
        this.out.write(LINEBREAK);
        this.out.write(xml);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public int getCurrentIndentation() {
        return this.currentIndentation;
    }

    private void writeAttribute(String attName, String attValue) throws IOException {
        if (attName == null || attValue == null) {
            return;
        }
        this.out.write(" ");
        this.out.write(attName);
        this.out.write("=\"");
        this.out.write(this.cvrtXml(attValue));
        this.out.write("\"");
    }

    private void writeIndentation(boolean lineBreak) throws IOException {
        if (!this.writeIndentation) {
            return;
        }
        if (lineBreak) {
            this.out.write(LINEBREAK);
        }
        int indentChars = this.indentationWidth * this.currentIndentation;
        for (int i = 0; i < indentChars; ++i) {
            this.out.write(" ");
        }
    }

    private String cvrtXml(String text) {
        return XmlUtil.escapeString(text);
    }
}

