/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.xml;

public class XmlUtil {
    public static String escapeString(String inputString) {
        return XmlUtil.encode(inputString, "?");
    }

    public static String encode(String inputString, String invalidCharacterReplacement) throws IllegalArgumentException {
        return XmlUtil.encode(inputString, true, true, invalidCharacterReplacement);
    }

    public static String replaceInvalidChars(String inputString, String replacement) {
        return XmlUtil.encode(inputString, false, true, replacement == null ? "" : replacement);
    }

    private static String encode(String inputString, boolean escapeSpecialChars, boolean replaceInvalidChars, String invalidCharacterReplacement) throws IllegalArgumentException {
        String erg = inputString;
        if (inputString != null && inputString.length() > 0) {
            StringBuffer buffer = null;
            int len = inputString.length();
            for (int i = 0; i < len; ++i) {
                char check = inputString.charAt(i);
                String replacement = XmlUtil.getReplacement(check, escapeSpecialChars, replaceInvalidChars, invalidCharacterReplacement);
                if (replacement != null) {
                    if (buffer == null) {
                        buffer = new StringBuffer(inputString.length() + 10);
                        if (i > 0) {
                            for (int j = 0; j < i; ++j) {
                                buffer.append(inputString.charAt(j));
                            }
                        }
                    }
                    buffer.append(replacement);
                    continue;
                }
                if (buffer == null) continue;
                buffer.append(check);
            }
            if (buffer != null) {
                erg = buffer.toString();
            }
        }
        return erg;
    }

    private static String getReplacement(char character, boolean escapeSpecialChars, boolean replaceInvalidChars, String invalidCharacterReplacement) throws IllegalArgumentException {
        String replacememt = null;
        if (escapeSpecialChars) {
            if (character == '&') {
                replacememt = "&amp;";
            } else if (character == '<') {
                replacememt = "&lt;";
            } else if (character == '>') {
                replacememt = "&gt;";
            } else if (character == '\"') {
                replacememt = "&quot;";
            } else if (character == '\'') {
                replacememt = "&apos;";
            }
        }
        if (!(replacememt != null || !replaceInvalidChars || character >= ' ' && character <= '\ud7ff' || character >= '\ue000' && character <= '\ufffd' || character == '\t' || character == '\n' || character == '\r')) {
            if (invalidCharacterReplacement == null) {
                throw new IllegalArgumentException("Ung\u00fcltiges XML-Zeichen: 0x" + Integer.toHexString(character) + ".");
            }
            replacememt = invalidCharacterReplacement;
        }
        return replacememt;
    }

    private XmlUtil() {
    }
}

