/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.ui.swing.checkboxtree;

import de.werum.sis.ui.swing.checkboxtree.CheckObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class CheckBoxNodeRenderer
extends JPanel
implements TreeCellRenderer {
    private TreeCellRenderer objectRenderer = null;
    private JCheckBox checkBox = null;
    private boolean markIfHasUnselectedChilds = true;

    public CheckBoxNodeRenderer() {
        this((TreeCellRenderer)null);
    }

    public CheckBoxNodeRenderer(TreeCellRenderer objectRenderer) {
        this.setLayout(new BorderLayout());
        this.setBackground(UIManager.getColor("Tree.textBackground"));
        this.objectRenderer = objectRenderer == null ? new DefaultTreeCellRenderer() : objectRenderer;
        this.checkBox = new JCheckBox();
        this.checkBox.setBackground(UIManager.getColor("Tree.textBackground"));
        this.checkBox.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add((Component)this.checkBox, "West");
    }

    public void setMarkIfHasUnselectedChilds(boolean mark) {
        this.markIfHasUnselectedChilds = mark;
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        Object userObject = treeNode.getUserObject();
        CheckObject checkObject = null;
        if (userObject instanceof CheckObject) {
            checkObject = (CheckObject)userObject;
            userObject = checkObject.getSelectObject();
        }
        Component defRendComp = this.objectRenderer.getTreeCellRendererComponent(tree, userObject, selected, expanded, leaf, row, hasFocus);
        if (checkObject != null) {
            this.add(defRendComp, "Center");
            this.checkBox.setSelected(checkObject.isSelected());
            boolean hasUnselectedChild = false;
            if (this.markIfHasUnselectedChilds && treeNode.getChildCount() > 0) {
                hasUnselectedChild = this.hasUnselectedChildNode(treeNode);
            }
            if (hasUnselectedChild && checkObject.isSelected()) {
                this.checkBox.setEnabled(false);
            } else {
                this.checkBox.setEnabled(true);
            }
            return this;
        }
        this.remove(defRendComp);
        return defRendComp;
    }

    protected boolean hasUnselectedChildNode(DefaultMutableTreeNode parentNode) {
        boolean hasUnselectedChild = false;
        if (parentNode.getChildCount() > 0) {
            Enumeration<TreeNode> children = parentNode.children();
            while (children.hasMoreElements() && !hasUnselectedChild) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                Object userObj = child.getUserObject();
                if (userObj instanceof CheckObject) {
                    boolean bl = hasUnselectedChild = !((CheckObject)userObj).isSelected();
                }
                if (hasUnselectedChild) break;
                hasUnselectedChild = this.hasUnselectedChildNode(child);
            }
        }
        return hasUnselectedChild;
    }
}

