/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.trace;

import de.werum.sis.trace.ConsoleLogger;
import de.werum.sis.trace.DBLogger;
import de.werum.sis.trace.FileLogger;

public class LoggingManager {
    private static LoggingManager myManager = null;
    ConsoleLogger cl = null;
    DBLogger dl = null;
    FileLogger fl = null;

    private LoggingManager(boolean globalDebugOn, int globalErrorThreshold) {
        this.setErrorThresholdAll(globalErrorThreshold);
    }

    public void activateConsoleLogger(boolean on) {
        this.cl = ConsoleLogger.getInstance(on, 5);
    }

    public void activateDBLogger(String jdbcdriver, String url, boolean on, String user, String login, String password) {
        this.dl = DBLogger.getInstance(jdbcdriver, url, on, 5, user, login, password);
    }

    public void activateFileLogger(boolean on) {
        this.fl = FileLogger.getInstance(true, 5, "logfile.log");
    }

    public void activateAllLogger(boolean on, String jdbcdriver, String url, String user, String login, String password) {
        this.activateConsoleLogger(on);
        this.activateFileLogger(on);
    }

    public void setConsoleLoggerDebug(boolean on) {
        this.cl.setDebug(on);
    }

    public void setDBLoggerDebug(boolean on) {
        this.dl.setDebug(on);
    }

    public void setFileLoggerDebug(boolean on) {
        this.fl.setDebug(on);
    }

    public void setDebugAll(boolean on) {
        this.cl.setDebug(on);
        this.dl.setDebug(on);
        this.fl.setDebug(on);
    }

    public void setConsoleLoggerErrorThreshold(int threshold) {
        this.cl.setErrorThreshold(threshold);
    }

    public void setDBLoggerErrorThreshold(int threshold) {
        this.dl.setErrorThreshold(threshold);
    }

    public void setFileLoggerErrorThreshold(int threshold) {
        this.fl.setErrorThreshold(threshold);
    }

    public void setErrorThresholdAll(int threshold) {
        this.cl.setErrorThreshold(threshold);
        this.dl.setErrorThreshold(threshold);
        this.fl.setErrorThreshold(threshold);
    }

    public void print(String sMsg) {
        if (this.cl != null) {
            this.cl.print(sMsg);
        }
        if (this.fl != null) {
            this.fl.print(sMsg);
        }
    }

    public void print(int errorLevel, String sMsg) {
        if (this.cl != null) {
            this.cl.print(errorLevel, sMsg);
        }
        if (this.dl != null) {
            this.dl.print(errorLevel, sMsg);
        }
        if (this.fl != null) {
            this.fl.print(errorLevel, sMsg);
        }
    }

    public void enter(String klasse, String methode) {
        if (this.cl != null) {
            this.cl.enter(klasse, methode);
        }
        if (this.dl != null) {
            this.dl.enter(klasse, methode);
        }
        if (this.fl != null) {
            this.fl.enter(klasse, methode);
        }
    }

    public void enter(int errorLevel, String klasse, String methode) {
        if (this.cl != null) {
            this.cl.enter(errorLevel, klasse, methode);
        }
        if (this.dl != null) {
            this.dl.enter(errorLevel, klasse, methode);
        }
        if (this.fl != null) {
            this.fl.enter(errorLevel, klasse, methode);
        }
    }

    public void leave() {
        if (this.cl != null) {
            this.cl.leave();
        }
        if (this.dl != null) {
            this.cl.leave();
        }
        if (this.fl != null) {
            this.fl.leave();
        }
    }

    public void leave(int errorLevel) {
        if (this.cl != null) {
            this.cl.leave(errorLevel);
        }
        if (this.dl != null) {
            this.cl.leave(errorLevel);
        }
        if (this.fl != null) {
            this.fl.leave(errorLevel);
        }
    }

    public static LoggingManager getInstance(boolean globalDebugOn, int globalErrorThreshold) {
        if (myManager == null) {
            myManager = new LoggingManager(globalDebugOn, globalErrorThreshold);
        }
        return myManager;
    }
}

