/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.debug;

public class Logger {
    public static final int DEBUG = 40;
    public static final int INFO = 30;
    public static final int WARNING = 20;
    public static final int ERROR = 10;
    public static final int OFF = 0;
    private static int logLevel_ = 0;
    private static Logger instance_ = null;

    private Logger() {
    }

    public static Logger getInstance() {
        if (instance_ == null) {
            Logger.initialize(10);
        }
        return instance_;
    }

    public static void initialize(int logLevel) {
        instance_ = new Logger();
        instance_.setLogLevel(logLevel);
    }

    public void setLogLevel(int logLevel) {
        logLevel_ = logLevel;
        this.loggerInfo("logLevel set to " + this.getLogHeader(logLevel_));
    }

    public boolean isDebug() {
        return logLevel_ >= 40;
    }

    public boolean isInfo() {
        return logLevel_ >= 30;
    }

    public boolean isWarning() {
        return logLevel_ >= 20;
    }

    public boolean isError() {
        return logLevel_ >= 10;
    }

    public boolean isOn() {
        return logLevel_ >= 0;
    }

    public void log(int logLevel, Object klasse, String message) {
        if (logLevel_ == 0) {
            return;
        }
        if (logLevel_ >= logLevel) {
            StringBuffer logText = new StringBuffer();
            logText.append(this.getLogHeader(logLevel)).append(" ");
            logText.append(this.getLogSource(klasse));
            logText.append(" ").append(message);
            this.output(logText);
        }
    }

    public void log(int logLevel, Object klasse, Exception message) {
        if (logLevel_ == 0) {
            return;
        }
        if (logLevel_ >= logLevel) {
            StringBuffer logText = new StringBuffer();
            logText.append(this.getLogHeader(logLevel));
            logText.append(this.getLogSource(klasse));
            logText.append(" ").append(message.getMessage()).append("\n");
            logText.append(message.getStackTrace());
            this.output(logText);
        }
    }

    public void debug(Object klasse, String message) {
        this.log(40, klasse, message);
    }

    public void info(Object klasse, String message) {
        this.log(30, klasse, message);
    }

    public void warning(Object klasse, String message) {
        this.log(20, klasse, message);
    }

    public void error(Object klasse, Exception message) {
        this.log(10, klasse, message);
    }

    private String getLogHeader(int logLevel) {
        if (logLevel == 40) {
            return "-[ DEBUG ]- ";
        }
        if (logLevel == 30) {
            return "-[ INFO ]-  ";
        }
        if (logLevel == 20) {
            return "-[WARNING]- ";
        }
        return "-[ ERROR ]- ";
    }

    private String getLogSource(Object klasse) {
        if (klasse != null && !(klasse instanceof String)) {
            return klasse.getClass().getName();
        }
        return String.valueOf(klasse);
    }

    private void loggerInfo(String message) {
        StringBuffer logText = new StringBuffer();
        logText.append("-[LOGINFO]- ").append(message);
        this.output(logText);
    }

    private void output(StringBuffer fullmessage) {
        System.out.println(fullmessage.toString());
    }
}

