/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;

public class CsvReader {
    private BufferedReader reader;
    private char separator;
    private char quote;
    private char[] line;
    private int position;
    private boolean endOfLineReached;

    public CsvReader(Reader reader) {
        this(reader, ';', '\"');
    }

    public CsvReader(Reader reader, char separator, char quote) {
        this.reader = new BufferedReader(reader);
        this.separator = separator;
        this.quote = quote;
    }

    public boolean skipLine() throws IOException {
        return this.reader.readLine() == null;
    }

    public String[] readLine() throws IOException {
        String lineAsString = this.reader.readLine();
        if (lineAsString == null) {
            return null;
        }
        if (lineAsString.length() == 0) {
            return new String[0];
        }
        this.line = lineAsString.toCharArray();
        this.position = 0;
        this.endOfLineReached = false;
        LinkedList<String> values = new LinkedList<String>();
        while (!this.endOfLineReached) {
            values.add(this.readValue());
        }
        return values.toArray(new String[values.size()]);
    }

    private String readValue() throws IOException {
        if (this.position == this.line.length) {
            this.endOfLineReached = true;
            return null;
        }
        if (this.line[this.position] == this.separator) {
            ++this.position;
            return null;
        }
        StringBuffer buffer = new StringBuffer(64);
        boolean inQuote = false;
        if (this.line[this.position] == this.quote) {
            inQuote = true;
            ++this.position;
            if (this.line.length == this.position) {
                throw new IOException("Falsches CSV-Format: Unerwartetes Zeilenende.");
            }
        }
        while (!this.endOfLineReached) {
            if (inQuote) {
                if (this.line[this.position] == this.quote) {
                    inQuote = false;
                    ++this.position;
                } else {
                    buffer.append(this.line[this.position]);
                    ++this.position;
                }
            } else {
                if (this.line[this.position] == this.separator) {
                    ++this.position;
                    break;
                }
                buffer.append(this.line[this.position]);
                ++this.position;
            }
            if (this.position != this.line.length) continue;
            this.endOfLineReached = true;
        }
        if (inQuote) {
            throw new IOException("Falsches CSV-Format: Unerwartetes Zeilenende.");
        }
        return buffer.toString();
    }
}

