/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.X500Name;

public class CertificateGenerator {
    public static final int DEFAULT_KEY_LENGTH = 1024;
    public static final int DEFAULT_VALIDITY_DAYS = 3650;
    private int keyLength = 1024;
    private int validityDays = 3650;
    private Date validityStartDate;

    public static void main(String[] args) {
        String server = null;
        String application = null;
        String organisation = null;
        String city = null;
        String region = null;
        String state = null;
        int keyLength = 1024;
        int validityDays = 3650;
        char[] password = null;
        String file = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if ("-s".equalsIgnoreCase(args[i])) {
                server = args[i + 1];
                continue;
            }
            if ("-a".equalsIgnoreCase(args[i])) {
                application = args[i + 1];
                continue;
            }
            if ("-o".equalsIgnoreCase(args[i])) {
                organisation = args[i + 1];
                continue;
            }
            if ("-c".equalsIgnoreCase(args[i])) {
                city = args[i + 1];
                continue;
            }
            if ("-r".equalsIgnoreCase(args[i])) {
                region = args[i + 1];
                continue;
            }
            if ("-l".equalsIgnoreCase(args[i])) {
                state = args[i + 1];
                continue;
            }
            if ("-k".equalsIgnoreCase(args[i])) {
                try {
                    keyLength = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    System.err.println("FEHLER: Verschl\u00fcssel\u00fcngstiefe ist keine Ganzzahl.");
                    System.exit(1);
                }
                continue;
            }
            if ("-d".equalsIgnoreCase(args[i])) {
                try {
                    validityDays = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    System.err.println("FEHLER: G\u00fcltigkeitsdauer in Tagen ist keine Ganzzahl.");
                    System.exit(1);
                }
                continue;
            }
            if ("-p".equalsIgnoreCase(args[i])) {
                password = args[i + 1].toCharArray();
                continue;
            }
            if (!"-f".equalsIgnoreCase(args[i])) continue;
            file = args[i + 1];
        }
        CertificateGenerator generator = new CertificateGenerator();
        try {
            generator.setKeyLength(keyLength);
            generator.setValidityDays(validityDays);
            generator.generate(server, application, organisation, city, region, state, password, file);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            CertificateGenerator.printUsage();
            System.exit(1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void printUsage() {
        System.err.println("Aufruf:");
        System.err.println("CertificateGenerator <Parameter> -file <Ausgabedatei>");
        System.err.println();
        System.err.println("Erforderliche Parameter:");
        System.err.println();
        System.err.println("   -s   Servername");
        System.err.println("   -a   Anwendung");
        System.err.println("   -o   Organisation");
        System.err.println("   -c   Stadt");
        System.err.println("   -r   Region/Bundesland");
        System.err.println("   -l   Landesk\u00fcrzel");
        System.err.println("   -p   Passwort f\u00fcr den Keystore");
        System.err.println("   -f   Ausgabedatei");
        System.err.println();
        System.err.println("Optionale Parameter:");
        System.err.println();
        System.err.println("   -k   Verschl\u00fcsselungstiefe (Standard: 1024)");
        System.err.println("   -d   G\u00fcltigkeitsdauer in Tagen (Standard: 3650 = 10 Jahre)");
        System.err.println();
        System.err.println("Beispiel:");
        System.err.println("CertificateGenerator -s keyserver -a trustcenter -o Werum -c L\u00fcneburg -r Niedersachsen -l DE -k 1024 -d 1000 -p keypass -f c:\\keyStore");
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLength) {
        if (this.keyLength < 1) {
            throw new IllegalArgumentException("Verschl\u00fcsselungstiefe ist ung\u00fcltig.");
        }
        this.keyLength = keyLength;
    }

    public int getValidityDays() {
        return this.validityDays;
    }

    public void setValidityDays(int validityDays) {
        if (validityDays < 1) {
            throw new IllegalArgumentException("G\u00fcltigkeitsdauer in Tagen ist ung\u00fcltig.");
        }
        this.validityDays = validityDays;
    }

    public void setValidityStartDate(Date validityStartDate) {
        this.validityStartDate = validityStartDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(String server, String application, String organisation, String city, String region, String state, char[] password, String fileName) throws Exception {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("Ausgabedatei wurde nicht angegeben.");
        }
        File file = new File(fileName);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Ausgabedatei ist ung\u00fcltig.");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.generate(server, application, organisation, city, region, state, password, out);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public void generate(String server, String application, String organisation, String city, String region, String state, char[] password, OutputStream out) throws Exception {
        if (server == null || server.length() == 0) {
            throw new IllegalArgumentException("Server wurde nicht angegeben.");
        }
        if (application == null || application.length() == 0) {
            throw new IllegalArgumentException("Anwendung wurde nicht angegeben.");
        }
        if (organisation == null || organisation.length() == 0) {
            throw new IllegalArgumentException("Organisation wurde nicht angegeben.");
        }
        if (city == null || city.length() == 0) {
            throw new IllegalArgumentException("Stadt wurde nicht angegeben.");
        }
        if (region == null || region.length() == 0) {
            throw new IllegalArgumentException("Region/Bundesland wurde nicht angegeben.");
        }
        if (state == null || state.length() == 0) {
            throw new IllegalArgumentException("Land wurde nicht angegeben.");
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("Passwort f\u00fcr den Keystore wurde nicht angegeben.");
        }
        if (out == null) {
            throw new IllegalArgumentException("Ausgabe wurde nicht gesetzt.");
        }
        Date validityStartDate = this.validityStartDate != null ? this.validityStartDate : new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(validityStartDate);
        calendar.add(5, this.validityDays);
        Date validityEndDate = calendar.getTime();
        CertAndKeyGen certAndKeyGen = new CertAndKeyGen("RSA", "MD5WithRSA");
        certAndKeyGen.setRandom(new SecureRandom(new Long(new Date().getTime()).toString().getBytes()));
        certAndKeyGen.generate(this.keyLength);
        PrivateKey key = certAndKeyGen.getPrivateKey();
        X500Name dnName = new X500Name("CN=" + server + ", OU=" + application + ", O=" + organisation + ", L=" + city + ", S=" + region + ", C=" + state);
        Certificate[] chain = new X509Certificate[]{certAndKeyGen.getSelfCertificate(dnName, validityStartDate, (long)(this.validityDays * 24 * 60 * 60))};
        chain[0].checkValidity(validityStartDate);
        chain[0].checkValidity(validityEndDate);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, password);
        keyStore.setKeyEntry(application, key, password, chain);
        keyStore.store(out, password);
    }
}

