/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFBedingung;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.parser.ConditionParser;
import de.statspez.sdf.generator.parser.IncludeVariableGroupParser;
import de.statspez.sdf.generator.parser.IncludeVariableParser;
import de.statspez.sdf.generator.parser.ParserUtil;
import de.statspez.sdf.generator.parser.PreconditionParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.TypesParser;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SDFMerkmalsgruppeParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private ConditionParser conditionParser;
    private PreconditionParser preconditionParser;
    private IncludeVariableParser includeVariableParser;
    private IncludeVariableGroupParser includeVariableGroupParser;
    private MetaSDFMerkmalsgruppe merkmalsgruppe;

    public SDFMerkmalsgruppeParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.conditionParser = new ConditionParser(this, resolver);
        this.parserChain.addParser((SubParser)this.conditionParser);
        this.preconditionParser = new PreconditionParser(this, resolver);
        this.parserChain.addParser((SubParser)this.preconditionParser);
        this.includeVariableParser = new IncludeVariableParser(this, resolver);
        this.parserChain.addParser((SubParser)this.includeVariableParser);
        this.includeVariableGroupParser = new IncludeVariableGroupParser(this, resolver);
        this.parserChain.addParser((SubParser)this.includeVariableGroupParser);
        this.merkmalsgruppe = null;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("variableGroup".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new MetaParseException("Fuer die Merkmalsgruppe ist kein Name definiert!");
            }
            this.merkmalsgruppe.setName(SDFTags.dekodiereXMLName(name));
            this.merkmalsgruppe.setIndex(TypesParser.parseIndex(atts.getValue("indexing")));
            if (this.merkmalsgruppe.getIndex() == 3) {
                String indexVariable = atts.getValue("index-variable");
                if (indexVariable == null) {
                    throw new MetaParseException("Fuer die Merkmalsgruppe ist kein indexbildendes Merkmal definiert!");
                }
                this.merkmalsgruppe.setIndexVariable(SDFTags.dekodiereXMLName(indexVariable));
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("annotation".equalsIgnoreCase(localName)) {
            this.merkmalsgruppe.setKommentar(ParserUtil.removeWhitespaces(chars));
        } else {
            handled = false;
        }
        return handled;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("variableGroup".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("variableGroup".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.merkmalsgruppe = new MetaSDFMerkmalsgruppe();
            this.enable();
        } else if ("conditions".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("annotation".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            if ("description".equalsIgnoreCase(localName)) {
                ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            } else {
                throw MetaParseException.unknownTagException((String)localName);
            }
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("variableGroup".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!("conditions".equalsIgnoreCase(localName) || this.handleTag(namespaceURI, localName, qName) || this.parserChain.endElement(namespaceURI, localName, qName))) {
            if ("description".equalsIgnoreCase(localName)) {
                this.merkmalsgruppe.setBeschreibung(this.superParser().charData().toString().trim());
            } else {
                throw MetaParseException.unknownClosingTagException((String)localName);
            }
        }
    }

    public MetaElementInterface object() {
        return this.merkmalsgruppe;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.conditionParser) {
            Iterator iter = this.conditionParser.getConditions();
            while (iter != null && iter.hasNext()) {
                this.merkmalsgruppe.addToSDFBedingungen((MetaSDFBedingung)iter.next());
            }
        } else if (aParser == this.preconditionParser) {
            Iterator iter = this.preconditionParser.getConditions();
            while (iter != null && iter.hasNext()) {
                this.merkmalsgruppe.addToSDFBedingungen((MetaSDFBedingung)iter.next());
            }
        } else {
            this.merkmalsgruppe.addToSDFFeldReferenzen((MetaSDFFeldReferenz)aParser.object());
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

