/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFBedingung;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.parser.ConditionParser;
import de.statspez.sdf.generator.parser.IncludeVariableParser;
import de.statspez.sdf.generator.parser.PreconditionParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MessageDataGroupParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private ConditionParser conditionParser;
    private PreconditionParser preconditionParser;
    private IncludeVariableParser includeVariableParser;
    private MetaSDFAusgabegruppe hilfsgruppe;

    public MessageDataGroupParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.conditionParser = new ConditionParser(this, resolver);
        this.parserChain.addParser((SubParser)this.conditionParser);
        this.preconditionParser = new PreconditionParser(this, resolver);
        this.parserChain.addParser((SubParser)this.preconditionParser);
        this.includeVariableParser = new IncludeVariableParser(this, resolver);
        this.parserChain.addParser((SubParser)this.includeVariableParser);
        this.hilfsgruppe = null;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) {
        String name;
        if ("messageDataGroup".equalsIgnoreCase(localName) && (name = atts.getValue("name")) != null) {
            this.hilfsgruppe.setName(SDFTags.dekodiereXMLName(name));
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("messageDataGroup".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("messageDataGroup".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSDF(namespaceURI);
            this.hilfsgruppe = new MetaSDFAusgabegruppe();
            this.hilfsgruppe.setAttributDaten((short)2);
            this.enable();
        } else if ("conditions".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            if ("description".equalsIgnoreCase(localName)) {
                ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            } else if ("annotation".equalsIgnoreCase(localName)) {
                ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            } else {
                throw MetaParseException.unknownTagException((String)localName);
            }
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("messageDataGroup".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!("conditions".equalsIgnoreCase(localName) || this.parserChain.endElement(namespaceURI, localName, qName) || "description".equalsIgnoreCase(localName) || "annotation".equalsIgnoreCase(localName))) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.hilfsgruppe;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.conditionParser) {
            Iterator iter = this.conditionParser.getConditions();
            while (iter != null && iter.hasNext()) {
                this.hilfsgruppe.addToSDFBedingungen((MetaSDFBedingung)iter.next());
            }
        } else if (aParser == this.preconditionParser) {
            Iterator iter = this.preconditionParser.getConditions();
            while (iter != null && iter.hasNext()) {
                this.hilfsgruppe.addToSDFBedingungen((MetaSDFBedingung)iter.next());
            }
        } else {
            this.hilfsgruppe.addToSDFFeldReferenzen((MetaSDFFeldReferenz)aParser.object());
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

