/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CreationDateParser
extends SubParser {
    private int year = 0;
    private int month = 0;
    private int day = 0;

    public CreationDateParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("year".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.year = Integer.parseInt(chars);
                return handled;
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Jahresangabe!", (Exception)e);
            }
        } else {
            if ("month".equalsIgnoreCase(localName)) {
                try {
                    if (chars.length() <= 0) return handled;
                    this.month = Integer.parseInt(chars);
                    if (this.month < 1) throw new MetaParseException("Fehlerhafte Monatangabe!");
                    if (this.month <= 12) return handled;
                    throw new MetaParseException("Fehlerhafte Monatangabe!");
                }
                catch (NumberFormatException e) {
                    throw new MetaParseException("Fehlerhafte Monatangabe!", (Exception)e);
                }
            }
            if (!"day".equalsIgnoreCase(localName)) return false;
            try {
                if (chars.length() <= 0) return handled;
                this.day = Integer.parseInt(chars);
                if (this.day < 1) throw new MetaParseException("Fehlerhafte Tagangabe!");
                if (this.day <= 31) return handled;
                throw new MetaParseException("Fehlerhafte Tagangabe!");
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Tagangabe!", (Exception)e);
            }
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("creationDate".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("creationDate".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.year = 0;
            this.month = 0;
            this.day = 0;
            this.enable();
        } else if ("year".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("month".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("day".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else {
            throw MetaParseException.unknownTagException((String)localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("creationDate".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return null;
    }
}

