/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.service;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;

public class HazelcastAuthFilter
implements Filter {
    private static final String SAIKU_AUTH_PRINCIPAL = "SAIKU_AUTH_PRINCIPAL";
    private static final int FIVE_MINUTES = 300;
    private static final String ORBIS_WORKSPACE_DIR = "workspace";
    private boolean enabled;
    private String orbisAuthCookie;
    private String hazelcastMapName;
    private String baseWorkspaceDir;
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.setFilterConfig(filterConfig);
        this.enabled = Boolean.parseBoolean(this.initParameter(filterConfig, "enabled", "true"));
        this.orbisAuthCookie = this.initParameter(filterConfig, "orbisAuthCookie", "ORBIS_WORKSPACE_USER");
        this.hazelcastMapName = this.initParameter(filterConfig, "hazelcastMapName", "my-sessions");
        this.baseWorkspaceDir = this.initParameter(filterConfig, "baseWorkspaceDir", "../../repository/data");
    }

    private String initParameter(FilterConfig filterConfig, String paramName, String defaultValue) {
        if (filterConfig.getInitParameter(paramName) != null) {
            return filterConfig.getInitParameter(paramName);
        }
        return defaultValue;
    }

    public String getBaseWorkspaceDir() {
        return this.baseWorkspaceDir;
    }

    public String getHazelcastMapName() {
        return this.hazelcastMapName;
    }

    public String getOrbisAuthCookie() {
        return this.orbisAuthCookie;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        if (this.enabled && (session = ((HttpServletRequest)req).getSession()) != null) {
            for (Cookie cookie : ((HttpServletRequest)req).getCookies()) {
                if (!cookie.getName().equals(this.orbisAuthCookie)) continue;
                String cookieVal = cookie.getValue();
                this.setCookieValue(res, SAIKU_AUTH_PRINCIPAL, cookieVal);
                session.setAttribute(ORBIS_WORKSPACE_DIR, (Object)("workspace_" + cookieVal));
                session.setAttribute(SAIKU_AUTH_PRINCIPAL, (Object)cookieVal);
                break;
            }
        }
        chain.doFilter(req, res);
    }

    private void setCookieValue(ServletResponse res, String cookieName, String cookieVal) {
        HttpServletResponse response = (HttpServletResponse)res;
        Cookie orbisCookie = new Cookie(cookieName, cookieVal);
        orbisCookie.setMaxAge(300);
        orbisCookie.setPath("/");
        response.addCookie(orbisCookie);
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}

