/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;

public class ServletUtil {
    private static final String PREFIX_PARAMETER = "param";

    public static Map<String, String> getParameters(HttpServletRequest req) {
        return ServletUtil.getParameters(req, PREFIX_PARAMETER);
    }

    private static Map<String, String> getParameters(HttpServletRequest req, String prefix) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (req != null) {
            Enumeration enumeration = req.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String param = (String)enumeration.nextElement();
                String value = req.getParameter(param);
                if (StringUtils.isNotBlank((String)prefix)) {
                    if (!param.toLowerCase().startsWith(prefix)) continue;
                    param = param.substring(prefix.length());
                    queryParams.put(param, value);
                    continue;
                }
                queryParams.put(param, value);
            }
        }
        return queryParams;
    }

    private static Map<String, String> getParameters(MultivaluedMap<String, String> formParams) {
        return ServletUtil.getParameters(formParams, PREFIX_PARAMETER);
    }

    private static Map<String, String> getParameters(MultivaluedMap<String, String> formParams, String prefix) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (formParams != null) {
            Iterator iterator = formParams.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String param = key = (String)iterator.next();
                String value = (String)formParams.getFirst((Object)key);
                if (StringUtils.isNotBlank((String)prefix)) {
                    if (!param.toLowerCase().startsWith(prefix)) continue;
                    param = param.substring(prefix.length());
                    queryParams.put(param, value);
                    continue;
                }
                queryParams.put(param, value);
            }
        }
        return queryParams;
    }

    private static String replaceParameters(String query, Map<String, String> parameters) {
        if (parameters != null) {
            for (String parameter : parameters.keySet()) {
                String value = parameters.get(parameter);
                query = query.replaceAll("(?i)\\$\\{" + parameter + "\\}", value);
            }
        }
        return query;
    }

    public static String replaceParameters(HttpServletRequest req, String query) {
        Map<String, String> queryParams = ServletUtil.getParameters(req);
        return ServletUtil.replaceParameters(query, queryParams);
    }

    public static String replaceParameters(MultivaluedMap<String, String> formParams, String query) {
        Map<String, String> queryParams = ServletUtil.getParameters(formParams);
        return ServletUtil.replaceParameters(query, queryParams);
    }
}

