/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import mondrian.olap4j.SaikuMondrianHelper;
import mondrian.rolap.RolapConnection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.olap4j.AllocationPolicy;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.Scenario;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.query.LimitFunction;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.olap4j.query.SortOrder;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuDimensionSelection;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SaikuQuery;
import org.saiku.olap.dto.SaikuSelection;
import org.saiku.olap.dto.SaikuTag;
import org.saiku.olap.dto.SaikuTuple;
import org.saiku.olap.dto.SimpleCubeElement;
import org.saiku.olap.dto.filter.SaikuFilter;
import org.saiku.olap.dto.resultset.AbstractBaseCell;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.dto.resultset.DataCell;
import org.saiku.olap.dto.resultset.MemberCell;
import org.saiku.olap.query.IQuery;
import org.saiku.olap.query.MdxQuery;
import org.saiku.olap.query.OlapQuery;
import org.saiku.olap.query.QueryDeserializer;
import org.saiku.olap.query.QuerySerializer;
import org.saiku.olap.util.ObjectUtil;
import org.saiku.olap.util.OlapResultSetUtil;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.olap.util.SaikuUniqueNameComparator;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.saiku.olap.util.formatter.CellSetFormatter;
import org.saiku.olap.util.formatter.FlattenedCellSetFormatter;
import org.saiku.olap.util.formatter.HierarchicalCellSetFormatter;
import org.saiku.olap.util.formatter.ICellSetFormatter;
import org.saiku.service.olap.OlapDiscoverService;
import org.saiku.service.olap.totals.AxisInfo;
import org.saiku.service.olap.totals.TotalsListsBuilder;
import org.saiku.service.olap.totals.aggregators.TotalAggregator;
import org.saiku.service.util.KeyValue;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.service.util.export.CsvExporter;
import org.saiku.service.util.export.ExcelExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlapQueryService
implements Serializable {
    private static final long serialVersionUID = -7615296596528274904L;
    private static final Logger log = LoggerFactory.getLogger(OlapQueryService.class);
    private OlapDiscoverService olapDiscoverService;
    private transient Map<String, IQuery> queries = new HashMap<String, IQuery>();
    private Map<String, String> serializableQueries = null;
    private static final AtomicLong ID_GENERATOR = new AtomicLong();

    public void setOlapDiscoverService(OlapDiscoverService os) {
        this.olapDiscoverService = os;
    }

    private OlapQueryService() {
    }

    public void destroy() {
        for (Object q : this.queries.keySet().toArray()) {
            this.closeQuery(q.toString());
        }
    }

    public SaikuQuery createNewOlapQuery(String queryName, SaikuCube cube) {
        try {
            Cube cub = this.olapDiscoverService.getNativeCube(cube);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(cube.getConnection());
            if (cub != null) {
                OlapQuery query = new OlapQuery(new Query(queryName, cub), con, cube);
                this.putIQuery(queryName, query);
                return ObjectUtil.convert(query);
            }
        }
        catch (Exception e) {
            log.error("Cannot create new query for cube :" + cube, (Throwable)e);
        }
        return null;
    }

    public SaikuQuery createNewOlapQuery(String name, String xml) {
        try {
            QueryDeserializer qd = new QueryDeserializer();
            SaikuCube scube = qd.getFakeCube(xml);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(scube.getConnection());
            IQuery query = qd.unparse(xml, con);
            if (name == null) {
                name = UUID.randomUUID().toString();
                this.putIQuery(name, query);
            } else {
                this.putIQuery(name, query);
            }
            return ObjectUtil.convert(query);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error creating query from xml", e);
        }
    }

    private void closeQuery(String queryName) {
        try {
            IQuery q = this.getIQuery(queryName);
            q.cancel();
            this.removeIQuery(queryName);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error closing query: " + queryName, e);
        }
    }

    public List<String> getQueries() {
        ArrayList<String> queryList = new ArrayList<String>();
        queryList.addAll(this.getIQueryMap().keySet());
        return queryList;
    }

    public SaikuQuery getQuery(String queryName) {
        IQuery q = this.getIQuery(queryName);
        return ObjectUtil.convert(q);
    }

    public void deleteQuery(String queryName) {
        this.removeIQuery(queryName);
    }

    public void cancel(String queryName) {
        try {
            IQuery q = this.getIQuery(queryName);
            q.cancel();
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error cancelling query: " + queryName, e);
        }
    }

    public CellDataSet execute(String queryName) {
        return this.execute(queryName, new HierarchicalCellSetFormatter());
    }

    public CellDataSet execute(String queryName, String formatter) {
        switch (formatter = formatter == null ? "" : formatter.toLowerCase()) {
            case "flat": {
                return this.execute(queryName, new CellSetFormatter());
            }
            case "hierarchical": {
                return this.execute(queryName, new HierarchicalCellSetFormatter());
            }
            case "flattened": {
                return this.execute(queryName, new FlattenedCellSetFormatter());
            }
        }
        return this.execute(queryName, new FlattenedCellSetFormatter());
    }

    private CellDataSet execute(String queryName, ICellSetFormatter formatter) {
        String runId = "runId:" + ID_GENERATOR.getAndIncrement();
        try {
            IQuery query = this.getIQuery(queryName);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getSaikuCube().getConnection());
            Long start = new Date().getTime();
            if (query.getScenario() != null) {
                log.info(runId + "\tQuery: " + query.getName() + " Setting scenario:" + query.getScenario().getId());
                con.setScenario(query.getScenario());
            }
            if (query.getTag() != null) {
                query = this.applyTag(query, con, query.getTag());
            }
            String mdx = query.getMdx();
            log.info(runId + "\tType:" + (Object)((Object)query.getType()) + ":\n" + mdx);
            CellSet cellSet = query.execute();
            Long exec = new Date().getTime();
            if (query.getScenario() != null) {
                log.info("Query (" + queryName + ") removing scenario:" + query.getScenario().getId());
                con.setScenario(null);
            }
            CellDataSet result = OlapResultSetUtil.cellSet2Matrix(cellSet, formatter);
            Long format = new Date().getTime();
            result.setRuntime(new Double(format - start).intValue());
            this.getIQuery(queryName).storeCellset(cellSet);
            this.getIQuery(queryName).storeFormatter(formatter);
            if (IQuery.QueryType.QM.equals((Object)query.getType()) && formatter instanceof FlattenedCellSetFormatter) {
                QueryDimension queryDimension = query.getDimension("Measures");
                Measure[] selectedMeasures = new Measure[queryDimension.getInclusions().size()];
                for (int i = 0; i < selectedMeasures.length; ++i) {
                    selectedMeasures[i] = (Measure)((Selection)queryDimension.getInclusions().get(i)).getRootElement();
                }
                result.setSelectedMeasures(selectedMeasures);
                int rowsIndex = 0;
                if (!((CellSetAxis)cellSet.getAxes().get(0)).getAxisOrdinal().equals(Axis.ROWS)) {
                    rowsIndex = rowsIndex + 1 & 1;
                }
                AxisInfo[] axisInfos = new AxisInfo[]{new AxisInfo((CellSetAxis)cellSet.getAxes().get(rowsIndex)), new AxisInfo((CellSetAxis)cellSet.getAxes().get(rowsIndex + 1 & 1))};
                List[][] totals = new List[2][];
                TotalsListsBuilder builder = null;
                for (int index = 0; index < 2; ++index) {
                    int second = index + 1 & 1;
                    TotalAggregator[] aggregators = new TotalAggregator[axisInfos[second].maxDepth + 1];
                    for (int i = 1; i < aggregators.length - 1; ++i) {
                        String totalFunctionName = query.getTotalFunction(axisInfos[second].uniqueLevelNames.get(i - 1));
                        aggregators[i] = TotalAggregator.newInstanceByFunctionName(totalFunctionName);
                    }
                    String totalFunctionName = query.getTotalFunction(axisInfos[second].axis.getAxisOrdinal().name());
                    aggregators[0] = TotalAggregator.newInstanceByFunctionName(totalFunctionName);
                    builder = new TotalsListsBuilder(selectedMeasures, aggregators, cellSet, axisInfos[index], axisInfos[second]);
                    totals[index] = builder.buildTotalsLists();
                }
                result.setLeftOffset(axisInfos[0].maxDepth);
                result.setRowTotalsLists(totals[1]);
                result.setColTotalsLists(totals[0]);
            }
            Long totals = new Date().getTime();
            log.info(runId + "\tSize: " + result.getWidth() + "/" + result.getHeight() + "\tExecute:\t" + (exec - start) + "ms\tFormat:\t" + (format - exec) + "ms\tTotals:\t" + (totals - format) + "ms\t Total: " + (totals - start) + "ms");
            return result;
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.info(runId + "\tException: " + error);
            }
            throw new SaikuServiceException(runId + "\tCan't execute query: " + queryName, e);
        }
        catch (Error e) {
            if (log.isInfoEnabled()) {
                String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
                log.info(runId + "\tError: " + error);
            }
            throw new SaikuServiceException(runId + "\tCan't execute query: " + queryName, e);
        }
    }

    public SaikuQuery simulateTag(String queryName, SaikuTag tag) {
        try {
            IQuery query = this.getIQuery(queryName);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getSaikuCube().getConnection());
            return ObjectUtil.convert(this.applyTag(query, con, tag));
        }
        catch (Exception e) {
            throw new SaikuServiceException("Can't apply tag: " + tag + " to query " + queryName, e);
        }
    }

    private IQuery applyTag(IQuery query, OlapConnection con, SaikuTag t) throws Exception {
        String xml = query.toXml();
        QueryDeserializer qd = new QueryDeserializer();
        query = qd.unparse(xml, con);
        ArrayList<SimpleCubeElement> doneDimension = new ArrayList<SimpleCubeElement>();
        HashMap<String, QueryDimension> dimensionMap = new HashMap<String, QueryDimension>();
        if (t.getSaikuTupleDimensions() != null) {
            for (SimpleCubeElement st : t.getSaikuTupleDimensions()) {
                if (doneDimension.contains(st)) continue;
                QueryDimension dim = query.getDimension(st.getName());
                dimensionMap.put(st.getUniqueName(), dim);
                dim.clearExclusions();
                dim.clearInclusions();
                query.moveDimension(dim, null);
                doneDimension.add(st);
            }
            if (t.getSaikuTupleDimensions().size() > 0) {
                SimpleCubeElement rootDim = t.getSaikuTupleDimensions().get(0);
                QueryDimension dim = query.getDimension(rootDim.getName());
                query.moveDimension(dim, (Axis)Axis.COLUMNS);
                for (SaikuTuple tuple : t.getSaikuTuples()) {
                    SaikuMember m = tuple.getSaikuMember(rootDim.getUniqueName());
                    List<SaikuMember> others = tuple.getOtherSaikuMembers(rootDim.getUniqueName());
                    Selection sel = dim.createSelection(IdentifierParser.parseIdentifier((String)m.getUniqueName()));
                    for (SaikuMember context : others) {
                        QueryDimension otherDim = (QueryDimension)dimensionMap.get(context.getDimensionUniqueName());
                        query.moveDimension(otherDim, (Axis)Axis.COLUMNS);
                        Selection ctxSel = otherDim.createSelection(IdentifierParser.parseIdentifier((String)context.getUniqueName()));
                        sel.addContext(ctxSel);
                    }
                    dim.getInclusions().add(sel);
                }
            }
        }
        if (t.getSaikuDimensionSelections() != null) {
            for (SaikuDimensionSelection dimsel : t.getSaikuDimensionSelections()) {
                if (dimsel.getName().equals("Measures")) continue;
                QueryDimension filterDim = query.getDimension(dimsel.getName());
                query.moveDimension(filterDim, (Axis)Axis.FILTER);
                filterDim.clearInclusions();
                for (SaikuSelection ss : dimsel.getSelections()) {
                    if (ss.getType() != SaikuSelection.Type.MEMBER) continue;
                    Selection sel = filterDim.createSelection(IdentifierParser.parseIdentifier((String)ss.getUniqueName()));
                    if (filterDim.getInclusions().contains(sel)) continue;
                    filterDim.getInclusions().add(sel);
                }
            }
        }
        return query;
    }

    public void setMdx(String queryName, String mdx) {
        IQuery q = this.getIQuery(queryName);
        q.setMdx(mdx);
    }

    public CellDataSet executeMdx(String queryName, String mdx) {
        this.qm2mdx(queryName);
        this.setMdx(queryName, mdx);
        return this.execute(queryName, new HierarchicalCellSetFormatter());
    }

    public CellDataSet executeMdx(String queryName, String mdx, ICellSetFormatter formatter) {
        this.qm2mdx(queryName);
        this.setMdx(queryName, mdx);
        return this.execute(queryName, formatter);
    }

    public List<SimpleCubeElement> getResultMetadataMembers(String queryName, boolean preferResult, String dimensionName, String hierarchyName, String levelName, String searchString, int searchLimit) {
        IQuery query = this.getIQuery(queryName);
        CellSet cs = query.getCellset();
        List<SimpleCubeElement> members = new ArrayList<SimpleCubeElement>();
        HashSet<Level> levels = new HashSet<Level>();
        boolean search = StringUtils.isNotBlank((String)searchString);
        preferResult = preferResult && !search;
        String string = searchString = search ? searchString.toLowerCase() : null;
        if (cs != null && preferResult) {
            block0: for (CellSetAxis axis : cs.getAxes()) {
                int posIndex = 0;
                for (Hierarchy h : axis.getAxisMetaData().getHierarchies()) {
                    if (h.getUniqueName().equals(hierarchyName) || h.getName().equals(hierarchyName)) {
                        log.debug("Found hierarchy in the result: " + hierarchyName);
                        if (h.getLevels().size() == 1) continue block0;
                        HashSet<Member> mset = new HashSet<Member>();
                        for (Position pos : axis.getPositions()) {
                            Member m = (Member)pos.getMembers().get(posIndex);
                            if (!m.getLevel().getLevelType().equals((Object)Level.Type.ALL)) {
                                levels.add(m.getLevel());
                            }
                            if (!m.getLevel().getUniqueName().equals(levelName) && !m.getLevel().getName().equals(levelName)) continue;
                            mset.add(m);
                        }
                        members = ObjectUtil.convert2Simple(mset);
                        Collections.sort(members, new SaikuUniqueNameComparator());
                        continue block0;
                    }
                    ++posIndex;
                }
            }
            log.debug("Found members in the result: " + members.size());
        }
        if (cs == null || !preferResult || members.size() == 0 || levels.size() == 1) {
            members = this.olapDiscoverService.getLevelMembers(query.getSaikuCube(), hierarchyName, levelName, searchString, searchLimit);
        }
        return members;
    }

    public ResultSet explain(String queryName) {
        OlapStatement stmt = null;
        try {
            OlapConnection con = this.olapDiscoverService.getNativeConnection(this.getQuery(queryName).getCube().getConnection());
            if (!con.isWrapperFor(RolapConnection.class)) {
                throw new IllegalArgumentException("Cannot only get explain plan for Mondrian connections");
            }
            stmt = con.createStatement();
            String mdx = this.getMDXQuery(queryName);
            mdx = "EXPLAIN PLAN FOR \n" + mdx;
            ResultSet resultSet = stmt.executeQuery(mdx);
            return resultSet;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error EXPLAIN: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public SaikuQuery drillacross(String queryName, List<Integer> cellPosition, Map<String, List<String>> levels) {
        try {
            IQuery query = this.getIQuery(queryName);
            query.clearAxis("ROWS");
            query.clearAxis("COLUMNS");
            HashSet<Level> levelSet = new HashSet<Level>();
            CellSet cs = query.getCellset();
            if (cs == null) {
                throw new SaikuServiceException("Cannot drill across. Last CellSet empty");
            }
            for (int i = 0; i < cellPosition.size(); ++i) {
                List members = ((Position)((CellSetAxis)cs.getAxes().get(i)).getPositions().get(cellPosition.get(i))).getMembers();
                for (Member m : members) {
                    QueryDimension qd = query.getDimension(m.getDimension().getName());
                    if (qd.getName().equals("Measures")) {
                        query.moveDimension(qd, (Axis)Axis.COLUMNS);
                    } else {
                        query.moveDimension(qd, (Axis)Axis.FILTER);
                    }
                    levelSet.add(m.getLevel());
                    qd.include(m);
                }
            }
            if (levels != null) {
                for (String key : levels.keySet()) {
                    String dimName = key.split("###")[0];
                    QueryDimension qd = query.getDimension(dimName);
                    if ("Measures".equals(dimName)) {
                        for (String measureName : levels.get(key)) {
                            List memberList = IdentifierNode.parseIdentifier((String)measureName).getSegmentList();
                            Selection sel = qd.createSelection(memberList);
                            if (qd.getInclusions().contains(sel)) continue;
                            qd.getInclusions().add(sel);
                        }
                        if (qd.getInclusions().size() <= 0) continue;
                        query.moveDimension(qd, (Axis)Axis.COLUMNS);
                        continue;
                    }
                    if (qd.getInclusions().size() > 0 && !"Measures".equals(dimName)) {
                        query.moveDimension(qd, (Axis)Axis.ROWS);
                        continue;
                    }
                    String hName = key.split("###")[1];
                    Dimension d = qd.getDimension();
                    Hierarchy h = (Hierarchy)d.getHierarchies().get(hName);
                    for (Level l : h.getLevels()) {
                        if (levelSet.contains(l)) {
                            if (qd.getInclusions().size() <= 0) continue;
                            query.moveDimension(qd, (Axis)Axis.ROWS);
                            continue;
                        }
                        for (String levelU : levels.get(key)) {
                            if (!l.getUniqueName().equals(levelU) && !l.getName().equals(levelU)) continue;
                            qd.include(l);
                            if (qd.getInclusions().size() <= 0) continue;
                            query.moveDimension(qd, (Axis)Axis.ROWS);
                        }
                    }
                }
            }
            if (query.getAxis((Axis)Axis.COLUMNS).getDimensions().size() == 0) {
                QueryDimension mD = query.getDimension("Measures");
                if (mD.getInclusions().size() == 0) {
                    Member defaultMeasure = mD.getDimension().getDefaultHierarchy().getDefaultMember();
                    mD.include(defaultMeasure);
                }
                query.moveDimension(mD, (Axis)Axis.COLUMNS);
            }
            this.putIQuery(queryName, query);
            return ObjectUtil.convert(query);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error drilling across: " + queryName, e);
        }
    }

    public boolean isMdxDrillthrough(String queryName, String drillthroughMdx) {
        try {
            OlapConnection con = this.olapDiscoverService.getNativeConnection(this.getQuery(queryName).getCube().getConnection());
            return SaikuMondrianHelper.isMondrianDrillthrough((OlapConnection)con, (String)drillthroughMdx);
        }
        catch (Error | Exception e) {
            log.warn("Error checking for DRILLTHROUGH: " + queryName + " DRILLTHROUGH MDX:" + drillthroughMdx, e);
            return false;
        }
    }

    public ResultSet drillthrough(String queryName, String drillthroughMdx) {
        OlapStatement stmt = null;
        try {
            OlapConnection con = this.olapDiscoverService.getNativeConnection(this.getQuery(queryName).getCube().getConnection());
            stmt = con.createStatement();
            ResultSet resultSet = stmt.executeQuery(drillthroughMdx);
            return resultSet;
        }
        catch (SQLException e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName + " DRILLTHROUGH MDX:" + drillthroughMdx, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ResultSet drillthrough(String queryName, int maxrows, String returns) {
        OlapStatement stmt = null;
        try {
            OlapConnection con = this.olapDiscoverService.getNativeConnection(this.getQuery(queryName).getCube().getConnection());
            stmt = con.createStatement();
            String mdx = this.getMDXQuery(queryName);
            mdx = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + mdx : "DRILLTHROUGH " + mdx;
            if (StringUtils.isNotBlank((String)returns)) {
                mdx = mdx + "\r\n RETURN " + returns;
            }
            ResultSet resultSet = stmt.executeQuery(mdx);
            return resultSet;
        }
        catch (SQLException e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ResultSet drillthrough(String queryName, List<Integer> cellPosition, Integer maxrows, String returns) {
        OlapStatement stmt = null;
        try {
            IQuery query = this.getIQuery(queryName);
            CellSet cs = query.getCellset();
            SaikuCube cube = this.getQuery(queryName).getCube();
            OlapConnection con = this.olapDiscoverService.getNativeConnection(cube.getConnection());
            stmt = con.createStatement();
            SelectNode sn = new DefaultMdxParserImpl().parseSelect(this.getMDXQuery(queryName));
            String select = null;
            StringBuilder buf = new StringBuilder();
            if (sn.getWithList() != null && sn.getWithList().size() > 0) {
                buf.append("WITH \n");
                StringWriter sw = new StringWriter();
                ParseTreeWriter ptw = new ParseTreeWriter((Writer)sw);
                PrintWriter pw = ptw.getPrintWriter();
                for (ParseTreeNode with : sn.getWithList()) {
                    with.unparse(ptw);
                    pw.println();
                }
                buf.append(sw.toString());
            }
            buf.append("SELECT (");
            for (int i = 0; i < cellPosition.size(); ++i) {
                List members = ((Position)((CellSetAxis)cs.getAxes().get(i)).getPositions().get(cellPosition.get(i))).getMembers();
                for (int k = 0; k < members.size(); ++k) {
                    Member m = (Member)members.get(k);
                    if (k > 0 || i > 0) {
                        buf.append(", ");
                    }
                    buf.append(m.getUniqueName());
                }
            }
            buf.append(") ON COLUMNS \r\n");
            buf.append("FROM [").append(cube.getName()).append("]\r\n");
            StringWriter writer = new StringWriter();
            sn.getFilterAxis().unparse(new ParseTreeWriter(new PrintWriter(writer)));
            if (StringUtils.isNotBlank((String)((Object)writer).toString())) {
                buf.append("WHERE ").append(((Object)writer).toString());
            }
            select = buf.toString();
            select = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + select + "\r\n" : "DRILLTHROUGH " + select + "\r\n";
            if (StringUtils.isNotBlank((String)returns)) {
                select = select + "\r\n RETURN " + returns;
            }
            log.debug("Drill Through for query (" + queryName + ") : \r\n" + select);
            ResultSet resultSet = stmt.executeQuery(select);
            return resultSet;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] exportDrillthroughCsv(String queryName, int maxrows) {
        OlapStatement stmt = null;
        try {
            OlapConnection con = this.olapDiscoverService.getNativeConnection(this.getQuery(queryName).getCube().getConnection());
            stmt = con.createStatement();
            String mdx = this.getMDXQuery(queryName);
            mdx = maxrows > 0 ? "DRILLTHROUGH MAXROWS " + maxrows + " " + mdx : "DRILLTHROUGH " + mdx;
            ResultSet rs = stmt.executeQuery(mdx);
            byte[] byArray = CsvExporter.exportCsv(rs);
            return byArray;
        }
        catch (SQLException e) {
            throw new SaikuServiceException("Error DRILLTHROUGH: " + queryName, e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public byte[] exportResultSetCsv(ResultSet rs) {
        return CsvExporter.exportCsv(rs);
    }

    public byte[] exportResultSetCsv(ResultSet rs, String delimiter, String enclosing, boolean printHeader, List<KeyValue<String, String>> additionalColumns) {
        return CsvExporter.exportCsv(rs, delimiter, enclosing, printHeader, additionalColumns);
    }

    public void setCellValue(String queryName, List<Integer> position, String value) {
        try {
            IQuery query = this.getIQuery(queryName);
            OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getSaikuCube().getConnection());
            if (query.getScenario() == null) {
                Scenario s = con.createScenario();
                query.setScenario(s);
                con.setScenario(s);
                log.info("Created scenario:" + s + " : cell:" + position + " value" + value);
            } else {
                Scenario s = query.getScenario();
                con.setScenario(s);
                log.info("Using scenario:" + s + " : cell:" + position + " value" + value);
            }
            CellSet cs1 = query.execute();
            query.storeCellset(cs1);
            Number v = null;
            try {
                v = Integer.parseInt(value);
            }
            catch (Exception e) {
                v = Double.parseDouble(value);
            }
            if (v == null) {
                throw new SaikuServiceException("Error setting value of query " + queryName + " to:" + v);
            }
            String allocationPolicy = AllocationPolicy.EQUAL_ALLOCATION.toString();
            AllocationPolicy ap = AllocationPolicy.valueOf((String)allocationPolicy);
            CellSet cs = query.getCellset();
            cs.getCell(position).setValue((Object)v, ap, new Object[0]);
            con.setScenario(null);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error setting value: " + queryName, e);
        }
    }

    public IQuery swapAxes(String queryName) {
        IQuery query = this.getIQuery(queryName);
        if (IQuery.QueryType.QM.equals((Object)query.getType())) {
            query.swapAxes();
        }
        return query;
    }

    public IQuery showGrandTotals(String queryName, String axisName, String functionName) {
        IQuery query = this.getIQuery(queryName);
        if ("not".equals(functionName)) {
            functionName = null;
        }
        query.setTotalFunction(axisName, functionName);
        return query;
    }

    public boolean includeChildren(String queryName, String dimensionName, String uniqueMemberName) {
        IQuery query = this.getIQuery(queryName);
        List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
        QueryDimension dimension = query.getDimension(dimensionName);
        try {
            Selection sel = dimension.createSelection(Selection.Operator.CHILDREN, memberList);
            dimension.getInclusions().add(sel);
            return true;
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Cannot include children query (" + queryName + ") dimension (" + dimensionName + ") member (" + uniqueMemberName + ")", e);
        }
    }

    public boolean removeChildren(String queryName, String dimensionName, String uniqueMemberName) {
        IQuery query = this.getIQuery(queryName);
        List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
        QueryDimension dimension = query.getDimension(dimensionName);
        try {
            Selection sel = dimension.createSelection(Selection.Operator.CHILDREN, memberList);
            if (dimension.getInclusions().contains(sel)) {
                dimension.getInclusions().remove(sel);
            }
            return true;
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Cannot remove children query (" + queryName + ") dimension (" + dimensionName + ") member (" + uniqueMemberName + ")", e);
        }
    }

    private boolean removeAllChildren(String queryName, String dimensionName) {
        IQuery query = this.getIQuery(queryName);
        QueryDimension dimension = query.getDimension(dimensionName);
        ArrayList<Selection> children = new ArrayList<Selection>();
        try {
            for (Selection sel : dimension.getInclusions()) {
                if (!sel.getOperator().equals((Object)Selection.Operator.CHILDREN)) continue;
                children.add(sel);
            }
            dimension.getInclusions().removeAll(children);
            return true;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot remove all children  for query (" + queryName + ") dimension (" + dimensionName + ")", e);
        }
    }

    public boolean includeMember(String queryName, String dimensionName, String uniqueMemberName, String selectionType, int memberposition) {
        String defaultTotalsFunction = "";
        return this.includeMember(queryName, dimensionName, uniqueMemberName, selectionType, defaultTotalsFunction, memberposition);
    }

    public boolean includeMember(String queryName, String dimensionName, String uniqueMemberName, String selectionType, String totalsFunction, int memberposition) {
        IQuery query = this.getIQuery(queryName);
        List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
        QueryDimension dimension = query.getDimension(dimensionName);
        Selection.Operator selectionMode = Selection.Operator.valueOf((String)selectionType);
        try {
            this.removeAllChildren(queryName, dimensionName);
            Selection sel = dimension.createSelection(selectionMode, memberList);
            if (dimension.getInclusions().contains(sel)) {
                dimension.getInclusions().remove(sel);
            }
            if (memberposition < 0) {
                memberposition = dimension.getInclusions().size();
            }
            dimension.getInclusions().add(memberposition, sel);
            query.setTotalFunction(((Member)sel.getRootElement()).getLevel().getUniqueName(), totalsFunction);
            return true;
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Cannot include member query (" + queryName + ") dimension (" + dimensionName + ") member (" + uniqueMemberName + ") operator (" + selectionType + ") position " + memberposition, e);
        }
    }

    public boolean removeMember(String queryName, String dimensionName, String uniqueMemberName, String selectionType) throws SaikuServiceException {
        IQuery query = this.getIQuery(queryName);
        this.removeAllChildren(queryName, dimensionName);
        List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
        QueryDimension dimension = query.getDimension(dimensionName);
        Selection.Operator selectionMode = Selection.Operator.valueOf((String)selectionType);
        try {
            if (log.isDebugEnabled()) {
                log.debug("query: " + queryName + " remove:" + selectionMode.toString() + " " + memberList.size());
            }
            Selection selection = dimension.createSelection(selectionMode, memberList);
            dimension.getInclusions().remove(selection);
            return true;
        }
        catch (OlapException e) {
            throw new SaikuServiceException("Error removing member (" + uniqueMemberName + ") of dimension (" + dimensionName + ")", e);
        }
    }

    public boolean includeLevel(String queryName, String dimensionName, String uniqueHierarchyName, String uniqueLevelName) {
        String defaultTotalsFunction = "";
        return this.includeLevel(queryName, dimensionName, uniqueHierarchyName, uniqueLevelName, defaultTotalsFunction);
    }

    public boolean includeLevel(String queryName, String dimensionName, String uniqueHierarchyName, String uniqueLevelName, String totalsFunction) {
        IQuery query = this.getIQuery(queryName);
        this.removeAllChildren(queryName, dimensionName);
        QueryDimension dimension = query.getDimension(dimensionName);
        for (Hierarchy hierarchy : dimension.getDimension().getHierarchies()) {
            if (!hierarchy.getUniqueName().equals(uniqueHierarchyName)) continue;
            for (Level level : hierarchy.getLevels()) {
                if (!level.getUniqueName().equals(uniqueLevelName)) continue;
                Selection sel = dimension.createSelection(level);
                if (!dimension.getInclusions().contains(sel)) {
                    dimension.include(level);
                }
                query.setTotalFunction(uniqueLevelName, totalsFunction);
                return true;
            }
        }
        return false;
    }

    public boolean removeLevel(String queryName, String dimensionName, String uniqueHierarchyName, String uniqueLevelName) {
        IQuery query = this.getIQuery(queryName);
        this.removeAllChildren(queryName, dimensionName);
        QueryDimension dimension = query.getDimension(dimensionName);
        try {
            for (Hierarchy hierarchy : dimension.getDimension().getHierarchies()) {
                if (!hierarchy.getUniqueName().equals(uniqueHierarchyName)) continue;
                for (Level level : hierarchy.getLevels()) {
                    if (!level.getUniqueName().equals(uniqueLevelName)) continue;
                    Selection inclusion = dimension.createSelection(level);
                    dimension.getInclusions().remove(inclusion);
                    ArrayList<Selection> removals = new ArrayList<Selection>();
                    for (Selection sel : dimension.getInclusions()) {
                        if (!(sel.getRootElement() instanceof Member) || !((Member)sel.getRootElement()).getLevel().equals(level) || !dimension.getInclusions().contains(sel)) continue;
                        removals.add(sel);
                    }
                    dimension.getInclusions().removeAll(removals);
                }
            }
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot remove level" + uniqueLevelName + "from dimension " + dimensionName, e);
        }
        return true;
    }

    public void moveDimension(String queryName, String axisName, String dimensionName, int position) {
        try {
            Axis.Standard newAxis;
            if (log.isDebugEnabled()) {
                log.debug("move query: " + queryName + " dimension " + dimensionName + " to axis " + axisName + "  position" + position);
            }
            IQuery query = this.getIQuery(queryName);
            QueryDimension dimension = query.getDimension(dimensionName);
            Axis.Standard standard = axisName != null ? ("UNUSED".equals(axisName) ? null : Axis.Standard.valueOf((String)axisName)) : (newAxis = null);
            if (position == -1) {
                query.moveDimension(dimension, (Axis)newAxis);
            } else {
                query.moveDimension(dimension, (Axis)newAxis, position);
            }
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot move dimension:" + dimensionName + " to axis: " + axisName, e);
        }
    }

    public void removeDimension(String queryName, String axisName, String dimensionName) {
        IQuery query = this.getIQuery(queryName);
        this.moveDimension(queryName, "UNUSED", dimensionName, -1);
        query.getDimension(dimensionName).getExclusions().clear();
        query.getDimension(dimensionName).getInclusions().clear();
    }

    public List<SaikuDimensionSelection> getAxisSelection(String queryName, String axis) {
        IQuery query = this.getIQuery(queryName);
        ArrayList<SaikuDimensionSelection> dimsel = new ArrayList<SaikuDimensionSelection>();
        try {
            QueryAxis qaxis = query.getAxis(axis);
            if (qaxis != null) {
                for (QueryDimension dim : qaxis.getDimensions()) {
                    dimsel.add(ObjectUtil.convertDimensionSelection(dim, query));
                }
            }
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get dimension selections", e);
        }
        return dimsel;
    }

    public SaikuDimensionSelection getAxisDimensionSelections(String queryName, String axis, String dimension) {
        IQuery query = this.getIQuery(queryName);
        try {
            QueryAxis qaxis = query.getAxis(axis);
            if (qaxis != null) {
                QueryDimension dim = query.getDimension(dimension);
                if (dim != null) {
                    return ObjectUtil.convertDimensionSelection(dim, query);
                }
                throw new SaikuOlapException("Cannot find dimension with name:" + dimension);
            }
            throw new SaikuOlapException("Cannot find axis with name:" + axis);
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot get dimension selections", e);
        }
    }

    public void clearQuery(String queryName) {
        IQuery query = this.getIQuery(queryName);
        query.clearAllQuerySelections();
    }

    public IQuery clearAxis(String queryName, String axisName) {
        try {
            IQuery query = this.getIQuery(queryName);
            query.clearAxis(axisName);
            return query;
        }
        catch (SaikuOlapException e) {
            throw new SaikuServiceException("Cannot clear for query: " + queryName + " axis: " + axisName, e);
        }
    }

    public void clearAxisSelections(String queryName, String axisName) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            query.resetAxisSelections(qAxis);
        }
    }

    public void sortAxis(String queryName, String axisName, String sortLiteral, String sortOrder) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            SortOrder so = SortOrder.valueOf((String)sortOrder);
            qAxis.sort(so, sortLiteral);
        }
    }

    public void clearSort(String queryName, String axisName) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            qAxis.clearSort();
        }
    }

    public void limitAxis(String queryName, String axisName, String limitFunction, String n, String sortLiteral) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            LimitFunction lf = LimitFunction.valueOf((String)limitFunction);
            BigDecimal bn = new BigDecimal(n);
            qAxis.limit(lf, bn, sortLiteral);
        }
    }

    public void clearLimit(String queryName, String axisName) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            qAxis.clearLimitFunction();
        }
    }

    public void filterAxis(String queryName, String axisName, String filterCondition) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            qAxis.filter(filterCondition);
        }
    }

    public void clearFilter(String queryName, String axisName) {
        IQuery query = this.getIQuery(queryName);
        if (Axis.Standard.valueOf((String)axisName) != null) {
            QueryAxis qAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
            qAxis.clearFilter();
        }
    }

    public void resetQuery(String queryName) {
        IQuery query = this.getIQuery(queryName);
        query.resetQuery();
    }

    public void setNonEmpty(String queryName, String axisName, boolean bool) {
        IQuery query = this.getIQuery(queryName);
        QueryAxis newAxis = query.getAxis((Axis)Axis.Standard.valueOf((String)axisName));
        newAxis.setNonEmpty(bool);
    }

    public Properties setProperties(String queryName, Properties props) {
        IQuery query = this.getIQuery(queryName);
        query.setProperties(props);
        return this.getProperties(queryName);
    }

    public Properties getProperties(String queryName) {
        IQuery query = this.getIQuery(queryName);
        return query.getProperties();
    }

    public String getMDXQuery(String queryName) {
        return this.getIQuery(queryName).getMdx();
    }

    public String getQueryXml(String queryName) {
        IQuery query = this.getIQuery(queryName);
        return query.toXml();
    }

    public byte[] getExport(String queryName, String type) {
        return this.getExport(queryName, type, new FlattenedCellSetFormatter());
    }

    public byte[] getExport(String queryName, String type, String formatter) {
        switch (formatter = formatter == null ? "" : formatter.toLowerCase()) {
            case "flat": {
                return this.getExport(queryName, type, new CellSetFormatter());
            }
            case "flattened": {
                return this.getExport(queryName, type, new FlattenedCellSetFormatter());
            }
            case "hierarchical": {
                return this.getExport(queryName, type, new HierarchicalCellSetFormatter());
            }
        }
        return this.getExport(queryName, type, new FlattenedCellSetFormatter());
    }

    private byte[] getExport(String queryName, String type, ICellSetFormatter formatter) {
        if (type != null) {
            IQuery query = this.getIQuery(queryName);
            CellSet rs = query.getCellset();
            List<Object> filters = new ArrayList();
            if (query.getType().equals((Object)IQuery.QueryType.QM)) {
                filters = this.getAxisSelection(queryName, "FILTER");
            }
            if (type.equalsIgnoreCase("xls")) {
                return ExcelExporter.exportExcel(rs, formatter, null);
            }
            if (type.equalsIgnoreCase("csv")) {
                return CsvExporter.exportCsv(rs, SaikuProperties.webExportCsvDelimiter, SaikuProperties.webExportCsvTextEscape, formatter);
            }
        }
        return new byte[0];
    }

    public void qm2mdx(String queryName) {
        IQuery query = this.getIQuery(queryName);
        OlapConnection con = this.olapDiscoverService.getNativeConnection(query.getSaikuCube().getConnection());
        MdxQuery mdx = new MdxQuery(con, query.getSaikuCube(), query.getName(), this.getMDXQuery(queryName));
        this.putIQuery(queryName, mdx);
        query = null;
    }

    public SaikuTag createTag(String queryName, String tagName, List<List<Integer>> cellPositions) {
        try {
            IQuery query = this.getIQuery(queryName);
            CellSet cs = query.getCellset();
            ArrayList<SaikuTuple> tuples = new ArrayList<SaikuTuple>();
            ArrayList<SimpleCubeElement> dimensions = new ArrayList<SimpleCubeElement>();
            for (List<Integer> cellPosition : cellPositions) {
                ArrayList<Member> members = new ArrayList<Member>();
                for (int i = 0; i < cellPosition.size(); ++i) {
                    members.addAll(((Position)((CellSetAxis)cs.getAxes().get(i)).getPositions().get(cellPosition.get(i))).getMembers());
                }
                List<SaikuMember> sm = ObjectUtil.convertMembers(members);
                SaikuTuple tuple = new SaikuTuple(sm);
                tuples.add(tuple);
                if (dimensions.size() != 0) continue;
                for (Member m : members) {
                    SimpleCubeElement sd = new SimpleCubeElement(m.getDimension().getName(), m.getDimension().getUniqueName(), m.getDimension().getCaption());
                    if (dimensions.contains(sd)) continue;
                    dimensions.add(sd);
                }
            }
            List<SaikuDimensionSelection> filterSelections = this.getAxisSelection(queryName, "FILTER");
            return new SaikuTag(tagName, dimensions, tuples, filterSelections);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error addTag:" + tagName + " for query: " + queryName, e);
        }
    }

    public IQuery zoomIn(String queryName, List<List<Integer>> realPositions) {
        try {
            IQuery query = this.getIQuery(queryName);
            CellSet cs = query.getCellset();
            if (cs == null) {
                throw new SaikuServiceException("Cannot zoom in if last cellset is null");
            }
            if (realPositions == null || realPositions.size() == 0) {
                throw new SaikuServiceException("Cannot zoom in if zoom in position is empty");
            }
            HashMap memberSelection = new HashMap();
            for (List<Integer> position : realPositions) {
                for (int k = 0; k < position.size(); ++k) {
                    Position p = (Position)((CellSetAxis)cs.getAxes().get(k)).getPositions().get(position.get(k));
                    List members = p.getMembers();
                    for (Member m : members) {
                        Dimension d = m.getDimension();
                        if (!memberSelection.containsKey(d)) {
                            HashSet mset = new HashSet();
                            memberSelection.put(d, mset);
                        }
                        ((Set)memberSelection.get(d)).add(m);
                    }
                }
            }
            for (Dimension d : memberSelection.keySet()) {
                QueryDimension a = query.getDimension(d.getName());
                a.clearInclusions();
                for (Member m : (Set)memberSelection.get(d)) {
                    a.include(m);
                }
            }
            return query;
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error zoom in on query: " + queryName, e);
        }
    }

    public SaikuFilter getFilter(String queryName, String filtername, String dimensionName, String hierarchyName, String levelName) {
        try {
            QueryDimension qd;
            AbstractBaseCell[][] body;
            IQuery query = this.getIQuery(queryName);
            CellSet cs = query.getCellset();
            if (cs == null) {
                throw new SaikuServiceException("Cannot get filter of result if last cellset is null");
            }
            CellDataSet result = OlapResultSetUtil.cellSet2Matrix(cs, query.getFormatter());
            List<Object> members = new ArrayList();
            HashSet<Member> mset = new HashSet<Member>();
            Cube cube = query.getCube();
            Hierarchy h = (Hierarchy)cube.getHierarchies().get(hierarchyName);
            if (h == null) {
                throw new Exception("Cannot find hierarchy in cube " + cube.getName() + " with name " + hierarchyName);
            }
            Dimension d = h.getDimension();
            Level l = (Level)h.getLevels().get(levelName);
            if (l == null) {
                throw new Exception("Cannot find level in hierarchy " + h.getName() + " with name " + levelName);
            }
            SimpleCubeElement hierarchy = new SimpleCubeElement(h.getName(), h.getUniqueName(), h.getCaption());
            SimpleCubeElement dimension = new SimpleCubeElement(d.getName(), d.getUniqueName(), d.getCaption());
            Long start = new Date().getTime();
            AbstractBaseCell[][] headers = result.getCellSetHeaders();
            if (headers != null && headers.length > 0 && headers[0].length > 0) {
                for (AbstractBaseCell[] header : headers) {
                    for (int k = 0; k < headers[0].length; ++k) {
                        MemberCell mc;
                        if (header[k] == null || (mc = (MemberCell)header[k]).getUniqueName() == null || !mc.getHierarchy().equals(hierarchy.getUniqueName()) || !mc.getLevel().equals(l.getUniqueName())) continue;
                        String mu = mc.getUniqueName();
                        List memberList = IdentifierNode.parseIdentifier((String)mu).getSegmentList();
                        Member m = cube.lookupMember(memberList);
                        mset.add(m);
                    }
                }
            }
            Long header = new Date().getTime();
            if (mset.size() == 0 && (body = result.getCellSetBody()) != null && body.length > 0 && body[0].length > 0) {
                block4: for (AbstractBaseCell[] aBody : body) {
                    for (int k = 0; k < body[0].length; ++k) {
                        MemberCell mc;
                        if (aBody[k] == null) continue;
                        AbstractBaseCell ac = aBody[k];
                        if (ac instanceof DataCell) continue block4;
                        if (!(ac instanceof MemberCell) || (mc = (MemberCell)aBody[k]).getUniqueName() == null || !mc.getHierarchy().equals(hierarchy.getUniqueName()) || !mc.getLevel().equals(l.getUniqueName())) continue;
                        String mu = mc.getUniqueName();
                        List memberList = IdentifierNode.parseIdentifier((String)mu).getSegmentList();
                        Member m = cube.lookupMember(memberList);
                        mset.add(m);
                    }
                }
            }
            Long body2 = new Date().getTime();
            if (mset.size() == 0 && mset.size() == 0 && (qd = query.getDimension(dimensionName)) != null && qd.getAxis().getLocation() != null) {
                for (Selection sel : qd.getInclusions()) {
                    Member m;
                    if (!(sel.getRootElement() instanceof Member) || !(m = (Member)sel.getRootElement()).getLevel().getName().equals(levelName)) continue;
                    mset.add(m);
                }
            }
            Long end = new Date().getTime();
            members = ObjectUtil.convert2Simple(mset);
            Collections.sort(members, new SaikuUniqueNameComparator());
            log.debug("Create Filters: Found members in the result or query: " + members.size());
            return new SaikuFilter(filtername, null, dimension, hierarchy, members);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error getFilter:" + filtername + " for query: " + queryName, e);
        }
    }

    public Map<String, SaikuFilter> getValidFilters(String queryName, Map<String, SaikuFilter> allFilters) {
        IQuery query = this.getIQuery(queryName);
        Cube c = query.getCube();
        HashMap<String, SaikuFilter> filteredMap = new HashMap<String, SaikuFilter>();
        for (SaikuFilter sf : allFilters.values()) {
            boolean hasHierarchy;
            if (StringUtils.isBlank((String)sf.getName()) || sf.getDimension() == null) continue;
            String dimensionName = sf.getDimension().getName();
            String hierarchyName = sf.getHierarchy().getName();
            boolean hasDimension = c.getDimensions().indexOfName(dimensionName) >= 0;
            boolean bl = hasHierarchy = c.getHierarchies().indexOfName(hierarchyName) >= 0;
            if (!hasDimension && !hasHierarchy) continue;
            filteredMap.put(sf.getName(), sf);
        }
        return filteredMap;
    }

    public SaikuQuery applyFilter(String queryname, SaikuFilter filter) throws Exception {
        IQuery query = this.getIQuery(queryname);
        if (filter != null && filter.getName() != null && filter.getDimension() != null && filter.getMembers() != null) {
            query.setFilter(filter);
            QueryDimension qDim = query.getDimension(filter.getDimension().getName());
            if (qDim != null) {
                qDim.clearInclusions();
                query.moveDimension(qDim, (Axis)Axis.FILTER);
                for (SimpleCubeElement member : filter.getMembers()) {
                    List memberList = IdentifierNode.parseIdentifier((String)member.getUniqueName()).getSegmentList();
                    qDim.include(memberList);
                }
            }
        }
        return ObjectUtil.convert(query);
    }

    public SaikuQuery removeFilter(String queryname) {
        IQuery query = this.getIQuery(queryname);
        if (query != null && query.getFilter() != null) {
            SaikuFilter filter = query.getFilter();
            QueryDimension qDim = query.getDimension(filter.getDimension().getName());
            if (qDim != null) {
                qDim.clearInclusions();
                query.moveDimension(qDim, null);
            }
            query.removeFilter();
        }
        return ObjectUtil.convert(query);
    }

    public void setTag(String queryName, SaikuTag tag) {
        IQuery query = this.getIQuery(queryName);
        query.setTag(tag);
    }

    public void disableTag(String queryName) {
        IQuery query = this.getIQuery(queryName);
        query.removeTag();
    }

    private void putIQuery(String queryName, IQuery query) {
        this.queries.put(queryName, query);
    }

    private void removeIQuery(String queryName) {
        if (this.queries.containsKey(queryName)) {
            IQuery q = this.queries.remove(queryName);
            try {
                q.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object var2_2 = null;
        }
    }

    private IQuery getIQuery(String queryName) {
        if (this.queries.containsKey(queryName)) {
            return this.queries.get(queryName);
        }
        throw new SaikuServiceException("No query found using name: " + queryName);
    }

    private Map<String, IQuery> getIQueryMap() {
        return this.queries;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.serializableQueries = new HashMap<String, String>();
        for (Map.Entry<String, IQuery> entry : this.queries.entrySet()) {
            this.serializableQueries.put(entry.getKey(), new QuerySerializer(entry.getValue()).createXML());
        }
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.queries = new HashMap<String, IQuery>();
        for (Map.Entry<String, String> entry : this.serializableQueries.entrySet()) {
            this.createNewOlapQuery(entry.getKey(), entry.getValue());
        }
        this.serializableQueries = null;
    }
}

