/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query2;

import com.his.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.query2.ThinLevel;
import org.saiku.olap.query2.ThinQueryModel;
import org.saiku.olap.query2.util.ServiceUtil;
import org.saiku.service.util.ISaikuQuery;

public class ThinQuery
implements ISaikuQuery {
    private ThinQueryModel queryModel;
    private SaikuCube cube;
    private String mdx;
    private String name;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> plugins = new HashMap<String, String>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, String> metadata = new HashMap<String, String>();
    private String queryType = "OLAP";
    private Type type;

    public ThinQuery() {
    }

    public ThinQuery(String name, SaikuCube cube) {
        this(name, cube, new ThinQueryModel());
    }

    public ThinQuery(String name, SaikuCube cube, ThinQueryModel queryModel) {
        this.queryModel = queryModel;
        this.type = Type.QUERYMODEL;
        this.cube = cube;
        this.name = name;
    }

    public ThinQuery(String name, SaikuCube cube, String mdx) {
        this.mdx = mdx;
        this.type = Type.MDX;
        this.cube = cube;
        this.name = name;
    }

    public ThinQueryModel getQueryModel() {
        return this.queryModel;
    }

    public void setQueryModel(ThinQueryModel queryModel) {
        this.queryModel = queryModel;
        if (queryModel != null) {
            this.type = Type.QUERYMODEL;
        }
    }

    public SaikuCube getCube() {
        return this.cube;
    }

    public void setCube(SaikuCube cube) {
        this.cube = cube;
    }

    public String getMdx() {
        return this.mdx;
    }

    @JsonIgnore
    public String getParameterResolvedMdx() {
        String replacedMdx = this.mdx;
        if (this.parameters != null) {
            replacedMdx = ServiceUtil.replaceParameters(replacedMdx, this.parameters);
        }
        return replacedMdx;
    }

    public void setMdx(String mdx) {
        this.mdx = mdx;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getParameter(String parameter) {
        if (this.parameters.containsKey(parameter)) {
            return this.parameters.get(parameter);
        }
        return null;
    }

    public void addParameter(String parameter) {
        if (StringUtils.isNotBlank((String)parameter) && !this.parameters.containsKey(parameter)) {
            this.parameters.put(parameter, null);
        }
    }

    public void addParameters(List<String> parameters) {
        if (parameters != null) {
            for (String param : parameters) {
                this.addParameter(param);
            }
        }
    }

    public boolean hasAggregators() {
        return Type.QUERYMODEL.equals((Object)this.type) && this.queryModel != null && this.queryModel.hasAggregators();
    }

    public Map<String, String> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Map<String, String> plugins) {
        this.plugins = plugins;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    @JsonIgnore
    public ThinLevel getLevel(String name) {
        return this.getQueryModel().getLevel(name);
    }

    public static enum Type {
        MDX,
        QUERYMODEL;

    }
}

