/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.dto.resultset;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.saiku.olap.dto.resultset.AbstractBaseCell;
import org.saiku.olap.dto.resultset.DataCell;
import org.saiku.olap.dto.resultset.MemberCell;

public class Matrix {
    private final Map<List<Integer>, AbstractBaseCell> map = new HashMap<List<Integer>, AbstractBaseCell>();
    private int width = 0;
    private int height = 0;
    private int offset = 0;
    private final Set<Integer> xAxis = new HashSet<Integer>();
    private final Set<Integer> yAxis = new HashSet<Integer>();

    public Matrix() {
    }

    public Matrix(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void set(int x, int y, DataCell cell) {
        this.map.put(Arrays.asList(x, y), cell);
        this.addCoordinates(x, y);
        assert (x >= 0 && x < this.width) : x;
        assert (y >= 0 && y < this.height) : y;
    }

    public void set(int x, int y, MemberCell value) {
        this.map.put(Arrays.asList(x, y), value);
        this.addCoordinates(x, y);
        assert (x >= 0 && x < this.width) : x;
        assert (y >= 0 && y < this.height) : y;
    }

    public AbstractBaseCell get(int x, int y) {
        return this.map.get(Arrays.asList(x, y));
    }

    public int getMatrixWidth() {
        return this.xAxis.size();
    }

    public int getMatrixHeight() {
        return this.yAxis.size();
    }

    public Map<List<Integer>, AbstractBaseCell> getMap() {
        return this.map;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    private void addCoordinates(Integer x, Integer y) {
        this.xAxis.add(x);
        this.yAxis.add(y);
    }

    public boolean containsY(Integer yCoordinate) {
        return this.yAxis.contains(yCoordinate);
    }

    public boolean containsX(Integer xCoordinate) {
        return this.xAxis.contains(xCoordinate);
    }
}

