/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.editor;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaStatement;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import java.util.Iterator;

public class CodePositionTraverser
extends AbstractElementVisitor {
    private final int refColumn;
    private final int refLine;
    private MetaElement metaElement = null;

    public CodePositionTraverser(MetaProgram program, int refLine, int refColumn) {
        this.refLine = refLine;
        this.refColumn = refColumn;
        program.accept(this);
    }

    @Override
    public void visitProgram(MetaProgram aProgram) {
        aProgram.statements().accept(this);
    }

    @Override
    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        if (this.isPositionInElement(aStatement)) {
            this.metaElement = aStatement;
        }
        aStatement.ifTrue().accept(this);
        aStatement.ifFalse().accept(this);
    }

    @Override
    public void visitWhileLoop(MetaWhileLoop aStatement) {
        if (this.isPositionInElement(aStatement)) {
            this.metaElement = aStatement;
        }
        aStatement.loopBody().accept(this);
    }

    @Override
    public void visitForEachLoop(MetaForEachLoop aStatement) {
        if (this.isPositionInElement(aStatement)) {
            this.metaElement = aStatement;
        }
        aStatement.loopBody().accept(this);
    }

    @Override
    public void visitForNextLoop(MetaForNextLoop aStatement) {
        if (this.isPositionInElement(aStatement)) {
            this.metaElement = aStatement;
        }
        aStatement.loopBody().accept(this);
    }

    @Override
    public void visitStatementSequence(MetaStatementSequence aSequence) {
        if (this.isPositionInElement(aSequence)) {
            this.metaElement = aSequence;
        }
        Iterator iterator = aSequence.statements();
        while (iterator.hasNext()) {
            MetaStatement statement = (MetaStatement)iterator.next();
            statement.accept(this);
        }
    }

    private boolean isPositionInElement(MetaElement element) {
        boolean result = false;
        if (element.startLine() <= this.refLine) {
            result = true;
        }
        if (element.startLine() == this.refLine && element.startColumn() < this.refColumn) {
            result = true;
        }
        if (element.endLine() < this.refLine) {
            result = false;
        }
        return result;
    }

    public MetaElement getMetaElement() {
        return this.metaElement;
    }
}

