/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.parser.Tags;
import de.statspez.pleditor.generator.xml.AbstractXmlGenerator;
import de.statspez.pleditor.generator.xml.MetaToXmlConverter;
import java.io.PrintStream;

public class MerkmalXmlGenerator
extends AbstractXmlGenerator {
    public void printMerkmal(PrintStream out, MetaMerkmal merkmal, String indentation) throws Exception {
        out.print(indentation + "<" + Tags.printTag("statisticVariable"));
        this.printAttribut(out, "name", merkmal.getName());
        this.printAttribut(out, "id", merkmal.getId());
        this.printAttribut(out, "state", this.state(merkmal.getFreigabeStatus()));
        this.printAttribut(out, "type", MetaToXmlConverter.getFieldtype(merkmal.getTyp()));
        this.printAttribut(out, "length", String.valueOf(merkmal.getLaenge()));
        this.printAttribut(out, "mask", merkmal.getMaske());
        MetaAuspraegungsgruppe apg = merkmal.getKlasseFehlwerte();
        this.printAttribut(out, "missing-values-class", apg != null ? apg.getName() : "");
        this.printAttribut(out, "missing-values-class-id", apg != null ? apg.getId() : "");
        apg = merkmal.getKlasseWertebereich();
        this.printAttribut(out, "classifikation-class", apg != null ? apg.getName() : "");
        this.printAttribut(out, "classifikation-class-id", apg != null ? apg.getId() : "");
        this.printAttribut(out, "empty_allowed", merkmal.getLeer() ? "1" : "0");
        this.printAttribut(out, "resist_allowed", merkmal.getVerweigerung() ? "1" : "0");
        this.printAttribut(out, "uncnown_allowed", merkmal.getNichtWissen() ? "1" : "0");
        out.println(">");
        String ab1 = this.indentation(indentation, 1);
        this.printProperties(out, merkmal, ab1);
        this.printObjectContext(out, merkmal, ab1);
        this.printPCDATA(out, Tags.printTag("values"), merkmal.getWertebereich(), ab1, true);
        this.printPCDATA(out, Tags.printTag("question"), merkmal.getFrage(), ab1);
        this.printPCDATA(out, Tags.printTag("displayName"), merkmal.getBezeichnung(), ab1);
        this.printPCDATA(out, Tags.printTag("tooltip"), merkmal.getTooltip(), ab1);
        this.printPCDATA(out, Tags.printTag("explanation"), merkmal.getBeschreibung(), ab1);
        this.printPCDATA(out, Tags.printTag("errorShort"), merkmal.getFehlertextKurz(), ab1);
        this.printPCDATA(out, Tags.printTag("errorLong"), merkmal.getFehlertextLang(), ab1);
        this.printPCDATA(out, Tags.printTag("correctionDescription"), merkmal.getKorrekturhinweis(), ab1);
        out.println(indentation + "</" + Tags.printTag("statisticVariable") + ">");
    }
}

