/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.parser.Tags;
import de.statspez.pleditor.generator.xml.AbstractXmlGenerator;
import java.io.PrintStream;
import java.util.Iterator;

public class AuspraegungsgruppeXmlGenerator
extends AbstractXmlGenerator {
    public void printAuspraegungsgruppe(PrintStream out, MetaAuspraegungsgruppe apg, String indentation) throws Exception {
        out.print(indentation + "<" + Tags.printTag("classification"));
        this.printAttribut(out, "id", apg.getId());
        this.printAttribut(out, "name", apg.getName());
        this.printAttribut(out, "state", this.state(apg.getFreigabeStatus()));
        this.printAttribut(out, "code-type", "string");
        this.printAttribut(out, "value-type", "string");
        out.println(">");
        this.printProperties(out, apg, this.indentation(indentation, 1));
        this.printObjectContext(out, apg, this.indentation(indentation, 1));
        this.printAuspraegungen(out, apg.getAuspraegungsComps().getAuspraegungen(), this.indentation(indentation, 1), 1);
        out.println(indentation + "</" + Tags.printTag("classification") + ">");
    }

    private void printAuspraegungen(PrintStream out, Iterator auspraegungen, String indentation, int stufe) {
        if (auspraegungen != null) {
            String kode = null;
            while (auspraegungen.hasNext()) {
                MetaCustomAuspraegung auspraegung = (MetaCustomAuspraegung)auspraegungen.next();
                kode = auspraegung.getKode();
                if (kode == null) continue;
                out.print(indentation + "<" + Tags.printTag("classificationElement"));
                out.println(">");
                this.printPCDATA(out, Tags.printTag("classificationCode"), kode, this.indentation(indentation, 1));
                this.printPCDATA(out, Tags.printTag("classificationValue"), auspraegung.getName(), this.indentation(indentation, 1));
                this.printPCDATA(out, Tags.printTag("displayName"), auspraegung.getBezeichnung(), this.indentation(indentation, 1));
                this.printPCDATA(out, Tags.printTag("tooltip"), auspraegung.getTooltip(), this.indentation(indentation, 1));
                this.printPCDATA(out, Tags.printTag("classificationTextShort"), auspraegung.getKurztext(), this.indentation(indentation, 1));
                this.printPCDATA(out, Tags.printTag("classificationText"), auspraegung.getLangtext(), this.indentation(indentation, 1));
                this.printAuspraegungen(out, auspraegung.getAuspraegungen(), this.indentation(indentation, 1), stufe + 1);
                out.println(indentation + "</" + Tags.printTag("classificationElement") + ">");
            }
        }
    }
}

