/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.parser.SSPTags;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class AbstractXmlGenerator {
    protected static final String DEFAULT_INDENTATION_STEP = "  ";
    private Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 != null && o2 != null && o1 instanceof MetaStatspezObjekt && o2 instanceof MetaStatspezObjekt && ((MetaStatspezObjekt)o1).getName() != null && ((MetaStatspezObjekt)o2).getName() != null) {
                String name2;
                String name1 = ((MetaStatspezObjekt)o1).getName();
                if (name1.equals(name2 = ((MetaStatspezObjekt)o2).getName())) {
                    String kontext1 = ((MetaStatspezObjekt)o1).getMetaObjectContext().getObjectPakage();
                    String kontext2 = ((MetaStatspezObjekt)o2).getMetaObjectContext().getObjectPakage();
                    return kontext1.compareTo(kontext2);
                }
                return name1.compareTo(name2);
            }
            if (o1 != null && o2 != null && o1 instanceof MetaRawDataSet && o2 instanceof MetaRawDataSet && ((MetaRawDataSet)o1).getName() != null && ((MetaRawDataSet)o2).getName() != null) {
                return ((MetaRawDataSet)o1).getName().compareTo(((MetaRawDataSet)o2).getName());
            }
            if (o1 != null && o2 != null && o1 instanceof MetaTBMaterialReferenz && o2 instanceof MetaTBMaterialReferenz && ((MetaTBMaterialReferenz)o1).getName() != null && ((MetaTBMaterialReferenz)o2).getName() != null) {
                return ((MetaTBMaterialReferenz)o1).getName().compareTo(((MetaTBMaterialReferenz)o2).getName());
            }
            return 0;
        }
    };

    protected AbstractXmlGenerator() {
    }

    protected String indentation(String indentation, int steps) {
        if (indentation != null) {
            for (int i = 0; i < steps; ++i) {
                indentation = indentation + DEFAULT_INDENTATION_STEP;
            }
        }
        return indentation;
    }

    protected String escapeStringXML(String inputString) {
        String erg = "";
        if (inputString != null) {
            erg = inputString;
            if (inputString.indexOf(38) >= 0 || inputString.indexOf(60) >= 0 || inputString.indexOf(62) >= 0 || inputString.indexOf(35) >= 0) {
                StringBuffer buffer = new StringBuffer(inputString.length() + 20);
                for (int i = 0; i < inputString.length(); ++i) {
                    if (inputString.charAt(i) == '&') {
                        buffer.append("&amp;");
                        continue;
                    }
                    if (inputString.charAt(i) == '<') {
                        buffer.append("&lt;");
                        continue;
                    }
                    if (inputString.charAt(i) == '>') {
                        buffer.append("&gt;");
                        continue;
                    }
                    if (inputString.charAt(i) == '#') {
                        buffer.append("&#35;");
                        continue;
                    }
                    buffer.append(inputString.charAt(i));
                }
                erg = buffer.toString();
            }
        }
        return erg;
    }

    protected String generateIds(Iterator list) {
        StringBuffer buf = new StringBuffer();
        while (list != null && list.hasNext()) {
            MetaStatspezObjekt metaStatspezObjekt = (MetaStatspezObjekt)list.next();
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(metaStatspezObjekt.getId());
        }
        return buf.toString();
    }

    protected String generateNamen(Iterator list) {
        StringBuffer buf = new StringBuffer();
        if (list != null && list.hasNext()) {
            while (list.hasNext()) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(((MetaStatspezObjekt)list.next()).getName());
            }
        }
        return buf.toString();
    }

    protected void printAttribut(PrintStream out, String name, String value) {
        String attrValue;
        if (value == null) {
            attrValue = "";
        } else if (value.indexOf(38) >= 0 || value.indexOf(60) >= 0 || value.indexOf(62) >= 0 || value.indexOf(35) >= 0 || value.indexOf(34) >= 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == '&') {
                    buffer.append("&amp;");
                    continue;
                }
                if (value.charAt(i) == '<') {
                    buffer.append("&lt;");
                    continue;
                }
                if (value.charAt(i) == '>') {
                    buffer.append("&gt;");
                    continue;
                }
                if (value.charAt(i) == '#') {
                    buffer.append("&#35;");
                    continue;
                }
                if (value.charAt(i) == '\"') {
                    buffer.append("&quot;");
                    continue;
                }
                buffer.append(value.charAt(i));
            }
            attrValue = buffer.toString();
        } else {
            attrValue = value;
        }
        out.print(" " + name + "=\"" + attrValue + "\"");
    }

    protected void printCDATA(PrintStream out, String elName, String elValue, String indentation) {
        if (elName != null && indentation != null) {
            if (elValue == null) {
                elValue = "";
            }
            out.println(indentation + "<" + elName + ">\n<![CDATA[");
            out.print(elValue);
            out.println("\n]]>\n" + indentation + "</" + elName + ">");
        }
    }

    protected void printContext(PrintStream out, String indentation, MetaCustomPLMaterial plMaterial) {
        String periodizitaet = null;
        String identifikation = null;
        if (plMaterial.istErhebung()) {
            periodizitaet = plMaterial.getPeriodizitaet();
            identifikation = plMaterial.getIdentifikation();
        }
        out.println(indentation + "<" + SSPTags.printTag("context") + ">");
        out.print(this.indentation(indentation, 1) + "<" + SSPTags.printTag("survey"));
        this.printAttribut(out, "id", identifikation);
        out.println(">");
        if (plMaterial.getEVASNr() != null) {
            out.print(this.indentation(indentation, 2) + "<" + SSPTags.printTag("surveyID") + " class=\"EVAS\">");
            out.print(plMaterial.getEVASNr());
            out.println("</" + SSPTags.printTag("surveyID") + ">");
        }
        if (plMaterial.getExternerName() != null) {
            this.printPCDATA(out, "surveyName", plMaterial.getExternerName(), this.indentation(indentation, 2));
        }
        if (plMaterial.getBZR() != null) {
            out.println(this.indentation(indentation, 2) + "<" + SSPTags.printTag("referencePeriod") + ">");
            out.println(this.indentation(indentation, 3) + "<" + SSPTags.printTag("dateTime") + ">");
            out.println(this.indentation(indentation, 4) + "<" + SSPTags.printTag("year") + ">" + plMaterial.getBZR() + "</" + SSPTags.printTag("year") + ">");
            out.println(this.indentation(indentation, 3) + "</" + SSPTags.printTag("dateTime") + ">");
            out.println(this.indentation(indentation, 2) + "</" + SSPTags.printTag("referencePeriod") + ">");
        }
        if (periodizitaet != null && periodizitaet.trim().length() > 0) {
            out.println(this.indentation(indentation, 2) + "<" + SSPTags.printTag("periodicity") + ">");
            out.println(this.indentation(indentation, 4) + "<" + SSPTags.printTag("years") + ">" + periodizitaet + "</" + SSPTags.printTag("years") + ">");
            out.println(this.indentation(indentation, 2) + "</" + SSPTags.printTag("periodicity") + ">");
        }
        out.println(this.indentation(indentation, 1) + "</" + SSPTags.printTag("survey") + ">");
        out.println(indentation + "</" + SSPTags.printTag("context") + ">");
    }

    protected void printIdNameStateAttribute(PrintStream out, MetaStatspezObjekt metaObjekt) {
        this.printAttribut(out, "id", metaObjekt.getId());
        this.printAttribut(out, "name", metaObjekt.getName());
        this.printAttribut(out, "state", this.state(metaObjekt.getFreigabeStatus()));
    }

    protected void printLeeresContext(PrintStream out, String indentation) {
        out.println(indentation + "<" + SSPTags.printTag("context") + ">");
        out.println(indentation + DEFAULT_INDENTATION_STEP + "<" + SSPTags.printTag("survey") + "/>");
        out.println(indentation + "</" + SSPTags.printTag("context") + ">");
    }

    protected void printLeeresProperties(PrintStream out, String indentation) {
        out.println(indentation + "<" + SSPTags.printTag("properties") + ">");
        out.println(indentation + "</" + SSPTags.printTag("properties") + ">");
    }

    protected void printNameIdStateAttribute(PrintStream out, MetaStatspezObjekt metaObjekt) {
        this.printAttribut(out, "name", metaObjekt.getName());
        this.printAttribut(out, "id", metaObjekt.getId());
        this.printAttribut(out, "state", this.state(metaObjekt.getFreigabeStatus()));
    }

    protected void printNameStateIdAttribute(PrintStream out, MetaStatspezObjekt metaObjekt) {
        this.printAttribut(out, "name", metaObjekt.getName());
        this.printAttribut(out, "state", this.state(metaObjekt.getFreigabeStatus()));
        this.printAttribut(out, "id", metaObjekt.getId());
    }

    protected void printObjectContext(PrintStream out, MetaStatspezObjekt material, String indentation) {
        out.println(indentation + "<" + SSPTags.printTag("objectContext") + ">");
        out.println(this.indentation(indentation, 1) + "<" + SSPTags.printTag("this") + ">");
        String ab2 = this.indentation(indentation, 2);
        out.print(ab2 + "<" + SSPTags.printTag("objectID") + " " + "class" + "=\"\">");
        out.print(this.escapeStringXML(material.getMetaObjectContext().getObjectID()));
        out.println("</" + SSPTags.printTag("objectID") + ">");
        out.print(ab2 + "<" + SSPTags.printTag("objectName") + " " + "class" + "=\"\">");
        out.print(this.escapeStringXML(material.getName()));
        out.println("</" + SSPTags.printTag("objectName") + ">");
        this.printPCDATA(out, SSPTags.printTag("objectPackage"), material.getMetaObjectContext().getObjectPakage(), ab2);
        String className = material.getMetaObjectContext().getObjectClass();
        this.printPCDATA(out, SSPTags.printTag("objectClass"), className, ab2);
        out.print(ab2 + "<" + SSPTags.printTag("objectVersion") + " " + "class" + "=\"\">");
        out.print("1");
        out.println("</" + SSPTags.printTag("objectVersion") + ">");
        out.println(this.indentation(indentation, 1) + "</" + SSPTags.printTag("this") + ">");
        out.println(indentation + "</" + SSPTags.printTag("objectContext") + ">");
    }

    protected void printPCDATA(PrintStream out, String elName, String elValue, String indentation) {
        this.printPCDATA(out, elName, elValue, indentation, false);
    }

    protected void printPCDATA(PrintStream out, String elName, String elValue, String indentation, boolean printEmptyTag) {
        if (out == null) {
            throw new IllegalArgumentException("Ausgabeobjekt nicht angegeben");
        }
        if (elName == null || elName.length() == 0) {
            throw new IllegalArgumentException("Name des Elementes nicht angegeben");
        }
        if (indentation == null) {
            throw new IllegalArgumentException("Einr\u00fcckung des Elementes nicht angegeben");
        }
        if (printEmptyTag || elValue != null && elValue.length() > 0) {
            out.print(indentation + "<" + elName + ">");
            out.print(this.escapeStringXML(elValue));
            out.println("</" + elName + ">");
        }
    }

    protected void printProperties(PrintStream out, MetaStatspezObjekt material, String indentation) {
        String eigentuemer;
        String ab2 = this.indentation(indentation, 2);
        out.println(indentation + "<" + SSPTags.printTag("properties") + ">");
        if (material.getBeschreibung() != null) {
            out.println(this.indentation(indentation, 1) + "<" + SSPTags.printTag("about") + ">");
            this.printPCDATA(out, SSPTags.printTag("description"), material.getBeschreibung(), ab2);
            out.println(this.indentation(indentation, 1) + "</" + SSPTags.printTag("about") + ">");
        }
        if ((eigentuemer = material.getCreateUser()) != null) {
            out.println(this.indentation(indentation, 1) + "<" + SSPTags.printTag("author") + ">");
            this.printPCDATA(out, SSPTags.printTag("fullName"), eigentuemer, ab2);
            out.println(this.indentation(indentation, 1) + "</" + SSPTags.printTag("author") + ">");
        }
        Date date = new Date();
        out.println(this.indentation(indentation, 1) + "<" + SSPTags.printTag("date") + ">");
        this.printZeitPunkt(out, ab2, SSPTags.printTag("year"), date);
        this.printZeitPunkt(out, ab2, SSPTags.printTag("month"), date);
        this.printZeitPunkt(out, ab2, SSPTags.printTag("day"), date);
        out.println(this.indentation(indentation, 1) + "</" + SSPTags.printTag("date") + ">");
        out.println(this.indentation(indentation, 1) + "<" + SSPTags.printTag("time") + ">");
        this.printZeitPunkt(out, ab2, SSPTags.printTag("hours"), date);
        this.printZeitPunkt(out, ab2, SSPTags.printTag("minutes"), date);
        this.printZeitPunkt(out, ab2, SSPTags.printTag("seconds"), date);
        out.println(this.indentation(indentation, 1) + "</" + SSPTags.printTag("time") + ">");
        if (material.getKommentar() != null) {
            this.printPCDATA(out, SSPTags.printTag("annotation"), material.getKommentar(), this.indentation(indentation, 1));
        }
        out.println(indentation + "</" + SSPTags.printTag("properties") + ">");
    }

    protected void printZeitPunkt(PrintStream out, String indentation, String element, Date date) {
        if (out == null || indentation == null || element == null || date == null) {
            return;
        }
        String formatter = null;
        if (element.equals(SSPTags.printTag("year"))) {
            formatter = "yyyy";
        } else if (element.equals(SSPTags.printTag("month"))) {
            formatter = "MM";
        } else if (element.equals(SSPTags.printTag("day"))) {
            formatter = "dd";
        } else if (element.equals(SSPTags.printTag("hours"))) {
            formatter = "HH";
        } else if (element.equals(SSPTags.printTag("minutes"))) {
            formatter = "mm";
        } else if (element.equals(SSPTags.printTag("seconds"))) {
            formatter = "ss";
        }
        if (formatter != null) {
            out.print(indentation + "<" + element + ">");
            SimpleDateFormat zeit_formatter = new SimpleDateFormat(formatter, Locale.GERMANY);
            String str = zeit_formatter.format(date);
            out.print(str);
            out.println("</" + element + ">");
        }
    }

    protected List sort(Iterator it) {
        ArrayList list = new ArrayList();
        while (it != null && it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, this.comparator);
        return list;
    }

    protected String state(short state) {
        String erg = "locked";
        if (state == 1) {
            erg = "approved";
        }
        return erg;
    }
}

