/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.test.ExpectedPlausiError;
import de.statspez.pleditor.generator.runtime.test.PlausiTestCase;
import de.statspez.pleditor.generator.runtime.test.TestFailure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PlausiTestCaseResult {
    private PlausiTestCase testCase;
    private List failures;

    public PlausiTestCaseResult(PlausiTestCase testCase) {
        this.testCase = testCase;
        this.failures = new ArrayList();
    }

    public void addFailure(TestFailure failure) {
        this.failures.add(failure);
    }

    public void handlePlausiResult(PlausiFehler[] errors, String context) {
        ArrayList<String> foundedErrorIds = new ArrayList<String>();
        Iterator expectedErrorIterator = this.testCase.getExpectedErrors(context);
        for (int i = 0; i < errors.length; ++i) {
            ExpectedPlausiError currentExpectedError;
            PlausiFehler error = errors[i];
            foundedErrorIds.add(error.getFehlerId());
            ExpectedPlausiError expectedError = null;
            if (expectedErrorIterator.hasNext() && (currentExpectedError = (ExpectedPlausiError)expectedErrorIterator.next()).getId().equals(error.getFehlerId())) {
                expectedError = currentExpectedError;
            }
            if (expectedError == null) {
                this.addFailure(new TestFailure(this.testCase.getName(), context, 2, error.getFehlerId()));
                continue;
            }
            if (expectedError.getInfoType() >= 0 && error.getFehlerInfoTyp() != expectedError.getInfoType()) {
                this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 1, expectedError.getInfoType() + "", error.getFehlerInfoTyp() + ""));
            }
            if (expectedError.getTextShort() != null && this.isDifferent(error.getFehlertextKurz(), expectedError.getTextShort())) {
                this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 2, expectedError.getTextShort(), error.getFehlertextKurz()));
            }
            if (expectedError.getTextLong() != null && this.isDifferent(error.getFehlertextLang(), expectedError.getTextLong())) {
                this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 3, expectedError.getTextLong(), error.getFehlertextLang()));
            }
            if (expectedError.getCorrectionAdvice() != null && this.isDifferent(error.getFehlerKorrekturhinweis(), expectedError.getCorrectionAdvice())) {
                this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 4, expectedError.getCorrectionAdvice(), error.getFehlerKorrekturhinweis()));
            }
            if (expectedError.isCheckRuntimeException()) {
                String runtimeExceptionClass;
                if (expectedError.getRuntimeExceptionClass() != null) {
                    if (error.getLaufzeitException() == null) {
                        this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 5, expectedError.getRuntimeExceptionClass(), ""));
                    } else {
                        runtimeExceptionClass = error.getLaufzeitException().getClass().getName();
                        if (this.isDifferent(runtimeExceptionClass, expectedError.getRuntimeExceptionClass())) {
                            this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 6, expectedError.getRuntimeExceptionClass(), runtimeExceptionClass));
                        }
                        if (expectedError.getRuntimeExceptionMessage() != null && this.isDifferent(error.getLaufzeitException().getMessage(), expectedError.getRuntimeExceptionMessage())) {
                            this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 7, expectedError.getRuntimeExceptionMessage(), error.getLaufzeitException().getMessage()));
                        }
                    }
                } else if (error.getLaufzeitException() != null) {
                    runtimeExceptionClass = error.getLaufzeitException().getClass().toString();
                    this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 6, "", runtimeExceptionClass));
                    if (error.getLaufzeitException().getMessage() != null && error.getLaufzeitException().getMessage().length() > 0) {
                        this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 7, "", error.getLaufzeitException().getMessage()));
                    }
                }
            }
            if (expectedError.isCheckReferenceField()) {
                if (expectedError.getReferenceField() != null && expectedError.getReferenceField().length() > 0) {
                    if (error.getReferenzFeld() != null) {
                        if (!this.getFieldName(error.getReferenzFeld()).equals(expectedError.getReferenceField())) {
                            this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 8, expectedError.getReferenceField(), this.getFieldName(error.getReferenzFeld())));
                        }
                    } else {
                        this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 8, expectedError.getReferenceField(), ""));
                    }
                } else if (error.getReferenzFeld() != null) {
                    this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 8, "", this.getFieldName(error.getReferenzFeld())));
                }
            }
            if (!expectedError.isCheckUsedFields()) continue;
            if (expectedError.getUsedFields() != null) {
                List usedFields = expectedError.getUsedFields();
                FeldDeskriptorInterface[] felder = error.getFelder();
                int usedFieldCounter = 0;
                if (felder != null) {
                    int feldCounter;
                    for (feldCounter = 0; feldCounter < felder.length && usedFieldCounter < usedFields.size(); ++feldCounter, ++usedFieldCounter) {
                        if (this.getFieldName(felder[feldCounter]).equals((String)usedFields.get(usedFieldCounter))) continue;
                        this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 9, (String)usedFields.get(usedFieldCounter), this.getFieldName(felder[feldCounter])));
                    }
                    while (feldCounter < felder.length) {
                        this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 9, "", this.getFieldName(felder[feldCounter])));
                        ++feldCounter;
                    }
                }
                while (usedFieldCounter < usedFields.size()) {
                    this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 9, (String)usedFields.get(usedFieldCounter), ""));
                    ++usedFieldCounter;
                }
                continue;
            }
            FeldDeskriptorInterface[] felder = error.getFelder();
            for (int feldCounter = 0; feldCounter < felder.length; ++feldCounter) {
                this.addFailure(new TestFailure(this.testCase.getName(), context, 4, error.getFehlerId(), 9, "", this.getFieldName(felder[feldCounter])));
            }
        }
        Iterator iter = this.testCase.getExpectedErrors(context);
        while (iter.hasNext()) {
            ExpectedPlausiError expectedError = (ExpectedPlausiError)iter.next();
            if (foundedErrorIds.contains(expectedError.getId())) continue;
            this.addFailure(new TestFailure(this.testCase.getName(), context, 3, expectedError.getId()));
        }
    }

    private boolean isDifferent(String string1, String string2) {
        boolean result = !(string1 != null && string1.length() != 0 || string2 != null && string2.length() != 0) ? false : (string1 != null && string2 != null ? !string1.equals(string2) : true);
        return result;
    }

    private String getFieldName(FeldDeskriptorInterface field) {
        StringBuffer result = new StringBuffer();
        if (field.getVorgaenger() != null) {
            result.append(this.getFieldName(field.getVorgaenger()));
            result.append('.');
        }
        result.append(field.getFeldNameTB());
        if (field.getIndizes() != null && field.getIndizes().length > 0) {
            for (int i = 0; i < field.getIndizes().length; ++i) {
                result.append('[');
                result.append(field.getIndizes()[i]);
                result.append(']');
            }
        }
        return result.toString();
    }

    public PlausiTestCase getTestCase() {
        return this.testCase;
    }

    public boolean isFailed() {
        return !this.failures.isEmpty();
    }

    public int getFailuresCount() {
        return this.failures.size();
    }

    public Iterator getFailures() {
        return this.failures.iterator();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isFailed()) {
            Iterator iter = this.getFailures();
            while (iter.hasNext()) {
                buffer.append(iter.next());
            }
        }
        buffer.append('[');
        buffer.append(this.getTestCase().getName());
        buffer.append("] ");
        buffer.append(this.getFailuresCount());
        buffer.append(" Fehler festgestellt.");
        return buffer.toString();
    }
}

