/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.BasePlausi;
import de.statspez.pleditor.generator.runtime.DefaultLogger;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.PlausiDescriptor;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.test.MockSatzInterface;

public class Invocation {
    public static void main(String[] args) {
        int rc = 0;
        try {
            if (args.length < 2) {
                System.err.println("Ungueltige Anzahl von Parametern!");
                rc = 1;
            } else {
                BasePlausi plausi = Invocation.createPlausiInstance(args[0]);
                PlausiKontext kontext = new PlausiKontext();
                String callType = args[1];
                if (callType.equals("ablauf")) {
                    rc = Invocation.mainForAblauf(args, plausi, kontext);
                } else if (callType.equals("standard")) {
                    rc = Invocation.mainForStandard(args, plausi, kontext);
                } else if (callType.equals("feld")) {
                    rc = Invocation.mainForFeld(args, plausi, kontext);
                } else {
                    System.err.println("Ungueltiger Parameter " + args[1]);
                    rc = 1;
                }
                if (rc == 0) {
                    Invocation.printPlausiResult(plausi, kontext);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            rc = 1;
        }
    }

    private static int mainForAblauf(String[] args, BasePlausi plausi, PlausiKontext kontext) {
        int rc = 0;
        PlausiDescriptor.FlowInfo ablaufInfo = plausi.plausiDescriptor().flow(args[2]);
        if (ablaufInfo == null) {
            System.err.println("Der Ablauf " + args[2] + " ist fuer diese Plausibilisierung nicht definiert.");
            rc = 1;
        } else {
            rc = Invocation.executeAblauf(args, 3, plausi, kontext, ablaufInfo);
        }
        return rc;
    }

    private static int mainForStandard(String[] args, BasePlausi plausi, PlausiKontext kontext) {
        int rc = 0;
        PlausiDescriptor.FlowInfo ablaufInfo = plausi.plausiDescriptor().standardFlow();
        if (ablaufInfo == null) {
            System.err.println("Fuer diese Plausibilsierung ist kein Standard-Ablauf definiert.");
            rc = 1;
        } else {
            rc = Invocation.executeAblauf(args, 2, plausi, kontext, ablaufInfo);
        }
        return rc;
    }

    private static int executeAblauf(String[] args, int initWerteOffset, BasePlausi plausi, PlausiKontext kontext, PlausiDescriptor.FlowInfo ablaufInfo) {
        int rc = 0;
        Object[] initwerte = new Object[ablaufInfo.paramTypes.length];
        rc = Invocation.convertInputParameters(args, ablaufInfo.paramTypes, initwerte, initWerteOffset);
        if (rc == 0) {
            kontext.setPlausiAblauf(ablaufInfo.name);
            kontext.setInitWerte(initwerte);
            kontext.setLogger(new DefaultLogger(System.out));
            plausi.gesamtPlausi(new MockSatzInterface(), kontext);
        }
        return rc;
    }

    private static int mainForFeld(String[] args, BasePlausi plausi, PlausiKontext kontext) {
        System.err.println("Feldpruefungen stehen noch nicht zur Verfuegung.");
        return 1;
    }

    private static void printPlausiResult(BasePlausi plausi, PlausiKontext kontext) {
        System.out.println("Die Plausibilisierung " + plausi.getPlausiName() + " hat " + Integer.toString(kontext.getPlausiErgebnis()) + " als hoechstes Fehlergewicht geliefert.");
        if (kontext.getPlausiErgebnis() != 0) {
            System.out.println("Folgende Fehler wurden eingetragen:");
            for (int i = 0; i < kontext.getAnzahlFehler(); ++i) {
                PlausiFehler aFehler = kontext.getFehler(i);
                String referenzFeld = "n/a";
                if (aFehler.getReferenzFeld() != null) {
                    referenzFeld = ((FeldDeskriptorImpl)aFehler.getReferenzFeld()).hierarchyAsString();
                }
                System.out.println("Fehler-Id: " + aFehler.getFehlerId());
                System.out.println("   Schluessel   : " + aFehler.getFehlerSchluessel());
                System.out.println("   Referenz-Feld: " + referenzFeld);
                System.out.println("   Kurz         : " + aFehler.getFehlertextKurz());
                System.out.println("   Gewicht      : " + aFehler.getFehlerGewicht());
                System.out.println("   Lang         :");
                System.out.println("      " + aFehler.getFehlertextLang());
                System.out.println("   Korrektur    :");
                System.out.println("      " + aFehler.getFehlerKorrekturhinweis());
                System.out.println("   Involvierte Felder :");
                FeldDeskriptorInterface[] felder = aFehler.getFelder();
                for (int j = 0; j < felder.length; ++j) {
                    System.out.println("      " + ((FeldDeskriptorImpl)felder[j]).hierarchyAsString());
                }
                System.out.println("   Abschnitt, in dem der Fehler aufgetreten ist:");
                String[] abschnitte = aFehler.getAbschnittInfos();
                for (int j = 0; j < abschnitte.length; ++j) {
                    System.err.println("      " + abschnitte[j]);
                }
                System.err.println("\n");
            }
        }
    }

    private static int convertInputParameters(String[] inParams, Class[] types, Object[] values, int offset) {
        int rc = 0;
        if (values.length != inParams.length - offset) {
            System.err.println("Ungueltige Anzahl von Init-Werten (" + values.length + " erwartet).");
            rc = 1;
        } else {
            for (int i = 0; i < values.length; ++i) {
                try {
                    if (types[i] == String.class) {
                        values[i] = new String(inParams[i + offset]);
                        continue;
                    }
                    if (types[i] == Double.class) {
                        values[i] = new Double(inParams[i + offset]);
                        continue;
                    }
                    if (types[i] == Boolean.class) {
                        values[i] = new Boolean(inParams[i + offset]);
                        continue;
                    }
                    System.err.println("Erwarteter Typ '" + types[i].getName() + " fuer Init-Wert " + Integer.toString(i + 1) + " wird nicht unterstuetzt.");
                    rc = 1;
                    continue;
                }
                catch (Exception exc) {
                    System.err.println("Konverierung fuer Init-Wert " + Integer.toString(i + 1) + " fehlgeschlagen:\n" + exc.getClass().getName() + ":\n" + exc.getMessage());
                    rc = 1;
                }
            }
        }
        return rc;
    }

    private static BasePlausi createPlausiInstance(String plausi) throws Exception {
        String classname = "de.statspez.plausi.generated.Plausi_" + plausi;
        return (BasePlausi)Class.forName(classname).newInstance();
    }
}

